/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.cdp.javasound;

import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import net.sf.fmj.media.protocol.javasound.DataSource;
import net.sf.fmj.utility.LoggerSingleton;

public class CaptureDevicePlugger {
    private static final Logger logger = LoggerSingleton.logger;

    public void addCaptureDevices() {
        int index = 0;
        Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerInfo.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo[i]);
            Format[] formats = DataSource.querySupportedFormats(i);
            if (null == formats || formats.length <= 0) continue;
            CaptureDeviceInfo jmfInfo = new CaptureDeviceInfo("javasound:" + mixerInfo[i].getName() + ":" + index, new MediaLocator("javasound:#" + i), formats);
            ++index;
            if (CaptureDeviceManager.getDevice(jmfInfo.getName()) == null) {
                CaptureDeviceManager.addDevice(jmfInfo);
                logger.fine("CaptureDevicePlugger: Added " + jmfInfo.getLocator());
                continue;
            }
            logger.fine("CaptureDevicePlugger: Already present, skipping " + jmfInfo.getLocator());
        }
    }
}

