/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.web;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Closer;
import com.voxeo.utils.Enums;
import com.voxeo.utils.HTTP;
import com.voxeo.utils.Props;
import com.voxeo.versioning.Version;
import com.voxeo.web.CacheMode;
import com.voxeo.web.InvalidScriptException;
import com.voxeo.web.ResourceCompressor;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class ResourceFilter
implements Filter {
    private static final Loggerf log = Loggerf.getLogger(ResourceFilter.class);
    private static final String CACHE_MODE_PARAM = "cacheMode";
    private static final String CACHE_MODE_SYSTEM = "com.voxeo.web.resourceFilter.cacheMode";
    private static final String ENABLE_COMPRESSION_PARAM = "enableCompression";
    private static final String ENABLE_COMPRESSION_SYSTEM = "com.voxeo.web.resourceFilter.enableCompression";
    private static final String CACHE_TIMEOUT_SECONDS_PARAM = "cacheTimeoutSeconds";
    private static final String CACHE_TIMEOUT_SECONDS_SYSTEM = "com.voxeo.web.resourceFilter.cacheTimeoutSeconds";
    private String version;
    private String versionPrefix;
    private boolean enableCompression = false;
    private CacheMode cacheMode;
    private long cacheTimeoutMilli = 0L;
    private FilterConfig filterConfig;
    private ResourceCompressor resourceCompressor;

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.version = Version.get().getVersion();
        this.versionPrefix = "/" + this.version;
        this.resourceCompressor = new ResourceCompressor();
        this.enableCompression = Props.getBooleanSystemProperty(ENABLE_COMPRESSION_SYSTEM, config.getInitParameter(ENABLE_COMPRESSION_PARAM));
        this.cacheMode = Enums.valueOf(CacheMode.class, System.getProperty(CACHE_MODE_SYSTEM, config.getInitParameter(CACHE_MODE_PARAM)), CacheMode.DEFAULT);
        switch (this.cacheMode) {
            case BASIC: {
                Long cacheTimeoutSeconds = Props.getLongSystemProperty(CACHE_TIMEOUT_SECONDS_SYSTEM, config.getInitParameter(CACHE_TIMEOUT_SECONDS_PARAM));
                if (cacheTimeoutSeconds == null) break;
                this.cacheTimeoutMilli = cacheTimeoutSeconds * 1000L;
                break;
            }
            case FOREVER: {
                DateTime now = new DateTime();
                DateTime year = now.plusYears(5);
                this.cacheTimeoutMilli = new Interval((ReadableInstant)now, (ReadableInstant)year).toDurationMillis();
                break;
            }
        }
        log.info("Resource Filter Initialized [cacheMode=%s, enableCompression=%s, cacheTimeoutSeconds=%s]", new Object[]{this.cacheMode, this.enableCompression, this.cacheTimeoutMilli});
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String resourcePath;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!httpResponse.containsHeader("Expires")) {
            HTTP.setExpireHeaders(httpResponse, this.cacheTimeoutMilli);
        }
        if ((resourcePath = httpRequest.getServletPath()).contains(this.versionPrefix)) {
            String realPath = resourcePath.replace(this.versionPrefix, "");
            if (this.handleResource(response, realPath)) {
                log.debug("Handled resource %s", realPath);
            } else {
                log.debug("Skipped resource compression %s", realPath);
                RequestDispatcher dispatcher = request.getRequestDispatcher(realPath);
                dispatcher.forward(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean handleResource(ServletResponse response, String realPath) throws IOException {
        return this.enableCompression && this.resourceCompressor.handles(realPath) && this.handleCompressedResource(response, realPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleCompressedResource(ServletResponse response, String realPath) throws IOException {
        ServletContext servletContext = this.filterConfig.getServletContext();
        InputStream resourceStream = servletContext.getResourceAsStream(realPath);
        if (resourceStream != null) {
            try {
                String compressedResource = this.resourceCompressor.minify(realPath, resourceStream);
                response.setContentLength(compressedResource.length());
                ServletOutputStream outputStream = response.getOutputStream();
                outputStream.print(compressedResource);
                boolean bl = true;
                return bl;
            }
            catch (InvalidScriptException e) {
                log.error("Resource is invalid %s", realPath, e);
                boolean bl = false;
                return bl;
            }
            finally {
                Closer.close(resourceStream);
            }
        }
        return false;
    }

    public void destroy() {
    }
}

