/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.versioning;

import com.voxeo.versioning.AComponent;
import com.voxeo.versioning.Module;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Machine
extends AComponent {
    private static final long serialVersionUID = -2512507095020583681L;
    private final String name;
    private final String ip;

    public Machine(String name, String ip) {
        this.name = name;
        this.ip = ip;
    }

    public static Machine parseXML(InputStream is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = factory.newDocumentBuilder().parse(is);
        return Machine.parseXML(document.getDocumentElement());
    }

    public static Machine parseXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        return Machine.parseXML(document.getDocumentElement());
    }

    protected static Machine parseXML(Element documentElement) throws Exception {
        String name = documentElement.getAttribute("name");
        String ip = documentElement.getAttribute("ip");
        Machine machine = new Machine(name, ip);
        NodeList nodes = documentElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            Node item = nodes.item(i);
            if (!(item instanceof Element) || !"module".equals((element = (Element)item).getTagName())) continue;
            machine.addComponent(Module.parseXML(element));
        }
        return machine;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<machine name=\"" + this.name + "\" ip=\"" + this.ip + "\">");
        Iterator<AComponent> iterator = this.getComponents().iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next().toXML());
        }
        sb.append("</machine>");
        return sb.toString();
    }

    public String getIp() {
        return this.ip;
    }

    public String getName() {
        return this.name;
    }
}

