/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib;

import org.schwering.irc.lib.IRCUser;
import org.schwering.irc.lib.IRCUtil;

public class IRCParser {
    private StringBuffer buf;
    private int len;
    private String prefix;
    private String command;
    private String middle;
    private String trailing;
    private String[] parameters;

    public IRCParser(String line) {
        this(line, false);
    }

    public IRCParser(String line, boolean colorsEnabled) {
        int trail;
        int index = 0;
        this.buf = new StringBuffer(line);
        if (!colorsEnabled) {
            this.buf = IRCUtil.parseColors(this.buf);
        }
        this.len = this.buf.length();
        if (this.buf.charAt(0) == ':') {
            index = this.indexOf(32, index);
            this.prefix = this.buf.substring(1, index);
            ++index;
        }
        while (this.buf.charAt(index) == ' ') {
            ++index;
        }
        this.command = this.buf.substring(index, (index = this.indexOf(32, index)) != -1 ? index : (index = this.len));
        while (index < this.len && this.buf.charAt(index) == ' ') {
            ++index;
        }
        if ((trail = this.indexOf(" :", --index)) != -1) {
            this.trailing = this.buf.substring(trail + 2, this.len);
        } else {
            trail = this.lastIndexOf(32);
            if (trail != -1 && trail >= index) {
                this.trailing = this.buf.substring(trail + 1, this.len);
            }
        }
        this.middle = index < trail ? this.buf.substring(index + 1, trail) : "";
        this.prefix = this.prefix != null ? this.prefix : "";
        this.command = this.command != null ? this.command : "";
        this.middle = this.middle != null ? this.middle : "";
        this.trailing = this.trailing != null ? this.trailing : "";
    }

    private int indexOf(int c, int i) {
        while (i < this.len) {
            if (this.buf.charAt(i++) != c) continue;
            return --i;
        }
        return -1;
    }

    private int indexOf(String str, int i) {
        int sublen = str.length();
        int index = -1;
        while (i < this.len) {
            index = i;
            for (int j = 0; i < this.len && j < sublen && this.buf.charAt(i) == str.charAt(j); ++i, ++j) {
                if (j + 1 != sublen) continue;
                return index;
            }
            ++i;
        }
        return -1;
    }

    private int lastIndexOf(int c) {
        int i = this.len;
        boolean ok = false;
        while (i > 0) {
            if (this.buf.charAt(--i) != c) {
                ok = true;
                continue;
            }
            if (!ok) continue;
            return i;
        }
        return -1;
    }

    private void initParameters() {
        this.parameters = IRCUtil.split(this.middle, 32, this.trailing);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getCommand() {
        return this.command;
    }

    public String getMiddle() {
        return this.middle;
    }

    public String getTrailing() {
        return this.trailing;
    }

    public String getLine() {
        return this.buf.toString();
    }

    public String getParameters() {
        return String.valueOf(String.valueOf(this.middle).concat(String.valueOf(this.middle.length() != 0 && this.trailing.length() != 0 ? " " : ""))).concat(String.valueOf(this.trailing));
    }

    public String getNick() {
        int i = this.prefix.indexOf(33);
        if (i != -1 || (i = this.prefix.indexOf(64)) != -1) {
            return this.prefix.substring(0, i);
        }
        return this.prefix.length() != 0 ? this.prefix : null;
    }

    public String getServername() {
        return this.getNick();
    }

    public String getUsername() {
        int i = this.prefix.indexOf(33) + 1;
        if (i != 0) {
            int j = this.prefix.indexOf(64, i);
            return this.prefix.substring(i, j != -1 ? j : this.prefix.length());
        }
        return null;
    }

    public String getHost() {
        int i = this.prefix.indexOf(64) + 1;
        if (i != 0) {
            return this.prefix.substring(i, this.prefix.length());
        }
        return null;
    }

    public IRCUser getUser() {
        return new IRCUser(this.getNick(), this.getUsername(), this.getHost());
    }

    public int getParameterCount() {
        if (this.parameters == null) {
            this.initParameters();
        }
        return this.parameters.length;
    }

    public String getParameter(int i) {
        if (this.parameters == null) {
            this.initParameters();
        }
        if (--i >= 0 && i < this.parameters.length) {
            return this.parameters[i];
        }
        return "";
    }

    public String getParametersFrom(int i) {
        if (this.parameters == null) {
            this.initParameters();
        }
        StringBuffer params = new StringBuffer();
        --i;
        while (i < this.parameters.length) {
            params.append(String.valueOf(this.parameters[i]).concat(String.valueOf(" ")));
            ++i;
        }
        return params.toString();
    }

    public String getParametersTo(int i) {
        if (this.parameters == null) {
            this.initParameters();
        }
        StringBuffer params = new StringBuffer();
        int max = i < this.parameters.length ? i : this.parameters.length;
        for (i = 0; i < max; ++i) {
            params.append(String.valueOf(this.parameters[i]).concat(String.valueOf(" ")));
        }
        return params.toString();
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.getClass().getName()).concat(String.valueOf("["))).concat(String.valueOf(this.prefix))).concat(String.valueOf(","))).concat(String.valueOf(this.command))).concat(String.valueOf(","))).concat(String.valueOf(this.middle))).concat(String.valueOf(","))).concat(String.valueOf(this.trailing))).concat(String.valueOf("]"));
    }
}

