/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.compat.BaseV10Converter;
import uk.ltd.getahead.dwr.util.JavascriptUtil;
import uk.ltd.getahead.dwr.util.LocalUtil;

public class JDOMConverter
extends BaseV10Converter
implements Converter {
    private JavascriptUtil jsutil = new JavascriptUtil();

    public void setConverterManager(ConverterManager newConfig) {
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        String value = LocalUtil.decode(iv.getValue());
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(value));
            if (paramType == Document.class) {
                return doc;
            }
            if (paramType == Element.class) {
                return doc.getRootElement();
            }
            throw new ConversionException(Messages.getString("DOMConverter.UnusableClass", paramType.getName()));
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }

    public String convertOutbound(Object data, String varname, OutboundContext outctx) throws ConversionException {
        try {
            Format outformat = Format.getCompactFormat();
            outformat.setEncoding("UTF-8");
            StringWriter xml = new StringWriter();
            XMLOutputter writer = new XMLOutputter(outformat);
            if (data instanceof Document) {
                Document doc = (Document)data;
                writer.output(doc, (Writer)xml);
            } else if (data instanceof Element) {
                Element ele = (Element)data;
                writer.output(ele, (Writer)xml);
            } else {
                throw new ConversionException("Data is not a DOM Node");
            }
            xml.flush();
            StringBuffer buffer = new StringBuffer();
            buffer.append("var ");
            buffer.append(varname);
            buffer.append("=DWREngine._unserializeDocument(\"");
            buffer.append(this.jsutil.escapeJavaScript(xml.toString()));
            buffer.append("\");");
            return buffer.toString();
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }
}

