/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.VersionedStringProperty;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CharsetMapping {
    private static final Properties CHARSET_CONFIG;
    public static final String[] INDEX_TO_CHARSET;
    private static final Map JAVA_TO_MYSQL_CHARSET_MAP;
    private static final Map JAVA_UC_TO_MYSQL_CHARSET_MAP;
    private static final Map MULTIBYTE_CHARSETS;
    private static final Map MYSQL_TO_JAVA_CHARSET_MAP;
    static /* synthetic */ Class class$com$mysql$jdbc$CharsetMapping;

    static final String getJavaEncodingForMysqlEncoding(String mysqlEncoding, Connection conn) throws SQLException {
        return (String)MYSQL_TO_JAVA_CHARSET_MAP.get(mysqlEncoding);
    }

    static final String getMysqlEncodingForJavaEncoding(String javaEncodingUC, Connection conn) throws SQLException {
        List mysqlEncodings = (List)JAVA_UC_TO_MYSQL_CHARSET_MAP.get(javaEncodingUC);
        if (mysqlEncodings != null) {
            Iterator iter = mysqlEncodings.iterator();
            VersionedStringProperty versionedProp = null;
            while (iter.hasNext()) {
                VersionedStringProperty propToCheck = (VersionedStringProperty)iter.next();
                if (conn == null) {
                    return propToCheck.toString();
                }
                if (versionedProp != null && !versionedProp.preferredValue && versionedProp.majorVersion == propToCheck.majorVersion && versionedProp.minorVersion == propToCheck.minorVersion && versionedProp.subminorVersion == propToCheck.subminorVersion) {
                    return versionedProp.toString();
                }
                if (!propToCheck.isOkayForVersion(conn)) break;
                if (propToCheck.preferredValue) {
                    return propToCheck.toString();
                }
                versionedProp = propToCheck;
            }
            if (versionedProp != null) {
                return versionedProp.toString();
            }
        }
        return null;
    }

    static final int getNumberOfCharsetsConfigured() {
        return MYSQL_TO_JAVA_CHARSET_MAP.size() / 2;
    }

    static final boolean isAliasForSjis(String encoding) {
        return "SJIS".equalsIgnoreCase(encoding) || "WINDOWS-31J".equalsIgnoreCase(encoding) || "MS932".equalsIgnoreCase(encoding) || "SHIFT_JIS".equalsIgnoreCase(encoding) || "CP943".equalsIgnoreCase(encoding);
    }

    static final boolean isMultibyteCharset(String javaEncodingName) {
        String javaEncodingNameUC = javaEncodingName.toUpperCase(Locale.ENGLISH);
        return MULTIBYTE_CHARSETS.containsKey(javaEncodingNameUC);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void populateMapWithKeyValuePairs(String configKey, Map mapToPopulate, boolean addVersionedProperties, boolean addUppercaseKeys) {
        String javaToMysqlConfig = CHARSET_CONFIG.getProperty(configKey);
        if (javaToMysqlConfig == null) throw new RuntimeException("Could not find configuration value \"" + configKey + "\" in Charsets.properties resource");
        List mappings = StringUtils.split(javaToMysqlConfig, ",", true);
        if (mappings == null) throw new RuntimeException("Missing/corrupt entry for \"" + configKey + "\" in Charsets.properties.");
        Iterator mappingsIter = mappings.iterator();
        while (mappingsIter.hasNext()) {
            String aMapping = (String)mappingsIter.next();
            List parsedPair = StringUtils.split(aMapping, "=", true);
            if (parsedPair.size() != 2) throw new RuntimeException("Syntax error in Charsets.properties resource for token \"" + aMapping + "\".");
            String key = parsedPair.get(0).toString();
            String value = parsedPair.get(1).toString();
            if (addVersionedProperties) {
                List<VersionedStringProperty> versionedProperties = (ArrayList<VersionedStringProperty>)mapToPopulate.get(key);
                if (versionedProperties == null) {
                    versionedProperties = new ArrayList<VersionedStringProperty>();
                    mapToPopulate.put(key, versionedProperties);
                }
                VersionedStringProperty verProp = new VersionedStringProperty(value);
                versionedProperties.add(verProp);
                if (!addUppercaseKeys) continue;
                String keyUc = key.toUpperCase(Locale.ENGLISH);
                versionedProperties = (List)mapToPopulate.get(keyUc);
                if (versionedProperties == null) {
                    versionedProperties = new ArrayList();
                    mapToPopulate.put(keyUc, versionedProperties);
                }
                versionedProperties.add(verProp);
                continue;
            }
            mapToPopulate.put(key, value);
            if (!addUppercaseKeys) continue;
            mapToPopulate.put(key.toUpperCase(Locale.ENGLISH), value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block13: {
            CHARSET_CONFIG = new Properties();
            InputStream inStream = (class$com$mysql$jdbc$CharsetMapping == null ? (class$com$mysql$jdbc$CharsetMapping = CharsetMapping.class$("com.mysql.jdbc.CharsetMapping")) : class$com$mysql$jdbc$CharsetMapping).getResourceAsStream("/com/mysql/jdbc/Charsets.properties");
            if (inStream == null) {
                throw new RuntimeException("Unable to initialize character set mapping tables");
            }
            try {
                try {
                    CHARSET_CONFIG.load(inStream);
                    inStream.close();
                    inStream = null;
                }
                catch (IOException ioEx) {
                    throw new RuntimeException("Unable to initialize character set mapping tables");
                }
                Object var3_1 = null;
                if (inStream == null) break block13;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                if (inStream == null) throw throwable;
                try {
                    inStream.close();
                    throw throwable;
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ioEx) {}
            inStream.close();
        }
        HashMap javaToMysqlMap = new HashMap();
        CharsetMapping.populateMapWithKeyValuePairs("javaToMysqlMappings", javaToMysqlMap, true, false);
        JAVA_TO_MYSQL_CHARSET_MAP = Collections.unmodifiableMap(javaToMysqlMap);
        HashMap mysqlToJavaMap = new HashMap();
        Set keySet = JAVA_TO_MYSQL_CHARSET_MAP.keySet();
        Iterator javaCharsets = keySet.iterator();
        while (javaCharsets.hasNext()) {
            Object javaEncodingName = javaCharsets.next();
            List mysqlEncodingList = (List)JAVA_TO_MYSQL_CHARSET_MAP.get(javaEncodingName);
            Iterator mysqlEncodings = mysqlEncodingList.iterator();
            String mysqlEncodingName = null;
            while (mysqlEncodings.hasNext()) {
                VersionedStringProperty mysqlProp = (VersionedStringProperty)mysqlEncodings.next();
                mysqlEncodingName = mysqlProp.toString();
                mysqlToJavaMap.put(mysqlEncodingName, javaEncodingName);
                mysqlToJavaMap.put(mysqlEncodingName.toUpperCase(Locale.ENGLISH), javaEncodingName);
            }
        }
        mysqlToJavaMap.put("cp932", "Windows-31J");
        mysqlToJavaMap.put("CP932", "Windows-31J");
        MYSQL_TO_JAVA_CHARSET_MAP = Collections.unmodifiableMap(mysqlToJavaMap);
        HashMap ucMap = new HashMap(JAVA_TO_MYSQL_CHARSET_MAP.size());
        Iterator javaNamesKeys = JAVA_TO_MYSQL_CHARSET_MAP.keySet().iterator();
        while (javaNamesKeys.hasNext()) {
            String key = (String)javaNamesKeys.next();
            ucMap.put(key.toUpperCase(Locale.ENGLISH), JAVA_TO_MYSQL_CHARSET_MAP.get(key));
        }
        JAVA_UC_TO_MYSQL_CHARSET_MAP = Collections.unmodifiableMap(ucMap);
        HashMap tempMapMulti = new HashMap();
        CharsetMapping.populateMapWithKeyValuePairs("multibyteCharsets", tempMapMulti, false, true);
        MULTIBYTE_CHARSETS = Collections.unmodifiableMap(tempMapMulti);
        INDEX_TO_CHARSET = new String[99];
        try {
            CharsetMapping.INDEX_TO_CHARSET[1] = CharsetMapping.getJavaEncodingForMysqlEncoding("big5", null);
            CharsetMapping.INDEX_TO_CHARSET[2] = CharsetMapping.getJavaEncodingForMysqlEncoding("czech", null);
            CharsetMapping.INDEX_TO_CHARSET[3] = CharsetMapping.getJavaEncodingForMysqlEncoding("dec8", null);
            CharsetMapping.INDEX_TO_CHARSET[4] = CharsetMapping.getJavaEncodingForMysqlEncoding("dos", null);
            CharsetMapping.INDEX_TO_CHARSET[5] = CharsetMapping.getJavaEncodingForMysqlEncoding("german1", null);
            CharsetMapping.INDEX_TO_CHARSET[6] = CharsetMapping.getJavaEncodingForMysqlEncoding("hp8", null);
            CharsetMapping.INDEX_TO_CHARSET[7] = CharsetMapping.getJavaEncodingForMysqlEncoding("koi8_ru", null);
            CharsetMapping.INDEX_TO_CHARSET[8] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin1", null);
            CharsetMapping.INDEX_TO_CHARSET[9] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin2", null);
            CharsetMapping.INDEX_TO_CHARSET[10] = CharsetMapping.getJavaEncodingForMysqlEncoding("swe7", null);
            CharsetMapping.INDEX_TO_CHARSET[11] = CharsetMapping.getJavaEncodingForMysqlEncoding("usa7", null);
            CharsetMapping.INDEX_TO_CHARSET[12] = CharsetMapping.getJavaEncodingForMysqlEncoding("ujis", null);
            CharsetMapping.INDEX_TO_CHARSET[13] = CharsetMapping.getJavaEncodingForMysqlEncoding("sjis", null);
            CharsetMapping.INDEX_TO_CHARSET[14] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1251", null);
            CharsetMapping.INDEX_TO_CHARSET[15] = CharsetMapping.getJavaEncodingForMysqlEncoding("danish", null);
            CharsetMapping.INDEX_TO_CHARSET[16] = CharsetMapping.getJavaEncodingForMysqlEncoding("hebrew", null);
            CharsetMapping.INDEX_TO_CHARSET[18] = CharsetMapping.getJavaEncodingForMysqlEncoding("tis620", null);
            CharsetMapping.INDEX_TO_CHARSET[19] = CharsetMapping.getJavaEncodingForMysqlEncoding("euc_kr", null);
            CharsetMapping.INDEX_TO_CHARSET[20] = CharsetMapping.getJavaEncodingForMysqlEncoding("estonia", null);
            CharsetMapping.INDEX_TO_CHARSET[21] = CharsetMapping.getJavaEncodingForMysqlEncoding("hungarian", null);
            CharsetMapping.INDEX_TO_CHARSET[22] = CharsetMapping.getJavaEncodingForMysqlEncoding("koi8_ukr", null);
            CharsetMapping.INDEX_TO_CHARSET[23] = CharsetMapping.getJavaEncodingForMysqlEncoding("win1251ukr", null);
            CharsetMapping.INDEX_TO_CHARSET[24] = CharsetMapping.getJavaEncodingForMysqlEncoding("gb2312", null);
            CharsetMapping.INDEX_TO_CHARSET[25] = CharsetMapping.getJavaEncodingForMysqlEncoding("greek", null);
            CharsetMapping.INDEX_TO_CHARSET[26] = CharsetMapping.getJavaEncodingForMysqlEncoding("win1250", null);
            CharsetMapping.INDEX_TO_CHARSET[27] = CharsetMapping.getJavaEncodingForMysqlEncoding("croat", null);
            CharsetMapping.INDEX_TO_CHARSET[28] = CharsetMapping.getJavaEncodingForMysqlEncoding("gbk", null);
            CharsetMapping.INDEX_TO_CHARSET[29] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1257", null);
            CharsetMapping.INDEX_TO_CHARSET[30] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin5", null);
            CharsetMapping.INDEX_TO_CHARSET[31] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin1_de", null);
            CharsetMapping.INDEX_TO_CHARSET[32] = CharsetMapping.getJavaEncodingForMysqlEncoding("armscii8", null);
            CharsetMapping.INDEX_TO_CHARSET[33] = CharsetMapping.getJavaEncodingForMysqlEncoding("utf8", null);
            CharsetMapping.INDEX_TO_CHARSET[34] = CharsetMapping.getJavaEncodingForMysqlEncoding("win1250ch", null);
            CharsetMapping.INDEX_TO_CHARSET[35] = CharsetMapping.getJavaEncodingForMysqlEncoding("ucs2", null);
            CharsetMapping.INDEX_TO_CHARSET[36] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp866", null);
            CharsetMapping.INDEX_TO_CHARSET[37] = CharsetMapping.getJavaEncodingForMysqlEncoding("keybcs2", null);
            CharsetMapping.INDEX_TO_CHARSET[38] = CharsetMapping.getJavaEncodingForMysqlEncoding("macce", null);
            CharsetMapping.INDEX_TO_CHARSET[39] = CharsetMapping.getJavaEncodingForMysqlEncoding("macroman", null);
            CharsetMapping.INDEX_TO_CHARSET[40] = CharsetMapping.getJavaEncodingForMysqlEncoding("pclatin2", null);
            CharsetMapping.INDEX_TO_CHARSET[41] = CharsetMapping.getJavaEncodingForMysqlEncoding("latvian", null);
            CharsetMapping.INDEX_TO_CHARSET[42] = CharsetMapping.getJavaEncodingForMysqlEncoding("latvian1", null);
            CharsetMapping.INDEX_TO_CHARSET[43] = CharsetMapping.getJavaEncodingForMysqlEncoding("maccebin", null);
            CharsetMapping.INDEX_TO_CHARSET[44] = CharsetMapping.getJavaEncodingForMysqlEncoding("macceciai", null);
            CharsetMapping.INDEX_TO_CHARSET[45] = CharsetMapping.getJavaEncodingForMysqlEncoding("maccecias", null);
            CharsetMapping.INDEX_TO_CHARSET[46] = CharsetMapping.getJavaEncodingForMysqlEncoding("maccecsas", null);
            CharsetMapping.INDEX_TO_CHARSET[47] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin1bin", null);
            CharsetMapping.INDEX_TO_CHARSET[48] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin1cias", null);
            CharsetMapping.INDEX_TO_CHARSET[49] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin1csas", null);
            CharsetMapping.INDEX_TO_CHARSET[50] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1251bin", null);
            CharsetMapping.INDEX_TO_CHARSET[51] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1251cias", null);
            CharsetMapping.INDEX_TO_CHARSET[52] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1251csas", null);
            CharsetMapping.INDEX_TO_CHARSET[53] = CharsetMapping.getJavaEncodingForMysqlEncoding("macromanbin", null);
            CharsetMapping.INDEX_TO_CHARSET[54] = CharsetMapping.getJavaEncodingForMysqlEncoding("macromancias", null);
            CharsetMapping.INDEX_TO_CHARSET[55] = CharsetMapping.getJavaEncodingForMysqlEncoding("macromanciai", null);
            CharsetMapping.INDEX_TO_CHARSET[56] = CharsetMapping.getJavaEncodingForMysqlEncoding("macromancsas", null);
            CharsetMapping.INDEX_TO_CHARSET[57] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1256", null);
            CharsetMapping.INDEX_TO_CHARSET[63] = CharsetMapping.getJavaEncodingForMysqlEncoding("binary", null);
            CharsetMapping.INDEX_TO_CHARSET[64] = CharsetMapping.getJavaEncodingForMysqlEncoding("armscii", null);
            CharsetMapping.INDEX_TO_CHARSET[65] = CharsetMapping.getJavaEncodingForMysqlEncoding("ascii", null);
            CharsetMapping.INDEX_TO_CHARSET[66] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1250", null);
            CharsetMapping.INDEX_TO_CHARSET[67] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp1256", null);
            CharsetMapping.INDEX_TO_CHARSET[68] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp866", null);
            CharsetMapping.INDEX_TO_CHARSET[69] = CharsetMapping.getJavaEncodingForMysqlEncoding("dec8", null);
            CharsetMapping.INDEX_TO_CHARSET[70] = CharsetMapping.getJavaEncodingForMysqlEncoding("greek", null);
            CharsetMapping.INDEX_TO_CHARSET[71] = CharsetMapping.getJavaEncodingForMysqlEncoding("hebrew", null);
            CharsetMapping.INDEX_TO_CHARSET[72] = CharsetMapping.getJavaEncodingForMysqlEncoding("hp8", null);
            CharsetMapping.INDEX_TO_CHARSET[73] = CharsetMapping.getJavaEncodingForMysqlEncoding("keybcs2", null);
            CharsetMapping.INDEX_TO_CHARSET[74] = CharsetMapping.getJavaEncodingForMysqlEncoding("koi8r", null);
            CharsetMapping.INDEX_TO_CHARSET[75] = CharsetMapping.getJavaEncodingForMysqlEncoding("koi8ukr", null);
            CharsetMapping.INDEX_TO_CHARSET[77] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin2", null);
            CharsetMapping.INDEX_TO_CHARSET[78] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin5", null);
            CharsetMapping.INDEX_TO_CHARSET[79] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin7", null);
            CharsetMapping.INDEX_TO_CHARSET[80] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp850", null);
            CharsetMapping.INDEX_TO_CHARSET[81] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp852", null);
            CharsetMapping.INDEX_TO_CHARSET[82] = CharsetMapping.getJavaEncodingForMysqlEncoding("swe7", null);
            CharsetMapping.INDEX_TO_CHARSET[83] = CharsetMapping.getJavaEncodingForMysqlEncoding("utf8", null);
            CharsetMapping.INDEX_TO_CHARSET[84] = CharsetMapping.getJavaEncodingForMysqlEncoding("big5", null);
            CharsetMapping.INDEX_TO_CHARSET[85] = CharsetMapping.getJavaEncodingForMysqlEncoding("euckr", null);
            CharsetMapping.INDEX_TO_CHARSET[86] = CharsetMapping.getJavaEncodingForMysqlEncoding("gb2312", null);
            CharsetMapping.INDEX_TO_CHARSET[87] = CharsetMapping.getJavaEncodingForMysqlEncoding("gbk", null);
            CharsetMapping.INDEX_TO_CHARSET[88] = CharsetMapping.getJavaEncodingForMysqlEncoding("sjis", null);
            CharsetMapping.INDEX_TO_CHARSET[89] = CharsetMapping.getJavaEncodingForMysqlEncoding("tis620", null);
            CharsetMapping.INDEX_TO_CHARSET[90] = CharsetMapping.getJavaEncodingForMysqlEncoding("ucs2", null);
            CharsetMapping.INDEX_TO_CHARSET[91] = CharsetMapping.getJavaEncodingForMysqlEncoding("ujis", null);
            CharsetMapping.INDEX_TO_CHARSET[92] = CharsetMapping.getJavaEncodingForMysqlEncoding("geostd8", null);
            CharsetMapping.INDEX_TO_CHARSET[93] = CharsetMapping.getJavaEncodingForMysqlEncoding("geostd8", null);
            CharsetMapping.INDEX_TO_CHARSET[94] = CharsetMapping.getJavaEncodingForMysqlEncoding("latin1", null);
            CharsetMapping.INDEX_TO_CHARSET[95] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp932", null);
            CharsetMapping.INDEX_TO_CHARSET[96] = CharsetMapping.getJavaEncodingForMysqlEncoding("cp932", null);
            CharsetMapping.INDEX_TO_CHARSET[97] = CharsetMapping.getJavaEncodingForMysqlEncoding("eucjpms", null);
            CharsetMapping.INDEX_TO_CHARSET[98] = CharsetMapping.getJavaEncodingForMysqlEncoding("eucjpms", null);
            return;
        }
        catch (SQLException sqlEx) {
            // empty catch block
        }
    }
}

