/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.MultipleRecipientInfo;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.packet.MultipleAddresses;

public class MultipleRecipientManager {
    private static Cache services = new Cache(100, 86400000L);

    public static void send(XMPPConnection connection, Packet packet, List to, List cc, List bcc) throws XMPPException {
        MultipleRecipientManager.send(connection, packet, to, cc, bcc, null, null, false);
    }

    public static void send(XMPPConnection connection, Packet packet, List to, List cc, List bcc, String replyTo, String replyRoom, boolean noReply) throws XMPPException {
        String serviceAddress = MultipleRecipientManager.getMultipleRecipienServiceAddress(connection);
        if (serviceAddress != null) {
            MultipleRecipientManager.sendThroughService(connection, packet, to, cc, bcc, replyTo, replyRoom, noReply, serviceAddress);
        } else {
            if (noReply || replyTo != null && replyTo.trim().length() > 0 || replyRoom != null && replyRoom.trim().length() > 0) {
                throw new XMPPException("Extended Stanza Addressing not supported by server");
            }
            MultipleRecipientManager.sendToIndividualRecipients(connection, packet, to, cc, bcc);
        }
    }

    public static void reply(XMPPConnection connection, Message original, Message reply) throws XMPPException {
        MultipleAddresses.Address replyAddress;
        MultipleRecipientInfo info = MultipleRecipientManager.getMultipleRecipientInfo(original);
        if (info == null) {
            throw new XMPPException("Original message does not contain multiple recipient info");
        }
        if (info.shouldNotReply()) {
            throw new XMPPException("Original message should not be replied");
        }
        if (info.getReplyRoom() != null) {
            throw new XMPPException("Reply should be sent through a room");
        }
        if (original.getThread() != null) {
            reply.setThread(original.getThread());
        }
        if ((replyAddress = info.getReplyAddress()) != null && replyAddress.getJid() != null) {
            reply.setTo(replyAddress.getJid());
            connection.sendPacket(reply);
        } else {
            String serviceAddress;
            String from;
            String jid;
            ArrayList<String> to = new ArrayList<String>();
            ArrayList<String> cc = new ArrayList<String>();
            Iterator it = info.getTOAddresses().iterator();
            while (it.hasNext()) {
                jid = ((MultipleAddresses.Address)it.next()).getJid();
                to.add(jid);
            }
            it = info.getCCAddresses().iterator();
            while (it.hasNext()) {
                jid = ((MultipleAddresses.Address)it.next()).getJid();
                cc.add(jid);
            }
            if (!to.contains(original.getFrom()) && !cc.contains(original.getFrom())) {
                to.add(original.getFrom());
            }
            if (!to.remove(from = connection.getUser()) && !cc.remove(from)) {
                String bareJID = StringUtils.parseBareAddress(from);
                to.remove(bareJID);
                cc.remove(bareJID);
            }
            if ((serviceAddress = MultipleRecipientManager.getMultipleRecipienServiceAddress(connection)) != null) {
                MultipleRecipientManager.sendThroughService(connection, reply, to, cc, null, null, null, false, serviceAddress);
            } else {
                MultipleRecipientManager.sendToIndividualRecipients(connection, reply, to, cc, null);
            }
        }
    }

    public static MultipleRecipientInfo getMultipleRecipientInfo(Packet packet) {
        MultipleAddresses extension = (MultipleAddresses)packet.getExtension("addresses", "http://jabber.org/protocol/address");
        return extension == null ? null : new MultipleRecipientInfo(extension);
    }

    private static void sendToIndividualRecipients(XMPPConnection connection, Packet packet, List to, List cc, List bcc) {
        if (to != null) {
            for (String jid : to) {
                packet.setTo(jid);
                connection.sendPacket(new PacketCopy(packet.toXML()));
            }
        }
        if (cc != null) {
            for (String jid : cc) {
                packet.setTo(jid);
                connection.sendPacket(new PacketCopy(packet.toXML()));
            }
        }
        if (bcc != null) {
            for (String jid : bcc) {
                packet.setTo(jid);
                connection.sendPacket(new PacketCopy(packet.toXML()));
            }
        }
    }

    private static void sendThroughService(XMPPConnection connection, Packet packet, List to, List cc, List bcc, String replyTo, String replyRoom, boolean noReply, String serviceAddress) {
        MultipleAddresses multipleAddresses = new MultipleAddresses();
        if (to != null) {
            for (String jid : to) {
                multipleAddresses.addAddress("to", jid, null, null, false, null);
            }
        }
        if (cc != null) {
            for (String jid : cc) {
                multipleAddresses.addAddress("cc", jid, null, null, false, null);
            }
        }
        if (bcc != null) {
            for (String jid : bcc) {
                multipleAddresses.addAddress("bcc", jid, null, null, false, null);
            }
        }
        if (noReply) {
            multipleAddresses.setNoReply();
        } else {
            if (replyTo != null && replyTo.trim().length() > 0) {
                multipleAddresses.addAddress("replyto", replyTo, null, null, false, null);
            }
            if (replyRoom != null && replyRoom.trim().length() > 0) {
                multipleAddresses.addAddress("replyroom", replyRoom, null, null, false, null);
            }
        }
        packet.setTo(serviceAddress);
        packet.addExtension(multipleAddresses);
        connection.sendPacket(packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMultipleRecipienServiceAddress(XMPPConnection connection) {
        String serviceName = connection.getServiceName();
        String serviceAddress = (String)services.get(serviceName);
        if (serviceAddress == null) {
            Cache cache = services;
            synchronized (cache) {
                serviceAddress = (String)services.get(serviceName);
                if (serviceAddress == null) {
                    try {
                        DiscoverInfo info = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(serviceName);
                        if (info.containsFeature("http://jabber.org/protocol/address")) {
                            serviceAddress = serviceName;
                        } else {
                            DiscoverItems items = ServiceDiscoveryManager.getInstanceFor(connection).discoverItems(serviceName);
                            Iterator<DiscoverItems.Item> it = items.getItems();
                            while (it.hasNext()) {
                                DiscoverItems.Item item = it.next();
                                info = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(item.getEntityID(), item.getNode());
                                if (!info.containsFeature("http://jabber.org/protocol/address")) continue;
                                serviceAddress = serviceName;
                                break;
                            }
                        }
                        services.put(serviceName, serviceAddress == null ? "" : serviceAddress);
                    }
                    catch (XMPPException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return "".equals(serviceAddress) ? null : serviceAddress;
    }

    private static class PacketCopy
    extends Packet {
        private String text;

        public PacketCopy(String text) {
            this.text = text;
        }

        public String toXML() {
            return this.text;
        }
    }
}

