/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import org.jrobin.core.jrrd.DataSourceType;
import org.jrobin.core.jrrd.PDPStatusBlock;
import org.jrobin.core.jrrd.RRDFile;

public class DataSource {
    long offset;
    long size;
    String name;
    DataSourceType type;
    int minimumHeartbeat;
    double minimum;
    double maximum;
    PDPStatusBlock pdpStatusBlock;

    DataSource(RRDFile rRDFile) throws IOException {
        this.offset = rRDFile.getFilePointer();
        this.name = rRDFile.readString(20);
        this.type = DataSourceType.get(rRDFile.readString(20));
        rRDFile.align(8);
        this.minimumHeartbeat = rRDFile.readInt(true);
        rRDFile.align(8);
        this.minimum = rRDFile.readDouble();
        this.maximum = rRDFile.readDouble();
        rRDFile.align();
        rRDFile.skipBytes(56);
        this.size = rRDFile.getFilePointer() - this.offset;
    }

    void loadPDPStatusBlock(RRDFile rRDFile) throws IOException {
        this.pdpStatusBlock = new PDPStatusBlock(rRDFile);
    }

    public PDPStatusBlock getPDPStatusBlock() {
        return this.pdpStatusBlock;
    }

    public int getMinimumHeartbeat() {
        return this.minimumHeartbeat;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public DataSourceType getType() {
        return this.type;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public String getName() {
        return this.name;
    }

    void printInfo(PrintStream printStream, NumberFormat numberFormat) {
        StringBuffer stringBuffer = new StringBuffer("ds[");
        stringBuffer.append(this.name);
        printStream.print(stringBuffer);
        printStream.print("].type = \"");
        printStream.print(this.type);
        printStream.println("\"");
        printStream.print(stringBuffer);
        printStream.print("].minimal_heartbeat = ");
        printStream.println(this.minimumHeartbeat);
        printStream.print(stringBuffer);
        printStream.print("].min = ");
        printStream.println(Double.isNaN(this.minimum) ? "NaN" : numberFormat.format(this.minimum));
        printStream.print(stringBuffer);
        printStream.print("].max = ");
        printStream.println(Double.isNaN(this.maximum) ? "NaN" : numberFormat.format(this.maximum));
        printStream.print(stringBuffer);
        printStream.print("].last_ds = ");
        printStream.println(this.pdpStatusBlock.lastReading);
        printStream.print(stringBuffer);
        printStream.print("].value = ");
        double d = this.pdpStatusBlock.value;
        printStream.println(Double.isNaN(d) ? "NaN" : numberFormat.format(d));
        printStream.print(stringBuffer);
        printStream.print("].unknown_sec = ");
        printStream.println(this.pdpStatusBlock.unknownSeconds);
    }

    void toXml(PrintStream printStream) {
        printStream.println("\t<ds>");
        printStream.print("\t\t<name> ");
        printStream.print(this.name);
        printStream.println(" </name>");
        printStream.print("\t\t<type> ");
        printStream.print(this.type);
        printStream.println(" </type>");
        printStream.print("\t\t<minimal_heartbeat> ");
        printStream.print(this.minimumHeartbeat);
        printStream.println(" </minimal_heartbeat>");
        printStream.print("\t\t<min> ");
        printStream.print(this.minimum);
        printStream.println(" </min>");
        printStream.print("\t\t<max> ");
        printStream.print(this.maximum);
        printStream.println(" </max>");
        printStream.println();
        printStream.println("\t\t<!-- PDP Status -->");
        printStream.print("\t\t<last_ds> ");
        printStream.print(this.pdpStatusBlock.lastReading);
        printStream.println(" </last_ds>");
        printStream.print("\t\t<value> ");
        printStream.print(this.pdpStatusBlock.value);
        printStream.println(" </value>");
        printStream.print("\t\t<unknown_sec> ");
        printStream.print(this.pdpStatusBlock.unknownSeconds);
        printStream.println(" </unknown_sec>");
        printStream.println("\t</ds>");
        printStream.println();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[DataSource: OFFSET=0x");
        stringBuffer.append(Long.toHexString(this.offset));
        stringBuffer.append(", SIZE=0x");
        stringBuffer.append(Long.toHexString(this.size));
        stringBuffer.append(", name=");
        stringBuffer.append(this.name);
        stringBuffer.append(", type=");
        stringBuffer.append(this.type.toString());
        stringBuffer.append(", minHeartbeat=");
        stringBuffer.append(this.minimumHeartbeat);
        stringBuffer.append(", min=");
        stringBuffer.append(this.minimum);
        stringBuffer.append(", max=");
        stringBuffer.append(this.maximum);
        stringBuffer.append("]");
        stringBuffer.append("\n\t\t");
        stringBuffer.append(this.pdpStatusBlock.toString());
        return stringBuffer.toString();
    }
}

