/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.util.HashMap;
import org.jrobin.core.RrdBackendFactory;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFileBackendFactory;
import org.jrobin.core.Util;

public class RrdDbPool {
    public static final int INITIAL_CAPACITY = 200;
    private static RrdDbPool instance;
    private int capacity = 200;
    private HashMap<String, RrdEntry> rrdMap = new HashMap(200);

    public static synchronized RrdDbPool getInstance() throws RrdException {
        if (instance == null) {
            instance = new RrdDbPool();
        }
        return instance;
    }

    private RrdDbPool() throws RrdException {
        RrdBackendFactory rrdBackendFactory = RrdBackendFactory.getDefaultFactory();
        if (!(rrdBackendFactory instanceof RrdFileBackendFactory)) {
            throw new RrdException("Cannot create instance of " + this.getClass().getName() + " with " + "a default backend factory not derived from RrdFileBackendFactory");
        }
    }

    public synchronized RrdDb requestRrdDb(String string) throws IOException, RrdException {
        String string2 = Util.getCanonicalPath(string);
        while (!this.rrdMap.containsKey(string2) && this.rrdMap.size() >= this.capacity) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new RrdException(interruptedException);
            }
        }
        if (this.rrdMap.containsKey(string2)) {
            RrdEntry rrdEntry = this.rrdMap.get(string2);
            ++rrdEntry.count;
            return rrdEntry.rrdDb;
        }
        RrdDb rrdDb = new RrdDb(string2);
        this.rrdMap.put(string2, new RrdEntry(rrdDb));
        return rrdDb;
    }

    public synchronized RrdDb requestRrdDb(RrdDef rrdDef) throws IOException, RrdException {
        String string = Util.getCanonicalPath(rrdDef.getPath());
        while (this.rrdMap.containsKey(string) || this.rrdMap.size() >= this.capacity) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new RrdException(interruptedException);
            }
        }
        RrdDb rrdDb = new RrdDb(rrdDef);
        this.rrdMap.put(string, new RrdEntry(rrdDb));
        return rrdDb;
    }

    public synchronized RrdDb requestRrdDb(String string, String string2) throws IOException, RrdException {
        String string3 = Util.getCanonicalPath(string);
        while (this.rrdMap.containsKey(string3) || this.rrdMap.size() >= this.capacity) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw new RrdException(interruptedException);
            }
        }
        RrdDb rrdDb = new RrdDb(string3, string2);
        this.rrdMap.put(string3, new RrdEntry(rrdDb));
        return rrdDb;
    }

    public synchronized void release(RrdDb rrdDb) throws IOException, RrdException {
        if (rrdDb == null) {
            return;
        }
        String string = Util.getCanonicalPath(rrdDb.getPath());
        if (!this.rrdMap.containsKey(string)) {
            throw new RrdException("Could not release [" + string + "], the file was never requested");
        }
        RrdEntry rrdEntry = this.rrdMap.get(string);
        if (--rrdEntry.count <= 0) {
            this.rrdMap.remove(string);
            this.notifyAll();
            rrdEntry.rrdDb.close();
        }
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(int n) {
        this.capacity = n;
    }

    public synchronized String[] getOpenFiles() {
        return this.rrdMap.keySet().toArray(new String[0]);
    }

    public synchronized int getOpenFileCount() {
        return this.rrdMap.size();
    }

    class RrdEntry {
        RrdDb rrdDb;
        int count;

        RrdEntry(RrdDb rrdDb) {
            this.rrdDb = rrdDb;
            this.count = 1;
        }
    }
}

