/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.Archive;
import org.jrobin.core.DataImporter;
import org.jrobin.core.DsDef;
import org.jrobin.core.DsTypes;
import org.jrobin.core.Header;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDouble;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdLong;
import org.jrobin.core.RrdString;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class Datasource
implements RrdUpdater,
DsTypes {
    private static final double MAX_32_BIT = Math.pow(2.0, 32.0);
    private static final double MAX_64_BIT = Math.pow(2.0, 64.0);
    private RrdDb parentDb;
    private RrdString dsName;
    private RrdString dsType;
    private RrdLong heartbeat;
    private RrdDouble minValue;
    private RrdDouble maxValue;
    private RrdDouble lastValue;
    private RrdLong nanSeconds;
    private RrdDouble accumValue;

    Datasource(RrdDb rrdDb, DsDef dsDef) throws IOException {
        boolean bl = dsDef != null;
        this.parentDb = rrdDb;
        this.dsName = new RrdString(this);
        this.dsType = new RrdString(this);
        this.heartbeat = new RrdLong(this);
        this.minValue = new RrdDouble(this);
        this.maxValue = new RrdDouble(this);
        this.lastValue = new RrdDouble(this);
        this.accumValue = new RrdDouble(this);
        this.nanSeconds = new RrdLong(this);
        if (bl) {
            this.dsName.set(dsDef.getDsName());
            this.dsType.set(dsDef.getDsType());
            this.heartbeat.set(dsDef.getHeartbeat());
            this.minValue.set(dsDef.getMinValue());
            this.maxValue.set(dsDef.getMaxValue());
            this.lastValue.set(Double.NaN);
            this.accumValue.set(0.0);
            Header header = rrdDb.getHeader();
            this.nanSeconds.set(header.getLastUpdateTime() % header.getStep());
        }
    }

    Datasource(RrdDb rrdDb, DataImporter dataImporter, int n) throws IOException, RrdException {
        this(rrdDb, null);
        this.dsName.set(dataImporter.getDsName(n));
        this.dsType.set(dataImporter.getDsType(n));
        this.heartbeat.set(dataImporter.getHeartbeat(n));
        this.minValue.set(dataImporter.getMinValue(n));
        this.maxValue.set(dataImporter.getMaxValue(n));
        this.lastValue.set(dataImporter.getLastValue(n));
        this.accumValue.set(dataImporter.getAccumValue(n));
        this.nanSeconds.set(dataImporter.getNanSeconds(n));
    }

    String dump() throws IOException {
        return "== DATASOURCE ==\nDS:" + this.dsName.get() + ":" + this.dsType.get() + ":" + this.heartbeat.get() + ":" + this.minValue.get() + ":" + this.maxValue.get() + "\nlastValue:" + this.lastValue.get() + " nanSeconds:" + this.nanSeconds.get() + " accumValue:" + this.accumValue.get() + "\n";
    }

    public String getDsName() throws IOException {
        return this.dsName.get();
    }

    public String getDsType() throws IOException {
        return this.dsType.get();
    }

    public long getHeartbeat() throws IOException {
        return this.heartbeat.get();
    }

    public double getMinValue() throws IOException {
        return this.minValue.get();
    }

    public double getMaxValue() throws IOException {
        return this.maxValue.get();
    }

    public double getLastValue() throws IOException {
        return this.lastValue.get();
    }

    public double getAccumValue() throws IOException {
        return this.accumValue.get();
    }

    public long getNanSeconds() throws IOException {
        return this.nanSeconds.get();
    }

    void process(long l, double d) throws IOException, RrdException {
        Header header = this.parentDb.getHeader();
        long l2 = header.getStep();
        long l3 = header.getLastUpdateTime();
        long l4 = Util.normalize(l3, l2);
        long l5 = l4 + l2;
        double d2 = this.lastValue.get();
        double d3 = this.calculateUpdateValue(l3, d2, l, d);
        if (l < l5) {
            this.accumulate(l3, l, d3);
        } else {
            long l6 = Util.normalize(l, l2);
            this.accumulate(l3, l6, d3);
            double d4 = this.calculateTotal(l4, l6);
            long l7 = (l6 - l5) / l2 + 1L;
            this.parentDb.archive(this, d4, l7);
            this.nanSeconds.set(0L);
            this.accumValue.set(0.0);
            this.accumulate(l6, l, d3);
        }
    }

    private double calculateUpdateValue(long l, double d, long l2, double d2) throws IOException {
        double d3 = Double.NaN;
        if (l2 - l <= this.heartbeat.get()) {
            double d4;
            String string = this.dsType.get();
            if (string.equals("GAUGE")) {
                d3 = d2;
            } else if (string.equals("ABSOLUTE")) {
                if (!Double.isNaN(d2)) {
                    d3 = d2 / (double)(l2 - l);
                }
            } else if (string.equals("DERIVE")) {
                if (!Double.isNaN(d2) && !Double.isNaN(d)) {
                    d3 = (d2 - d) / (double)(l2 - l);
                }
            } else if (string.equals("COUNTER") && !Double.isNaN(d2) && !Double.isNaN(d)) {
                d4 = d2 - d;
                if (d4 < 0.0) {
                    d4 += MAX_32_BIT;
                }
                if (d4 < 0.0) {
                    d4 += MAX_64_BIT - MAX_32_BIT;
                }
                if (d4 >= 0.0) {
                    d3 = d4 / (double)(l2 - l);
                }
            }
            if (!Double.isNaN(d3)) {
                d4 = this.minValue.get();
                double d5 = this.maxValue.get();
                if (!Double.isNaN(d4) && d3 < d4) {
                    d3 = Double.NaN;
                }
                if (!Double.isNaN(d5) && d3 > d5) {
                    d3 = Double.NaN;
                }
            }
        }
        this.lastValue.set(d2);
        return d3;
    }

    private void accumulate(long l, long l2, double d) throws IOException {
        if (Double.isNaN(d)) {
            this.nanSeconds.set(this.nanSeconds.get() + (l2 - l));
        } else {
            this.accumValue.set(this.accumValue.get() + d * (double)(l2 - l));
        }
    }

    private double calculateTotal(long l, long l2) throws IOException {
        double d = Double.NaN;
        long l3 = l2 - l - this.nanSeconds.get();
        if (this.nanSeconds.get() <= this.heartbeat.get() && l3 > 0L) {
            d = this.accumValue.get() / (double)l3;
        }
        if (Double.isNaN(d) && this.dsName.get().endsWith("!")) {
            d = 0.0;
        }
        return d;
    }

    void appendXml(XmlWriter xmlWriter) throws IOException {
        xmlWriter.startTag("ds");
        xmlWriter.writeTag("name", this.dsName.get());
        xmlWriter.writeTag("type", this.dsType.get());
        xmlWriter.writeTag("minimal_heartbeat", this.heartbeat.get());
        xmlWriter.writeTag("min", this.minValue.get());
        xmlWriter.writeTag("max", this.maxValue.get());
        xmlWriter.writeComment("PDP Status");
        xmlWriter.writeTag("last_ds", this.lastValue.get(), "UNKN");
        xmlWriter.writeTag("value", this.accumValue.get());
        xmlWriter.writeTag("unknown_sec", this.nanSeconds.get());
        xmlWriter.closeTag();
    }

    public void copyStateTo(RrdUpdater rrdUpdater) throws IOException, RrdException {
        if (!(rrdUpdater instanceof Datasource)) {
            throw new RrdException("Cannot copy Datasource object to " + rrdUpdater.getClass().getName());
        }
        Datasource datasource = (Datasource)rrdUpdater;
        if (!datasource.dsName.get().equals(this.dsName.get())) {
            throw new RrdException("Incomaptible datasource names");
        }
        if (!datasource.dsType.get().equals(this.dsType.get())) {
            throw new RrdException("Incomaptible datasource types");
        }
        datasource.lastValue.set(this.lastValue.get());
        datasource.nanSeconds.set(this.nanSeconds.get());
        datasource.accumValue.set(this.accumValue.get());
    }

    public int getDsIndex() throws IOException {
        try {
            return this.parentDb.getDsIndex(this.dsName.get());
        }
        catch (RrdException rrdException) {
            return -1;
        }
    }

    public void setHeartbeat(long l) throws RrdException, IOException {
        if (l < 1L) {
            throw new RrdException("Invalid heartbeat specified: " + l);
        }
        this.heartbeat.set(l);
    }

    public void setDsName(String string) throws RrdException, IOException {
        if (string.length() > 20) {
            throw new RrdException("Invalid datasource name specified: " + string);
        }
        if (this.parentDb.containsDs(string)) {
            throw new RrdException("Datasource already defined in this RRD: " + string);
        }
        this.dsName.set(string);
    }

    public void setDsType(String string) throws RrdException, IOException {
        Archive[] archiveArray;
        if (!DsDef.isValidDsType(string)) {
            throw new RrdException("Invalid datasource type: " + string);
        }
        this.dsType.set(string);
        this.lastValue.set(Double.NaN);
        this.accumValue.set(0.0);
        int n = this.parentDb.getDsIndex(this.dsName.get());
        for (Archive archive : archiveArray = this.parentDb.getArchives()) {
            archive.getArcState(n).setAccumValue(Double.NaN);
        }
    }

    public void setMinValue(double d, boolean bl) throws IOException, RrdException {
        double d2 = this.maxValue.get();
        if (!Double.isNaN(d) && !Double.isNaN(d2) && d >= d2) {
            throw new RrdException("Invalid min/max values: " + d + "/" + d2);
        }
        this.minValue.set(d);
        if (!Double.isNaN(d) && bl) {
            Archive[] archiveArray;
            int n = this.getDsIndex();
            for (Archive archive : archiveArray = this.parentDb.getArchives()) {
                archive.getRobin(n).filterValues(d, Double.NaN);
            }
        }
    }

    public void setMaxValue(double d, boolean bl) throws IOException, RrdException {
        double d2 = this.minValue.get();
        if (!Double.isNaN(d2) && !Double.isNaN(d) && d2 >= d) {
            throw new RrdException("Invalid min/max values: " + d2 + "/" + d);
        }
        this.maxValue.set(d);
        if (!Double.isNaN(d) && bl) {
            Archive[] archiveArray;
            int n = this.getDsIndex();
            for (Archive archive : archiveArray = this.parentDb.getArchives()) {
                archive.getRobin(n).filterValues(Double.NaN, d);
            }
        }
    }

    public void setMinMaxValue(double d, double d2, boolean bl) throws IOException, RrdException {
        if (!Double.isNaN(d) && !Double.isNaN(d2) && d >= d2) {
            throw new RrdException("Invalid min/max values: " + d + "/" + d2);
        }
        this.minValue.set(d);
        this.maxValue.set(d2);
        if (!(Double.isNaN(d) && Double.isNaN(d2) || !bl)) {
            Archive[] archiveArray;
            int n = this.getDsIndex();
            for (Archive archive : archiveArray = this.parentDb.getArchives()) {
                archive.getRobin(n).filterValues(d, d2);
            }
        }
    }

    public RrdBackend getRrdBackend() {
        return this.parentDb.getRrdBackend();
    }

    public RrdAllocator getRrdAllocator() {
        return this.parentDb.getRrdAllocator();
    }
}

