/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jrobin.cmd.ColonSplitter;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;
import org.jrobin.data.DataProcessor;
import org.jrobin.graph.RrdGraphConstants;

class RrdXportCmd
extends RrdToolCmd
implements RrdGraphConstants {
    private DataProcessor dproc;
    private List<XPort> xports;

    RrdXportCmd() {
    }

    String getCmdType() {
        return "xport";
    }

    Object execute() throws RrdException, IOException {
        String string = this.getOptionValue("s", "start", "end-1d");
        String string2 = this.getOptionValue("e", "end", "now");
        long[] lArray = Util.getTimestamps(string, string2);
        this.dproc = new DataProcessor(lArray[0], lArray[1]);
        this.xports = new ArrayList<XPort>();
        long l = RrdXportCmd.parseLong(this.getOptionValue(null, "step", "1"));
        int n = RrdXportCmd.parseInt(this.getOptionValue("m", "maxrows", "400"));
        long l2 = (long)Math.ceil((double)(lArray[1] - lArray[0]) / (double)(n - 1));
        l = Math.max(l, l2);
        this.dproc.setStep(l);
        String[] stringArray = this.getRemainingWords();
        if (stringArray.length < 2) {
            throw new RrdException("Incomplete XPORT command");
        }
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("DEF:")) {
                this.parseDef(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("CDEF:")) {
                this.parseCDef(stringArray[i]);
                continue;
            }
            if (stringArray[i].startsWith("XPORT:")) {
                this.parseXport(stringArray[i]);
                continue;
            }
            throw new RrdException("Invalid XPORT syntax: " + stringArray[i]);
        }
        String string3 = this.xports.size() == 0 ? null : this.xport();
        RrdXportCmd.println(this.xports.size() == 0 ? "No XPORT statement found, nothing done" : string3);
        return string3;
    }

    private String xport() throws IOException, RrdException {
        this.dproc.processData();
        long[] lArray = this.dproc.getTimestamps();
        for (XPort object2 : this.xports) {
            object2.values = this.dproc.getValues(object2.name);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlWriter xmlWriter = new XmlWriter(byteArrayOutputStream);
        xmlWriter.startTag("xport");
        xmlWriter.startTag("meta");
        xmlWriter.writeTag("start", lArray[0]);
        xmlWriter.writeTag("step", lArray[1] - lArray[0]);
        xmlWriter.writeTag("end", lArray[lArray.length - 1]);
        xmlWriter.writeTag("rows", lArray.length);
        xmlWriter.writeTag("columns", this.xports.size());
        xmlWriter.startTag("legend");
        for (XPort xPort : this.xports) {
            xmlWriter.writeTag("entry", xPort.legend);
        }
        xmlWriter.closeTag();
        xmlWriter.closeTag();
        xmlWriter.startTag("data");
        for (int string = 0; string < lArray.length; ++string) {
            xmlWriter.startTag("row");
            xmlWriter.writeComment(new Date(lArray[string] * 1000L));
            xmlWriter.writeTag("t", lArray[string]);
            for (XPort xPort : this.xports) {
                xmlWriter.writeTag("v", xPort.values[string]);
            }
            xmlWriter.closeTag();
        }
        xmlWriter.closeTag();
        xmlWriter.closeTag();
        xmlWriter.flush();
        String string = byteArrayOutputStream.toString();
        byteArrayOutputStream.close();
        return string;
    }

    private void parseDef(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 4) {
            throw new RrdException("Invalid DEF syntax: " + string);
        }
        String[] stringArray2 = stringArray[1].split("=");
        if (stringArray2.length != 2) {
            throw new RrdException("Invalid DEF syntax: " + string);
        }
        this.dproc.addDatasource(stringArray2[0], stringArray2[1], stringArray[2], stringArray[3]);
    }

    private void parseCDef(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2) {
            throw new RrdException("Invalid CDEF syntax: " + string);
        }
        String[] stringArray2 = stringArray[1].split("=");
        if (stringArray2.length != 2) {
            throw new RrdException("Invalid CDEF syntax: " + string);
        }
        this.dproc.addDatasource(stringArray2[0], stringArray2[1]);
    }

    private void parseXport(String string) throws RrdException {
        String[] stringArray = new ColonSplitter(string).split();
        if (stringArray.length != 2 && stringArray.length != 3) {
            throw new RrdException("Invalid XPORT syntax: " + string);
        }
        XPort xPort = new XPort(stringArray[1], stringArray.length == 3 ? stringArray[2] : null);
        this.xports.add(xPort);
    }

    static class XPort {
        String name;
        String legend;
        double[] values;

        XPort(String string, String string2) {
            this.name = string;
            this.legend = string2 != null ? string2 : "";
        }
    }
}

