/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl.operations;

import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.cluster.impl.operations.JoinOperation;
import com.hazelcast.cluster.impl.operations.MemberInfoUpdateOperation;
import com.hazelcast.cluster.impl.operations.PostJoinOperation;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.ResponseHandlerFactory;
import java.io.IOException;
import java.util.Collection;

public class FinalizeJoinOperation
extends MemberInfoUpdateOperation
implements JoinOperation {
    public static final int FINALIZE_JOIN_TIMEOUT_FACTOR = 5;
    public static final int FINALIZE_JOIN_MAX_TIMEOUT = 60;
    private PostJoinOperation postJoinOp;

    public FinalizeJoinOperation() {
    }

    public FinalizeJoinOperation(Collection<MemberInfo> members, PostJoinOperation postJoinOp, long masterTime) {
        super(members, masterTime, true);
        this.postJoinOp = postJoinOp;
    }

    public FinalizeJoinOperation(Collection<MemberInfo> members, PostJoinOperation postJoinOp, long masterTime, boolean sendResponse) {
        super(members, masterTime, sendResponse);
        this.postJoinOp = postJoinOp;
    }

    @Override
    public void run() throws Exception {
        if (!this.isValid()) {
            return;
        }
        this.processMemberUpdate();
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        Operation[] postJoinOperations = nodeEngine.getPostJoinOperations();
        OperationService operationService = nodeEngine.getOperationService();
        if (postJoinOperations != null && postJoinOperations.length > 0) {
            Collection<MemberImpl> members = clusterService.getMemberList();
            for (MemberImpl member : members) {
                if (member.localMember()) continue;
                PostJoinOperation operation = new PostJoinOperation(postJoinOperations);
                operationService.createInvocationBuilder("hz:core:clusterService", (Operation)operation, member.getAddress()).setTryCount(100).invoke();
            }
        }
        if (this.postJoinOp != null) {
            this.postJoinOp.setNodeEngine(nodeEngine);
            OperationAccessor.setCallerAddress(this.postJoinOp, this.getCallerAddress());
            OperationAccessor.setConnection(this.postJoinOp, this.getConnection());
            this.postJoinOp.setResponseHandler(ResponseHandlerFactory.createEmptyResponseHandler());
            operationService.runOperationOnCallingThread(this.postJoinOp);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        boolean hasPJOp = this.postJoinOp != null;
        out.writeBoolean(hasPJOp);
        if (hasPJOp) {
            this.postJoinOp.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        boolean hasPJOp = in.readBoolean();
        if (hasPJOp) {
            this.postJoinOp = new PostJoinOperation();
            this.postJoinOp.readData(in);
        }
    }
}

