/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.gui.customslider;

import java.awt.Color;
import java.util.HashSet;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.fmj.gui.customslider.CustomSliderUI;

public class CustomSlider
extends JSlider {
    private static final long serialVersionUID = 12L;
    private boolean paintFocus = false;
    private int value = -1;
    private HashSet linearListeners;

    public CustomSlider() {
        this.initialize();
    }

    private HashSet getLinearListeners() {
        if (this.linearListeners == null) {
            this.linearListeners = new HashSet();
        }
        return this.linearListeners;
    }

    public boolean getPaintFocus() {
        return this.paintFocus;
    }

    private void initialize() {
        this.setUI(CustomSliderUI.createUI(this));
        this.setName("Slider");
        this.setBackground(Color.WHITE);
        this.setOpaque(false);
        this.setPaintTrack(true);
        this.setPaintTicks(false);
        this.setSnapToTicks(true);
        this.addChangeListener(new SliderListener());
    }

    public void setPaintFocus(boolean bl) {
        this.paintFocus = bl;
    }

    private class SliderListener
    implements ChangeListener {
        private SliderListener() {
        }

        private void sendValue() {
            int n = CustomSlider.this.getValue();
            if (n != CustomSlider.this.value) {
                CustomSlider.this.value = n;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.sendValue();
        }
    }
}

