/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CannotRealizeException;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.DataSinkProxy;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.MediaHandler;
import javax.media.MediaLocator;
import javax.media.MediaProxy;
import javax.media.NoDataSinkException;
import javax.media.NoDataSourceException;
import javax.media.NoPlayerException;
import javax.media.NoProcessorException;
import javax.media.PackageManager;
import javax.media.Player;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.RealizeCompleteEvent;
import javax.media.StopEvent;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.control.FormatControl;
import javax.media.control.TrackControl;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.SourceCloneable;
import javax.media.protocol.URLDataSource;
import net.sf.fmj.ejmf.toolkit.util.StateWaiter;
import net.sf.fmj.media.MergingCaptureDevicePullBufferDataSource;
import net.sf.fmj.media.MergingCaptureDevicePullDataSource;
import net.sf.fmj.media.MergingCaptureDevicePushBufferDataSource;
import net.sf.fmj.media.MergingCaptureDevicePushDataSource;
import net.sf.fmj.media.MergingPullBufferDataSource;
import net.sf.fmj.media.MergingPullDataSource;
import net.sf.fmj.media.MergingPushBufferDataSource;
import net.sf.fmj.media.MergingPushDataSource;
import net.sf.fmj.media.protocol.CloneableCaptureDevicePullBufferDataSource;
import net.sf.fmj.media.protocol.CloneableCaptureDevicePullDataSource;
import net.sf.fmj.media.protocol.CloneableCaptureDevicePushBufferDataSource;
import net.sf.fmj.media.protocol.CloneableCaptureDevicePushDataSource;
import net.sf.fmj.media.protocol.CloneablePullBufferDataSource;
import net.sf.fmj.media.protocol.CloneablePullDataSource;
import net.sf.fmj.media.protocol.CloneablePushBufferDataSource;
import net.sf.fmj.media.protocol.CloneablePushDataSource;
import net.sf.fmj.utility.LoggerSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Manager {
    public static final String FMJ_TAG = "FMJ";
    private static final boolean USE_MEDIA_PREFIX = false;
    private static final Logger logger = LoggerSingleton.logger;
    public static final int MAX_SECURITY = 1;
    public static final int CACHING = 2;
    public static final int LIGHTWEIGHT_RENDERER = 3;
    public static final int PLUGIN_PLAYER = 4;
    public static final String UNKNOWN_CONTENT_NAME = "unknown";
    private static TimeBase systemTimeBase = new SystemTimeBase();
    private static final Map<Integer, Object> hints = new HashMap<Integer, Object>();
    public static final boolean RETHROW_IO_EXCEPTIONS = true;

    private static void blockingRealize(Controller controller) throws CannotRealizeException {
        try {
            new BlockingRealizer(controller).realize();
        }
        catch (InterruptedException interruptedException) {
            throw new CannotRealizeException("Interrupted");
        }
    }

    public static DataSource createCloneableDataSource(DataSource dataSource) {
        if (dataSource instanceof SourceCloneable) {
            return dataSource;
        }
        if (dataSource instanceof PushBufferDataSource) {
            if (dataSource instanceof CaptureDevice) {
                return new CloneableCaptureDevicePushBufferDataSource((PushBufferDataSource)dataSource);
            }
            return new CloneablePushBufferDataSource((PushBufferDataSource)dataSource);
        }
        if (dataSource instanceof PullBufferDataSource) {
            if (dataSource instanceof CaptureDevice) {
                return new CloneableCaptureDevicePullBufferDataSource((PullBufferDataSource)dataSource);
            }
            return new CloneablePullBufferDataSource((PullBufferDataSource)dataSource);
        }
        if (dataSource instanceof PushDataSource) {
            if (dataSource instanceof CaptureDevice) {
                return new CloneableCaptureDevicePushDataSource((PushDataSource)dataSource);
            }
            return new CloneablePushDataSource((PushDataSource)dataSource);
        }
        if (dataSource instanceof PullDataSource) {
            if (dataSource instanceof CaptureDevice) {
                return new CloneableCaptureDevicePullDataSource((PullDataSource)dataSource);
            }
            return new CloneablePullDataSource((PullDataSource)dataSource);
        }
        throw new IllegalArgumentException("Unknown or unsupported DataSource type: " + dataSource);
    }

    public static DataSink createDataSink(DataSource dataSource, MediaLocator mediaLocator) throws NoDataSinkException {
        String string = mediaLocator.getProtocol();
        for (String string2 : Manager.getDataSinkClassList(string)) {
            try {
                MediaHandler mediaHandler;
                Class<?> clazz = Class.forName(string2);
                if (!DataSink.class.isAssignableFrom(clazz) && !DataSinkProxy.class.isAssignableFrom(clazz)) continue;
                MediaHandler mediaHandler2 = (MediaHandler)clazz.newInstance();
                mediaHandler2.setSource(dataSource);
                if (mediaHandler2 instanceof DataSink) {
                    mediaHandler = (DataSink)mediaHandler2;
                    mediaHandler.setOutputLocator(mediaLocator);
                    return mediaHandler;
                }
                if (!(mediaHandler2 instanceof DataSinkProxy)) continue;
                mediaHandler = (DataSinkProxy)mediaHandler2;
                Vector<String> vector = Manager.getDataSinkClassList(string + "." + Manager.toPackageFriendly(mediaHandler.getContentType(mediaLocator)));
                for (String string3 : vector) {
                    try {
                        Class<?> clazz2 = Class.forName(string3);
                        if (!DataSink.class.isAssignableFrom(clazz2)) continue;
                        MediaHandler mediaHandler3 = (MediaHandler)clazz2.newInstance();
                        mediaHandler3.setSource(mediaHandler.getDataSource());
                        if (!(mediaHandler3 instanceof DataSink)) continue;
                        DataSink dataSink = (DataSink)mediaHandler3;
                        dataSink.setOutputLocator(mediaLocator);
                        return (DataSink)mediaHandler3;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        logger.finer("createDataSink: " + classNotFoundException);
                    }
                    catch (IncompatibleSourceException incompatibleSourceException) {
                        logger.fine("createDataSink(" + dataSource + ", " + mediaLocator + "), proxy=" + mediaHandler.getDataSource() + ": " + incompatibleSourceException);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        logger.log(Level.FINE, "" + noClassDefFoundError, noClassDefFoundError);
                    }
                    catch (Exception exception) {
                        logger.log(Level.FINE, "" + exception, exception);
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.finer("createDataSink: " + classNotFoundException);
            }
            catch (IncompatibleSourceException incompatibleSourceException) {
                logger.fine("createDataSink(" + dataSource + ", " + mediaLocator + "): " + incompatibleSourceException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                logger.log(Level.FINE, "" + noClassDefFoundError, noClassDefFoundError);
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "" + exception, exception);
            }
        }
        throw new NoDataSinkException();
    }

    private static DataSink createDataSink(DataSource dataSource, String string) throws NoDataSinkException {
        for (String string2 : Manager.getDataSinkClassList(string)) {
            try {
                Class<?> clazz = Class.forName(string2);
                if (!DataSink.class.isAssignableFrom(clazz)) continue;
                MediaHandler mediaHandler = (MediaHandler)clazz.newInstance();
                mediaHandler.setSource(dataSource);
                if (!(mediaHandler instanceof DataSink)) continue;
                return (DataSink)mediaHandler;
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.finer("createDataSink: " + classNotFoundException);
            }
            catch (IncompatibleSourceException incompatibleSourceException) {
                logger.fine("createDataSink(" + dataSource + ", " + string + "): " + incompatibleSourceException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                logger.log(Level.FINE, "" + noClassDefFoundError, noClassDefFoundError);
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "" + exception, exception);
            }
        }
        throw new NoDataSinkException();
    }

    public static DataSource createDataSource(URL uRL) throws IOException, NoDataSourceException {
        return Manager.createDataSource(new MediaLocator(uRL));
    }

    public static DataSource createDataSource(MediaLocator mediaLocator) throws IOException, NoDataSourceException {
        URL uRL;
        String string = mediaLocator.getProtocol();
        for (String object2 : Manager.getDataSourceList(string)) {
            try {
                Class<?> classNotFoundException = Class.forName(object2);
                DataSource dataSource = (DataSource)classNotFoundException.newInstance();
                dataSource.setLocator(mediaLocator);
                dataSource.connect();
                return dataSource;
            }
            catch (ClassNotFoundException iOException) {
                logger.finer("createDataSource: " + iOException);
            }
            catch (IOException noClassDefFoundError) {
                logger.log(Level.FINE, "" + noClassDefFoundError, noClassDefFoundError);
                throw noClassDefFoundError;
            }
            catch (NoClassDefFoundError exception) {
                logger.log(Level.FINE, "" + exception, exception);
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "" + exception, exception);
            }
        }
        try {
            uRL = mediaLocator.getURL();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "" + exception, exception);
            throw new NoDataSourceException();
        }
        URLDataSource uRLDataSource = new URLDataSource(uRL);
        uRLDataSource.connect();
        return uRLDataSource;
    }

    public static DataSource createMergingDataSource(DataSource[] dataSourceArray) throws IncompatibleSourceException {
        Object object;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        for (DataSource dataSource : dataSourceArray) {
            if (!(dataSource instanceof PushBufferDataSource)) {
                bl = false;
            }
            if (!(dataSource instanceof PullBufferDataSource)) {
                bl2 = false;
            }
            if (!(dataSource instanceof PushDataSource)) {
                bl3 = false;
            }
            if (!(dataSource instanceof PullDataSource)) {
                bl4 = false;
            }
            if (dataSource instanceof CaptureDevice) continue;
            bl5 = false;
        }
        if (bl) {
            object = new ArrayList();
            for (DataSource dataSource : dataSourceArray) {
                object.add((PushBufferDataSource)dataSource);
            }
            if (bl5) {
                return new MergingCaptureDevicePushBufferDataSource((List<PushBufferDataSource>)object);
            }
            return new MergingPushBufferDataSource((List<PushBufferDataSource>)object);
        }
        if (bl2) {
            object = new ArrayList();
            for (DataSource dataSource : dataSourceArray) {
                object.add((PullBufferDataSource)dataSource);
            }
            if (bl5) {
                return new MergingCaptureDevicePullBufferDataSource((List<PullBufferDataSource>)object);
            }
            return new MergingPullBufferDataSource((List<PullBufferDataSource>)object);
        }
        if (bl3) {
            object = new ArrayList();
            for (DataSource dataSource : dataSourceArray) {
                object.add((PushDataSource)dataSource);
            }
            if (bl5) {
                return new MergingCaptureDevicePushDataSource((List<PushDataSource>)object);
            }
            return new MergingPushDataSource((List<PushDataSource>)object);
        }
        if (bl4) {
            object = new ArrayList();
            for (DataSource dataSource : dataSourceArray) {
                object.add((PullDataSource)dataSource);
            }
            if (bl5) {
                return new MergingCaptureDevicePullDataSource((List<PullDataSource>)object);
            }
            return new MergingPullDataSource((List<PullDataSource>)object);
        }
        throw new IncompatibleSourceException();
    }

    public static Player createPlayer(DataSource dataSource) throws IOException, NoPlayerException {
        try {
            return Manager.createPlayer(dataSource, dataSource.getContentType());
        }
        catch (NoPlayerException noPlayerException) {
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "" + iOException, iOException);
            throw iOException;
        }
        catch (Exception exception) {
            logger.log(Level.FINER, "" + exception, exception);
        }
        return Manager.createPlayer(dataSource, UNKNOWN_CONTENT_NAME);
    }

    private static Player createPlayer(DataSource dataSource, String string) throws IOException, NoPlayerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : Manager.getHandlerClassList(string)) {
            try {
                Class<?> clazz = Class.forName(string2);
                if (!Player.class.isAssignableFrom(clazz) && !MediaProxy.class.isAssignableFrom(clazz)) continue;
                MediaHandler mediaHandler = (MediaHandler)clazz.newInstance();
                mediaHandler.setSource(dataSource);
                if (mediaHandler instanceof Player) {
                    logger.info("Using player: " + mediaHandler.getClass().getName());
                    return (Player)mediaHandler;
                }
                if (mediaHandler instanceof MediaProxy) {
                    MediaProxy mediaProxy = (MediaProxy)mediaHandler;
                    return Manager.createPlayer(mediaProxy.getDataSource());
                }
                logger.fine("Not Player, and not MediaProxy: " + mediaHandler.getClass().getName());
                arrayList.add(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.finer("createPlayer: " + classNotFoundException);
            }
            catch (IncompatibleSourceException incompatibleSourceException) {
                arrayList.add(string2);
                logger.fine("createPlayer(" + dataSource + ", " + string + "): " + incompatibleSourceException);
            }
            catch (IOException iOException) {
                arrayList.add(string2);
                logger.log(Level.FINE, "" + iOException, iOException);
                throw iOException;
            }
            catch (NoPlayerException noPlayerException) {
                arrayList.add(string2);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                arrayList.add(string2);
                logger.log(Level.FINE, "" + noClassDefFoundError, noClassDefFoundError);
            }
            catch (Exception exception) {
                arrayList.add(string2);
                logger.log(Level.FINE, "" + exception, exception);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tried handlers:");
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuilder.append('\n');
            stringBuilder.append((String)arrayList.get(i));
        }
        throw new NoPlayerException("No player found for " + dataSource.getLocator() + " - " + stringBuilder.toString());
    }

    public static Player createPlayer(URL uRL) throws IOException, NoPlayerException {
        return Manager.createPlayer(new MediaLocator(uRL));
    }

    public static Player createPlayer(MediaLocator mediaLocator) throws IOException, NoPlayerException {
        URL uRL;
        String string = mediaLocator.getProtocol();
        for (String object2 : Manager.getDataSourceList(string)) {
            try {
                Class<?> noPlayerException = Class.forName(object2);
                DataSource dataSource = (DataSource)noPlayerException.newInstance();
                dataSource.setLocator(mediaLocator);
                dataSource.connect();
                return Manager.createPlayer(dataSource);
            }
            catch (NoPlayerException classNotFoundException) {
            }
            catch (ClassNotFoundException iOException) {
                logger.finer("createPlayer: " + iOException);
            }
            catch (IOException noClassDefFoundError) {
                logger.log(Level.FINE, "" + noClassDefFoundError, noClassDefFoundError);
                throw noClassDefFoundError;
            }
            catch (NoClassDefFoundError exception) {
                logger.log(Level.FINE, "" + exception, exception);
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "" + exception, exception);
            }
        }
        try {
            uRL = mediaLocator.getURL();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "" + exception, exception);
            throw new NoPlayerException();
        }
        URLDataSource uRLDataSource = new URLDataSource(uRL);
        uRLDataSource.connect();
        return Manager.createPlayer(uRLDataSource);
    }

    public static Processor createProcessor(DataSource dataSource) throws IOException, NoProcessorException {
        try {
            return Manager.createProcessor(dataSource, dataSource.getContentType());
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "" + iOException, iOException);
            throw iOException;
        }
        catch (NoProcessorException noProcessorException) {
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "" + exception, exception);
        }
        return Manager.createProcessor(dataSource, UNKNOWN_CONTENT_NAME);
    }

    private static Processor createProcessor(DataSource dataSource, String string) throws IOException, NoProcessorException {
        for (String string2 : Manager.getProcessorClassList(string)) {
            try {
                Class<?> clazz = Class.forName(string2);
                if (!Processor.class.isAssignableFrom(clazz) && !MediaProxy.class.isAssignableFrom(clazz)) continue;
                MediaHandler mediaHandler = (MediaHandler)clazz.newInstance();
                mediaHandler.setSource(dataSource);
                if (mediaHandler instanceof Processor) {
                    return (Processor)mediaHandler;
                }
                if (!(mediaHandler instanceof MediaProxy)) continue;
                MediaProxy mediaProxy = (MediaProxy)mediaHandler;
                return Manager.createProcessor(mediaProxy.getDataSource());
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.finer("createProcessor: " + classNotFoundException);
            }
            catch (IncompatibleSourceException incompatibleSourceException) {
                logger.fine("createProcessor(" + dataSource + ", " + string + "): " + incompatibleSourceException);
            }
            catch (NoProcessorException noProcessorException) {
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "" + iOException, iOException);
                throw iOException;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                logger.log(Level.FINE, "" + noClassDefFoundError, noClassDefFoundError);
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "" + exception, exception);
            }
        }
        throw new NoProcessorException();
    }

    public static Processor createProcessor(URL uRL) throws IOException, NoProcessorException {
        return Manager.createProcessor(new MediaLocator(uRL));
    }

    public static Processor createProcessor(MediaLocator mediaLocator) throws IOException, NoProcessorException {
        URL uRL;
        String string = mediaLocator.getProtocol();
        for (String object2 : Manager.getDataSourceList(string)) {
            try {
                Class<?> classNotFoundException = Class.forName(object2);
                DataSource dataSource = (DataSource)classNotFoundException.newInstance();
                dataSource.setLocator(mediaLocator);
                dataSource.connect();
                return Manager.createProcessor(dataSource);
            }
            catch (ClassNotFoundException iOException) {
                logger.finer("createProcessor: " + iOException);
            }
            catch (IOException noProcessorException) {
                logger.log(Level.FINE, "" + noProcessorException, noProcessorException);
                throw noProcessorException;
            }
            catch (NoProcessorException noClassDefFoundError) {
            }
            catch (NoClassDefFoundError exception) {
                logger.log(Level.FINE, "" + exception, exception);
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "" + exception, exception);
            }
        }
        try {
            uRL = mediaLocator.getURL();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "" + exception, exception);
            throw new NoProcessorException();
        }
        URLDataSource uRLDataSource = new URLDataSource(uRL);
        uRLDataSource.connect();
        return Manager.createProcessor(uRLDataSource);
    }

    public static Player createRealizedPlayer(DataSource dataSource) throws IOException, NoPlayerException, CannotRealizeException {
        Player player = Manager.createPlayer(dataSource);
        Manager.blockingRealize(player);
        return player;
    }

    public static Player createRealizedPlayer(URL uRL) throws IOException, NoPlayerException, CannotRealizeException {
        Player player = Manager.createPlayer(uRL);
        Manager.blockingRealize(player);
        return player;
    }

    public static Player createRealizedPlayer(MediaLocator mediaLocator) throws IOException, NoPlayerException, CannotRealizeException {
        Player player = Manager.createPlayer(mediaLocator);
        Manager.blockingRealize(player);
        return player;
    }

    public static Processor createRealizedProcessor(ProcessorModel processorModel) throws IOException, NoProcessorException, CannotRealizeException {
        Format[] formatArray;
        int n;
        Processor processor = processorModel.getInputDataSource() != null ? Manager.createProcessor(processorModel.getInputDataSource()) : Manager.createProcessor(processorModel.getInputLocator());
        StateWaiter stateWaiter = new StateWaiter(processor);
        if (!stateWaiter.blockingConfigure()) {
            throw new CannotRealizeException("Failed to configure");
        }
        if (processorModel.getContentDescriptor() != null) {
            processor.setContentDescriptor(processorModel.getContentDescriptor());
        }
        if ((n = processorModel.getTrackCount(Integer.MAX_VALUE)) > 0) {
            formatArray = new Format[n];
            for (int i = 0; i < formatArray.length; ++i) {
                formatArray[i] = processorModel.getOutputTrackFormat(i);
            }
        } else {
            formatArray = null;
        }
        if (formatArray != null && formatArray.length > 0) {
            int n2;
            Format format;
            int n3;
            TrackControl[] trackControlArray = processor.getTrackControls();
            boolean[] blArray = new boolean[trackControlArray.length];
            boolean[] blArray2 = new boolean[formatArray.length];
            for (n3 = 0; n3 < formatArray.length; ++n3) {
                format = formatArray[n3];
                if (format == null) continue;
                for (n2 = 0; n2 < trackControlArray.length; ++n2) {
                    if (blArray[n2]) continue;
                    if (!(trackControlArray[n2] instanceof FormatControl)) {
                        logger.warning("Disabling track " + n2 + "; trackControl is not a FormatControl: " + trackControlArray[n2]);
                        trackControlArray[n2].setEnabled(false);
                        blArray[n2] = true;
                        continue;
                    }
                    if (trackControlArray[n2].setFormat(format) == null) {
                        logger.fine("Track " + n2 + "; does not accept " + format);
                        continue;
                    }
                    logger.fine("Using track " + n2 + "; accepted " + format);
                    blArray[n2] = true;
                    blArray2[n3] = true;
                }
            }
            for (n3 = 0; n3 < formatArray.length; ++n3) {
                format = formatArray[n3];
                if (format != null) continue;
                for (n2 = 0; n2 < trackControlArray.length; ++n2) {
                    if (blArray[n2]) continue;
                    logger.fine("Using track " + n2 + "; for unspecified format");
                    blArray[n2] = true;
                    blArray2[n3] = true;
                }
            }
            for (n3 = 0; n3 < trackControlArray.length; ++n3) {
                if (blArray[n3]) continue;
                logger.info("Disabling track " + n3 + "; no format set.");
                trackControlArray[n3].setEnabled(false);
            }
            for (n3 = 0; n3 < formatArray.length; ++n3) {
                if (blArray2[n3]) continue;
                throw new CannotRealizeException("No tracks found that are compatible with format " + formatArray[n3]);
            }
        }
        if (!stateWaiter.blockingRealize()) {
            throw new CannotRealizeException("Failed to realize");
        }
        return processor;
    }

    public static String getCacheDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static Vector<String> getClassList(String string, Vector vector, String string2, String string3) {
        Vector<String> vector2 = new Vector<String>();
        for (Object e : vector) {
            vector2.add(e + ".media." + string2 + "." + string + "." + string3);
        }
        return vector2;
    }

    public static Vector<String> getDataSinkClassList(String string) {
        return Manager.getClassList(Manager.toPackageFriendly(string), PackageManager.getContentPrefixList(), "datasink", "Handler");
    }

    public static Vector<String> getDataSourceList(String string) {
        return Manager.getClassList(string, PackageManager.getProtocolPrefixList(), "protocol", "DataSource");
    }

    public static Vector<String> getHandlerClassList(String string) {
        return Manager.getClassList(Manager.toPackageFriendly(string), PackageManager.getContentPrefixList(), "content", "Handler");
    }

    public static Object getHint(int n) {
        return hints.get(n);
    }

    public static Vector<String> getProcessorClassList(String string) {
        return Manager.getClassList(Manager.toPackageFriendly(string), PackageManager.getContentPrefixList(), "processor", "Handler");
    }

    public static TimeBase getSystemTimeBase() {
        return systemTimeBase;
    }

    public static String getVersion() {
        try {
            Properties properties = new Properties();
            properties.load(Manager.class.getResourceAsStream("/fmj.build.properties"));
            String string = properties.getProperty("build");
            if (string != null && !string.equals("")) {
                return "FMJ " + string.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "FMJ non-release x.x";
    }

    public static void setHint(int n, Object object) {
        hints.put(n, object);
    }

    private static char toPackageFriendly(char c) {
        if (c >= 'a' && c <= 'z') {
            return c;
        }
        if (c >= 'A' && c <= 'Z') {
            return c;
        }
        if (c >= '0' && c <= '9') {
            return c;
        }
        if (c == '.') {
            return c;
        }
        if (c == '/') {
            return '.';
        }
        return '_';
    }

    private static String toPackageFriendly(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(Manager.toPackageFriendly(c));
        }
        return stringBuffer.toString();
    }

    static {
        hints.put(1, Boolean.FALSE);
        hints.put(2, Boolean.TRUE);
        hints.put(3, Boolean.FALSE);
        hints.put(4, Boolean.FALSE);
    }

    private static class BlockingRealizer
    implements ControllerListener {
        private final Controller controller;
        private volatile boolean realized = false;
        private volatile boolean busy = true;
        private volatile String cannotRealizeExceptionMessage;

        public BlockingRealizer(Controller controller) {
            this.controller = controller;
        }

        public synchronized void controllerUpdate(ControllerEvent controllerEvent) {
            if (controllerEvent instanceof RealizeCompleteEvent) {
                this.realized = true;
                this.busy = false;
                this.notify();
            } else if (controllerEvent instanceof StopEvent || controllerEvent instanceof ControllerClosedEvent) {
                if (controllerEvent instanceof StopEvent) {
                    this.cannotRealizeExceptionMessage = "Cannot realize: received StopEvent: " + controllerEvent;
                    logger.info(this.cannotRealizeExceptionMessage);
                } else {
                    this.cannotRealizeExceptionMessage = "Cannot realize: received ControllerClosedEvent: " + controllerEvent + "; message: " + ((ControllerClosedEvent)controllerEvent).getMessage();
                    logger.info(this.cannotRealizeExceptionMessage);
                }
                this.realized = false;
                this.busy = false;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void realize() throws CannotRealizeException, InterruptedException {
            this.controller.addControllerListener(this);
            this.controller.realize();
            while (this.busy) {
                try {
                    BlockingRealizer blockingRealizer = this;
                    synchronized (blockingRealizer) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.controller.removeControllerListener(this);
                    throw interruptedException;
                }
            }
            this.controller.removeControllerListener(this);
            if (!this.realized) {
                throw new CannotRealizeException(this.cannotRealizeExceptionMessage);
            }
        }
    }
}

