/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.LinkedList;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.packet.Packet;

class ConnectionDetachedPacketCollector {
    private int maxPackets = SmackConfiguration.getPacketCollectorSize();
    private LinkedList<Packet> resultQueue = new LinkedList();

    public ConnectionDetachedPacketCollector() {
    }

    public ConnectionDetachedPacketCollector(int maxSize) {
        this.maxPackets = maxSize;
    }

    public synchronized Packet pollResult() {
        if (this.resultQueue.isEmpty()) {
            return null;
        }
        return this.resultQueue.removeLast();
    }

    public synchronized Packet nextResult() {
        while (this.resultQueue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.resultQueue.removeLast();
    }

    public synchronized Packet nextResult(long timeout) {
        if (this.resultQueue.isEmpty()) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.resultQueue.isEmpty()) {
            return null;
        }
        return this.resultQueue.removeLast();
    }

    protected synchronized void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (this.resultQueue.size() == this.maxPackets) {
            this.resultQueue.removeLast();
        }
        this.resultQueue.addFirst(packet);
        this.notifyAll();
    }
}

