/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.util.StringUtils;

public class FormField {
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_FIXED = "fixed";
    public static final String TYPE_HIDDEN = "hidden";
    public static final String TYPE_JID_MULTI = "jid-multi";
    public static final String TYPE_JID_SINGLE = "jid-single";
    public static final String TYPE_LIST_MULTI = "list-multi";
    public static final String TYPE_LIST_SINGLE = "list-single";
    public static final String TYPE_TEXT_MULTI = "text-multi";
    public static final String TYPE_TEXT_PRIVATE = "text-private";
    public static final String TYPE_TEXT_SINGLE = "text-single";
    private String description;
    private boolean required = false;
    private String label;
    private String variable;
    private String type;
    private final List<Option> options = new ArrayList<Option>();
    private final List<String> values = new ArrayList<String>();

    public FormField(String variable) {
        this.variable = variable;
    }

    public FormField() {
        this.type = TYPE_FIXED;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Option> getOptions() {
        List<Option> list = this.options;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Option>(this.options)).iterator();
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getValues() {
        List<String> list = this.values;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.values)).iterator();
        }
    }

    public String getVariable() {
        return this.variable;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setType(String type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(String value) {
        List<String> list = this.values;
        synchronized (list) {
            this.values.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValues(List<String> newValues) {
        List<String> list = this.values;
        synchronized (list) {
            this.values.addAll(newValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetValues() {
        List<String> list = this.values;
        synchronized (list) {
            this.values.removeAll(new ArrayList<String>(this.values));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOption(Option option) {
        List<Option> list = this.options;
        synchronized (list) {
            this.options.add(option);
        }
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<field");
        if (this.getLabel() != null) {
            buf.append(" label=\"").append(this.getLabel()).append("\"");
        }
        if (this.getVariable() != null) {
            buf.append(" var=\"").append(this.getVariable()).append("\"");
        }
        if (this.getType() != null) {
            buf.append(" type=\"").append(this.getType()).append("\"");
        }
        buf.append(">");
        if (this.getDescription() != null) {
            buf.append("<desc>").append(this.getDescription()).append("</desc>");
        }
        if (this.isRequired()) {
            buf.append("<required/>");
        }
        Iterator<Object> i = this.getValues();
        while (i.hasNext()) {
            buf.append("<value>").append((String)i.next()).append("</value>");
        }
        i = this.getOptions();
        while (i.hasNext()) {
            buf.append(((Option)i.next()).toXML());
        }
        buf.append("</field>");
        return buf.toString();
    }

    public static class Option {
        private String label;
        private String value;

        public Option(String value) {
            this.value = value;
        }

        public Option(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getLabel();
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<option");
            if (this.getLabel() != null) {
                buf.append(" label=\"").append(this.getLabel()).append("\"");
            }
            buf.append(">");
            buf.append("<value>").append(StringUtils.escapeForXML((String)this.getValue())).append("</value>");
            buf.append("</option>");
            return buf.toString();
        }
    }
}

