/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.jingle;

import java.util.ArrayList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RemoteCandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtcpmuxPacketExtension;
import org.jivesoftware.smack.packet.PacketExtension;

public class IceUdpTransportPacketExtension
extends AbstractPacketExtension {
    public static final String NAMESPACE = "urn:xmpp:jingle:transports:ice-udp:1";
    public static final String ELEMENT_NAME = "transport";
    public static final String PWD_ATTR_NAME = "pwd";
    public static final String UFRAG_ATTR_NAME = "ufrag";
    private final List<CandidatePacketExtension> candidateList = new ArrayList<CandidatePacketExtension>();
    private RemoteCandidatePacketExtension remoteCandidate;

    public IceUdpTransportPacketExtension() {
        super(NAMESPACE, ELEMENT_NAME);
    }

    protected IceUdpTransportPacketExtension(String namespace, String elementName) {
        super(namespace, elementName);
    }

    public void setPassword(String pwd) {
        super.setAttribute(PWD_ATTR_NAME, pwd);
    }

    public String getPassword() {
        return super.getAttributeAsString(PWD_ATTR_NAME);
    }

    public void setUfrag(String ufrag) {
        super.setAttribute(UFRAG_ATTR_NAME, ufrag);
    }

    public String getUfrag() {
        return super.getAttributeAsString(UFRAG_ATTR_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends PacketExtension> getChildExtensions() {
        ArrayList<? extends PacketExtension> childExtensions = new ArrayList<PacketExtension>();
        List<? extends PacketExtension> superChildExtensions = super.getChildExtensions();
        childExtensions.addAll(superChildExtensions);
        List<CandidatePacketExtension> list = this.candidateList;
        synchronized (list) {
            if (this.candidateList.size() > 0) {
                childExtensions.addAll(this.candidateList);
            } else if (this.remoteCandidate != null) {
                childExtensions.add(this.remoteCandidate);
            }
        }
        return childExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCandidate(CandidatePacketExtension candidate) {
        List<CandidatePacketExtension> list = this.candidateList;
        synchronized (list) {
            this.candidateList.add(candidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCandidate(CandidatePacketExtension candidate) {
        List<CandidatePacketExtension> list = this.candidateList;
        synchronized (list) {
            return this.candidateList.remove(candidate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CandidatePacketExtension> getCandidateList() {
        List<CandidatePacketExtension> list = this.candidateList;
        synchronized (list) {
            return new ArrayList<CandidatePacketExtension>(this.candidateList);
        }
    }

    public void setRemoteCandidate(RemoteCandidatePacketExtension candidate) {
        this.remoteCandidate = candidate;
    }

    public RemoteCandidatePacketExtension getRemoteCandidate() {
        return this.remoteCandidate;
    }

    @Override
    public void addChildExtension(PacketExtension childExtension) {
        if (childExtension instanceof RemoteCandidatePacketExtension) {
            this.setRemoteCandidate((RemoteCandidatePacketExtension)childExtension);
        } else if (childExtension instanceof CandidatePacketExtension) {
            this.addCandidate((CandidatePacketExtension)childExtension);
        } else {
            super.addChildExtension(childExtension);
        }
    }

    public boolean isRtcpMux() {
        for (PacketExtension packetExtension : this.getChildExtensions()) {
            if (!"rtcp-mux".equals(packetExtension.getElementName())) continue;
            return true;
        }
        return false;
    }

    public static IceUdpTransportPacketExtension cloneTransportAndCandidates(IceUdpTransportPacketExtension src) {
        return IceUdpTransportPacketExtension.cloneTransportAndCandidates(src, false);
    }

    public static IceUdpTransportPacketExtension cloneTransportAndCandidates(IceUdpTransportPacketExtension src, boolean copyDtls) {
        if (src == null) {
            return null;
        }
        IceUdpTransportPacketExtension dst = AbstractPacketExtension.clone(src);
        for (CandidatePacketExtension srcCand : src.getCandidateList()) {
            if (srcCand instanceof RemoteCandidatePacketExtension) continue;
            dst.addCandidate(AbstractPacketExtension.clone(srcCand));
        }
        if (src.isRtcpMux()) {
            dst.addChildExtension(new RtcpmuxPacketExtension());
        }
        if (copyDtls) {
            for (DtlsFingerprintPacketExtension dtlsFingerprint : src.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class)) {
                DtlsFingerprintPacketExtension copy = new DtlsFingerprintPacketExtension();
                copy.setFingerprint(dtlsFingerprint.getFingerprint());
                copy.setHash(dtlsFingerprint.getHash());
                copy.setRequired(dtlsFingerprint.getRequired());
                copy.setSetup(dtlsFingerprint.getSetup());
                dst.addChildExtension(copy);
            }
        }
        return dst;
    }
}

