/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.util.BufferToImage;

public abstract class ImageIOEncoder
extends AbstractCodec
implements Codec {
    private final String formatName;
    private final Format[] supportedInputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, -1, -1, -1, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, -1, -1, -1, -1)};
    private BufferToImage bufferToImage;

    public ImageIOEncoder(String string) {
        this.formatName = string;
        if (!ImageIO.getImageWritersByFormatName(string).hasNext()) {
            throw new RuntimeException("No ImageIO writer found for " + string);
        }
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        BufferedImage bufferedImage = (BufferedImage)this.bufferToImage.createImage(buffer);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (!ImageIO.write((RenderedImage)bufferedImage, this.formatName, byteArrayOutputStream)) {
                throw new RuntimeException("No ImageIO writer found for " + this.formatName);
            }
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            buffer2.setData(byArray);
            buffer2.setOffset(0);
            buffer2.setLength(byArray.length);
            return 0;
        }
        catch (IOException iOException) {
            buffer2.setDiscard(true);
            buffer2.setLength(0);
            return 1;
        }
    }

    public Format setInputFormat(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        if (videoFormat.getSize() == null) {
            return null;
        }
        this.bufferToImage = new BufferToImage((VideoFormat)format);
        return super.setInputFormat(format);
    }
}

