/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.util;

import java.util.StringTokenizer;

public class FullNick {
    private String nick;
    private String user;
    private String remotehost;
    private String original;

    public FullNick(String original) {
        this.original = original;
        this.parse(original);
    }

    private void parse(String original) {
        if (original == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(original, "!", false);
        this.nick = tokens.nextToken();
        if (tokens.hasMoreTokens()) {
            this.user = tokens.nextToken("@");
            if (this.user.charAt(0) == '!') {
                this.user = this.user.substring(1);
            }
        }
        if (tokens.hasMoreTokens()) {
            this.remotehost = tokens.nextToken("");
            if (this.remotehost.charAt(0) == '@') {
                this.remotehost = this.remotehost.substring(1);
            }
        }
    }

    public String getNick() {
        return this.nick;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.remotehost;
    }

    public String getSource() {
        return this.original;
    }

    public int hashCode() {
        if (this.nick == null) {
            return 0;
        }
        return this.nick.hashCode();
    }

    public boolean equals(String nick) {
        if (nick == null) {
            return false;
        }
        return nick.equalsIgnoreCase(this.nick);
    }

    public boolean equals(FullNick nick) {
        if (nick == null) {
            return false;
        }
        return this.equals(nick.getNick());
    }

    public boolean equals(Object object) {
        if (object instanceof FullNick) {
            return this.equals((FullNick)object);
        }
        return false;
    }

    public String toString() {
        return this.nick;
    }

    public static void main(String[] args) {
        FullNick nick = new FullNick(args[0]);
        System.out.println(nick.getNick());
        System.out.println(nick.getUser());
        System.out.println(nick.getHost());
        System.out.println(nick.getSource());
        if (args.length > 1) {
            FullNick nick2 = new FullNick(args[1]);
            System.out.println("");
            System.out.println(nick2.getNick());
            System.out.println(nick2.getUser());
            System.out.println(nick2.getHost());
            System.out.println(nick2.getSource());
            System.out.println(nick2.equals(nick) ? "Equal." : "Not equal.");
        }
    }
}

