/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.AbstractIcbm;
import net.kano.joscar.snaccmd.icbm.ParamInfoRequest;
import net.kano.joscar.snaccmd.icbm.RvResponse;
import net.kano.joscar.snaccmd.icbm.SendImIcbm;
import net.kano.joscar.snaccmd.icbm.SendRvIcbm;
import net.kano.joscar.snaccmd.icbm.SendTypingNotification;
import net.kano.joscar.snaccmd.icbm.SetParamInfoCmd;
import net.kano.joscar.snaccmd.icbm.WarnCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerIcbmCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList((Object[])new CmdType[]{new CmdType(4, 4), new CmdType(4, 2), new CmdType(4, 6), new CmdType(4, 20), new CmdType(4, 8), new CmdType(4, 11)});

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket packet) {
        if (packet.getFamily() != 4) {
            return null;
        }
        int command = packet.getCommand();
        if (command == 4) {
            return new ParamInfoRequest(packet);
        }
        if (command == 2) {
            return new SetParamInfoCmd(packet);
        }
        if (command == 6) {
            int channel = AbstractIcbm.getIcbmChannel(packet);
            if (channel == 1) {
                return new SendImIcbm(packet);
            }
            if (channel == 2) {
                return new SendRvIcbm(packet);
            }
            return null;
        }
        if (command == 20) {
            return new SendTypingNotification(packet);
        }
        if (command == 8) {
            return new WarnCmd(packet);
        }
        if (command == 11) {
            return new RvResponse(packet);
        }
        return null;
    }
}

