/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.nio.Bits;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.BinaryClassDefinitionProxy;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionImpl;
import com.hazelcast.nio.serialization.ClassDefinitionWriter;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldDefinitionImpl;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.serialization.PortableVersionHelper;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

final class PortableContextImpl
implements PortableContext {
    private static final Pattern NESTED_FIELD_PATTERN = Pattern.compile("\\.");
    private static final int COMPRESSION_BUFFER_LENGTH = 1024;
    private final int version;
    private final ConcurrentHashMap<Integer, ClassDefinitionContext> classDefContextMap = new ConcurrentHashMap();
    private final SerializationService serializationService;
    private final ConstructorFunction<Integer, ClassDefinitionContext> constructorFunction = new ConstructorFunction<Integer, ClassDefinitionContext>(){

        @Override
        public ClassDefinitionContext createNew(Integer arg) {
            return new ClassDefinitionContext(arg);
        }
    };

    PortableContextImpl(SerializationService serializationService, int version) {
        this.serializationService = serializationService;
        this.version = version;
    }

    @Override
    public int getClassVersion(int factoryId, int classId) {
        return this.getClassDefContext(factoryId).getClassVersion(classId);
    }

    @Override
    public void setClassVersion(int factoryId, int classId, int version) {
        this.getClassDefContext(factoryId).setClassVersion(classId, version);
    }

    @Override
    public ClassDefinition lookupClassDefinition(int factoryId, int classId, int version) {
        return this.getClassDefContext(factoryId).lookup(classId, version);
    }

    @Override
    public ClassDefinition lookupClassDefinition(Data data) {
        if (!data.isPortable()) {
            throw new IllegalArgumentException("Data is not Portable!");
        }
        ByteOrder byteOrder = this.serializationService.getByteOrder();
        return this.readClassDefinition(data, 0, byteOrder);
    }

    private ClassDefinition readClassDefinition(Data data, int start, ByteOrder order) {
        int factoryId = data.readIntHeader(start + 0, order);
        int classId = data.readIntHeader(start + 4, order);
        int version = data.readIntHeader(start + 8, order);
        return this.lookupClassDefinition(factoryId, classId, version);
    }

    @Override
    public boolean hasClassDefinition(Data data) {
        if (data.isPortable()) {
            return true;
        }
        return data.headerSize() > 0;
    }

    @Override
    public ClassDefinition[] getClassDefinitions(Data data) {
        if (data.headerSize() == 0) {
            return null;
        }
        int len = data.headerSize();
        if (len % 12 != 0) {
            throw new AssertionError((Object)"Header length should be factor of 12");
        }
        int k = len / 12;
        ByteOrder byteOrder = this.serializationService.getByteOrder();
        ClassDefinition[] definitions = new ClassDefinition[k];
        for (int i = 0; i < k; ++i) {
            definitions[i] = this.readClassDefinition(data, i * 12, byteOrder);
        }
        return definitions;
    }

    @Override
    public ClassDefinition createClassDefinition(int factoryId, byte[] compressedBinary) throws IOException {
        return this.getClassDefContext(factoryId).create(compressedBinary);
    }

    @Override
    public ClassDefinition registerClassDefinition(ClassDefinition cd) {
        return this.getClassDefContext(cd.getFactoryId()).register(cd);
    }

    @Override
    public ClassDefinition lookupOrRegisterClassDefinition(Portable p) throws IOException {
        int portableVersion = PortableVersionHelper.getVersion(p, this.version);
        ClassDefinition cd = this.lookupClassDefinition(p.getFactoryId(), p.getClassId(), portableVersion);
        if (cd == null) {
            ClassDefinitionWriter writer = new ClassDefinitionWriter(this, p.getFactoryId(), p.getClassId(), portableVersion);
            p.writePortable(writer);
            cd = writer.registerAndGet();
        }
        return cd;
    }

    @Override
    public FieldDefinition getFieldDefinition(ClassDefinition classDef, String name) {
        String[] fieldNames;
        FieldDefinition fd = classDef.getField(name);
        if (fd == null && (fieldNames = NESTED_FIELD_PATTERN.split(name)).length > 1) {
            ClassDefinition currentClassDef = classDef;
            for (int i = 0; i < fieldNames.length; ++i) {
                name = fieldNames[i];
                fd = currentClassDef.getField(name);
                if (i == fieldNames.length - 1) break;
                if (fd == null) {
                    throw new IllegalArgumentException("Unknown field: " + name);
                }
                currentClassDef = this.lookupClassDefinition(fd.getFactoryId(), fd.getClassId(), currentClassDef.getVersion());
                if (currentClassDef != null) continue;
                throw new IllegalArgumentException("Not a registered Portable field: " + fd);
            }
        }
        return fd;
    }

    private ClassDefinitionContext getClassDefContext(int factoryId) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.classDefContextMap, factoryId, this.constructorFunction);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public ManagedContext getManagedContext() {
        return this.serializationService.getManagedContext();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.serializationService.getByteOrder();
    }

    private static void writeClassDefinition(ClassDefinition classDefinition, ObjectDataOutput out) throws IOException {
        ClassDefinitionImpl cd = (ClassDefinitionImpl)classDefinition;
        out.writeInt(cd.getFactoryId());
        out.writeInt(cd.getClassId());
        out.writeInt(cd.getVersion());
        Collection<FieldDefinition> fieldDefinitions = cd.getFieldDefinitions();
        out.writeShort(fieldDefinitions.size());
        for (FieldDefinition fieldDefinition : fieldDefinitions) {
            PortableContextImpl.writeFieldDefinition((FieldDefinitionImpl)fieldDefinition, out);
        }
    }

    private static ClassDefinitionImpl readClassDefinition(ObjectDataInput in) throws IOException {
        int factoryId = in.readInt();
        int classId = in.readInt();
        int version = in.readInt();
        if (classId == 0) {
            throw new IllegalArgumentException("Portable class id cannot be zero!");
        }
        ClassDefinitionImpl cd = new ClassDefinitionImpl(factoryId, classId, version);
        int len = in.readShort();
        for (int i = 0; i < len; ++i) {
            FieldDefinitionImpl fd = PortableContextImpl.readFieldDefinition(in);
            cd.addFieldDef(fd);
        }
        return cd;
    }

    private static void writeFieldDefinition(FieldDefinitionImpl fd, ObjectDataOutput out) throws IOException {
        out.writeInt(fd.index);
        out.writeUTF(fd.fieldName);
        out.writeByte(fd.type.getId());
        out.writeInt(fd.factoryId);
        out.writeInt(fd.classId);
    }

    private static FieldDefinitionImpl readFieldDefinition(ObjectDataInput in) throws IOException {
        int index = in.readInt();
        String name = in.readUTF();
        byte typeId = in.readByte();
        int factoryId = in.readInt();
        int classId = in.readInt();
        return new FieldDefinitionImpl(index, name, FieldType.get(typeId), factoryId, classId);
    }

    private static void compress(byte[] input, DataOutput out) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setLevel(-1);
        deflater.setStrategy(1);
        deflater.setInput(input);
        deflater.finish();
        byte[] buf = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buf);
            out.write(buf, 0, count);
        }
        deflater.end();
    }

    private static void decompress(byte[] compressedData, DataOutput out) throws IOException {
        Inflater inflater = new Inflater();
        inflater.setInput(compressedData);
        byte[] buf = new byte[1024];
        while (!inflater.finished()) {
            try {
                int count = inflater.inflate(buf);
                out.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
        }
        inflater.end();
    }

    private final class ClassDefinitionContext {
        final int factoryId;
        final ConcurrentMap<Long, ClassDefinition> versionedDefinitions = new ConcurrentHashMap<Long, ClassDefinition>();
        final ConcurrentMap<Integer, Integer> currentClassVersions = new ConcurrentHashMap<Integer, Integer>();

        private ClassDefinitionContext(int factoryId) {
            this.factoryId = factoryId;
        }

        int getClassVersion(int classId) {
            Integer version = (Integer)this.currentClassVersions.get(classId);
            return version != null ? version : -1;
        }

        void setClassVersion(int classId, int version) {
            Integer current = this.currentClassVersions.putIfAbsent(classId, version);
            if (current != null && current != version) {
                throw new IllegalArgumentException("Class-id: " + classId + " is already registered!");
            }
        }

        ClassDefinition lookup(int classId, int version) {
            long versionedClassId = Bits.combineToLong(classId, version);
            ClassDefinition cd = (ClassDefinition)this.versionedDefinitions.get(versionedClassId);
            if (cd instanceof BinaryClassDefinitionProxy) {
                try {
                    cd = this.create(((BinaryClassDefinitionProxy)cd).getBinary());
                }
                catch (IOException e) {
                    throw new HazelcastSerializationException(e);
                }
            }
            return cd;
        }

        ClassDefinition create(byte[] compressedBinary) throws IOException {
            ClassDefinition cd = this.toClassDefinition(compressedBinary);
            return this.register(cd);
        }

        ClassDefinition register(ClassDefinition cd) {
            long versionedClassId;
            ClassDefinition currentCd;
            if (cd == null) {
                return null;
            }
            if (cd.getFactoryId() != this.factoryId) {
                throw new HazelcastSerializationException("Invalid factory-id! " + this.factoryId + " -> " + cd);
            }
            if (cd instanceof ClassDefinitionImpl) {
                ClassDefinitionImpl cdImpl = (ClassDefinitionImpl)cd;
                cdImpl.setVersionIfNotSet(PortableContextImpl.this.getVersion());
                this.setClassDefBinary(cdImpl);
            }
            if ((currentCd = this.versionedDefinitions.putIfAbsent(versionedClassId = Bits.combineToLong(cd.getClassId(), cd.getVersion()), cd)) == null) {
                return cd;
            }
            if (currentCd instanceof ClassDefinitionImpl) {
                if (!currentCd.equals(cd)) {
                    throw new HazelcastSerializationException("Incompatible class-definitions with same class-id: " + cd + " VS " + currentCd);
                }
                return currentCd;
            }
            this.versionedDefinitions.put(versionedClassId, cd);
            return cd;
        }

        private void setClassDefBinary(ClassDefinitionImpl cd) {
            if (cd.getBinary() == null) {
                try {
                    byte[] binary = this.toClassDefinitionBinary(cd);
                    cd.setBinary(binary);
                }
                catch (IOException e) {
                    throw new HazelcastSerializationException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] toClassDefinitionBinary(ClassDefinition cd) throws IOException {
            BufferObjectDataOutput out = PortableContextImpl.this.serializationService.pop();
            try {
                PortableContextImpl.writeClassDefinition(cd, out);
                byte[] binary = out.toByteArray();
                out.clear();
                PortableContextImpl.compress(binary, out);
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                PortableContextImpl.this.serializationService.push(out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClassDefinition toClassDefinition(byte[] compressedBinary) throws IOException {
            byte[] binary;
            if (compressedBinary == null || compressedBinary.length == 0) {
                throw new IOException("Illegal class-definition binary! ");
            }
            BufferObjectDataOutput out = PortableContextImpl.this.serializationService.pop();
            try {
                PortableContextImpl.decompress(compressedBinary, out);
                binary = out.toByteArray();
            }
            finally {
                PortableContextImpl.this.serializationService.push(out);
            }
            ClassDefinitionImpl cd = PortableContextImpl.readClassDefinition(PortableContextImpl.this.serializationService.createObjectDataInput(binary));
            if (cd.getVersion() < 0) {
                throw new IOException("ClassDefinition version cannot be negative! -> " + cd);
            }
            cd.setBinary(compressedBinary);
            return cd;
        }
    }
}

