/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.demo;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdToolkit;

public class HeartbeatFix {
    public static void main(String[] stringArray) throws IOException, RrdException {
        if (stringArray.length != 2) {
            System.err.println("SYNTAX: HeartbeatFix <rrd directory> <heartbeat>");
            System.exit(-1);
        }
        File file = new File(stringArray[0]);
        long l = Long.parseLong(stringArray[1]);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".rrd.jrb");
            }
        });
        System.out.println(fileArray.length + " files found");
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getAbsolutePath();
            System.out.print(i + 1 + ": " + string + ": ");
            RrdToolkit.setDsHeartbeat(fileArray[i].getAbsolutePath(), 0, l);
            RrdToolkit.setDsHeartbeat(fileArray[i].getAbsolutePath(), 1, l);
            System.out.print("fixed");
            RrdDb rrdDb = new RrdDb(string);
            if (rrdDb.getRrdDef().getEstimatedSize() == fileArray[i].length() && rrdDb.getDatasource(0).getHeartbeat() == l && rrdDb.getDatasource(1).getHeartbeat() == l) {
                System.out.println(", verified");
            } else {
                System.out.println(", ********** ERROR **********");
            }
            rrdDb.close();
        }
        System.out.println("FINISHED!");
    }
}

