/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.ParameterNameProvider;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;

public abstract class ExecutableElement {
    public static ExecutableElement forConstructor(Constructor<?> constructor) {
        return new ConstructorElement(constructor);
    }

    public static List<ExecutableElement> forConstructors(Constructor<?>[] constructors) {
        ArrayList<ExecutableElement> executableElements = CollectionHelper.newArrayList(constructors.length);
        for (Constructor<?> constructor : constructors) {
            executableElements.add(ExecutableElement.forConstructor(constructor));
        }
        return executableElements;
    }

    public static ExecutableElement forMethod(Method method) {
        return new MethodElement(method);
    }

    public static List<ExecutableElement> forMethods(Method[] methods) {
        ArrayList<ExecutableElement> executableElements = CollectionHelper.newArrayList(methods.length);
        for (Method method : methods) {
            executableElements.add(ExecutableElement.forMethod(method));
        }
        return executableElements;
    }

    private ExecutableElement() {
    }

    public abstract List<String> getParameterNames(ParameterNameProvider var1);

    public abstract Annotation[][] getParameterAnnotations();

    public abstract Class<?>[] getParameterTypes();

    public abstract Class<?> getReturnType();

    public abstract Type[] getGenericParameterTypes();

    public abstract AccessibleObject getAccessibleObject();

    public abstract Member getMember();

    public abstract ElementType getElementType();

    public abstract String getSimpleName();

    public abstract boolean isGetterMethod();

    public String getIdentifier() {
        return this.getSimpleName() + Arrays.toString(this.getParameterTypes());
    }

    public boolean overrides(ExecutableElement other) {
        if (this.getMember() instanceof Constructor || other.getMember() instanceof Constructor) {
            return false;
        }
        return ReflectionHelper.overrides((Method)this.getMember(), (Method)other.getMember());
    }

    private static class ConstructorElement
    extends ExecutableElement {
        private final Constructor<?> constructor;

        private ConstructorElement(Constructor<?> method) {
            this.constructor = method;
        }

        @Override
        public List<String> getParameterNames(ParameterNameProvider parameterNameProvider) {
            return parameterNameProvider.getParameterNames(this.constructor);
        }

        @Override
        public Annotation[][] getParameterAnnotations() {
            int parameterCount;
            Annotation[][] parameterAnnotations = this.constructor.getParameterAnnotations();
            if (parameterAnnotations.length == (parameterCount = this.constructor.getParameterTypes().length)) {
                return parameterAnnotations;
            }
            return this.paddedLeft((T[])parameterAnnotations, (T[])new Annotation[parameterCount][], (Object)new Annotation[0]);
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.constructor.getParameterTypes();
        }

        @Override
        public Class<?> getReturnType() {
            return this.constructor.getDeclaringClass();
        }

        @Override
        public Type[] getGenericParameterTypes() {
            return this.constructor.getGenericParameterTypes();
        }

        @Override
        public AccessibleObject getAccessibleObject() {
            return this.constructor;
        }

        @Override
        public Member getMember() {
            return this.constructor;
        }

        @Override
        public ElementType getElementType() {
            return ElementType.CONSTRUCTOR;
        }

        @Override
        public String getSimpleName() {
            return this.constructor.getDeclaringClass().getSimpleName();
        }

        @Override
        public boolean isGetterMethod() {
            return false;
        }

        public String toString() {
            return this.constructor.toGenericString();
        }

        private <T> T[] paddedLeft(T[] src, T[] dest, T fillElement) {
            int originalCount = src.length;
            int targetCount = dest.length;
            System.arraycopy(src, 0, dest, targetCount - originalCount, originalCount);
            Arrays.fill(dest, 0, targetCount - originalCount, fillElement);
            return dest;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.constructor == null ? 0 : this.constructor.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstructorElement other = (ConstructorElement)obj;
            return !(this.constructor == null ? other.constructor != null : !this.constructor.equals(other.constructor));
        }
    }

    private static class MethodElement
    extends ExecutableElement {
        private final Method method;
        private final boolean isGetterMethod;

        public MethodElement(Method method) {
            this.method = method;
            this.isGetterMethod = ReflectionHelper.isGetterMethod(method);
        }

        @Override
        public List<String> getParameterNames(ParameterNameProvider parameterNameProvider) {
            return parameterNameProvider.getParameterNames(this.method);
        }

        @Override
        public Annotation[][] getParameterAnnotations() {
            return this.method.getParameterAnnotations();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public Type[] getGenericParameterTypes() {
            return this.method.getGenericParameterTypes();
        }

        @Override
        public AccessibleObject getAccessibleObject() {
            return this.method;
        }

        @Override
        public Member getMember() {
            return this.method;
        }

        @Override
        public ElementType getElementType() {
            return ElementType.METHOD;
        }

        @Override
        public String getSimpleName() {
            return this.method.getName();
        }

        @Override
        public boolean isGetterMethod() {
            return this.isGetterMethod;
        }

        public String toString() {
            return this.method.toGenericString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodElement other = (MethodElement)obj;
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }
    }
}

