/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.operation.LockAwareOperation;
import com.hazelcast.map.operation.RemoveBackupOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.Clock;

public abstract class BaseRemoveOperation
extends LockAwareOperation
implements BackupAwareOperation {
    protected transient Data dataOldValue;

    public BaseRemoveOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    public BaseRemoveOperation() {
    }

    @Override
    public void afterRun() {
        this.mapService.interceptAfterRemove(this.name, this.dataValue);
        this.mapService.publishEvent(this.getCallerAddress(), this.name, EntryEventType.REMOVED, this.dataKey, this.dataOldValue, null);
        this.invalidateNearCaches();
        if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
            this.mapService.publishWanReplicationRemove(this.name, this.dataKey, Clock.currentTimeMillis());
        }
    }

    @Override
    public Object getResponse() {
        return this.dataOldValue;
    }

    @Override
    public Operation getBackupOperation() {
        return new RemoveBackupOperation(this.name, this.dataKey);
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }

    public String toString() {
        return "BaseRemoveOperation{" + this.name + "}";
    }
}

