/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.services;

import f00f.net.irc.martyr.GenericAutoService;
import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.State;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.commands.QuitCommand;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AutoReconnect
extends GenericAutoService {
    static Logger log = Logger.getLogger(AutoReconnect.class);
    private int attempt;
    private int maxAttempts;
    private int sleepTime;
    private boolean disableOnQuit;
    public static final int DEFAULT_MAX_ATTEMPTS = 5;
    public static final int DEFAULT_CONNECT_SLEEPTIME = 1000;
    public static final boolean DEFAULT_DISABLE_ON_QUIT = true;

    public AutoReconnect(IRCConnection connection, int maxAttempts, int sleepBetween, boolean disableOnQuit) {
        super(connection);
        this.disableOnQuit = disableOnQuit;
        this.maxAttempts = maxAttempts;
        this.sleepTime = sleepBetween;
        this.attempt = 0;
        this.enable();
    }

    public AutoReconnect(IRCConnection connection, int maxAttempts, int sleepBetween) {
        this(connection, maxAttempts, sleepBetween, true);
    }

    public AutoReconnect(IRCConnection connection) {
        this(connection, 5, 1000);
    }

    public void go(String server, int port) {
        this.doConnectionLoop(server, port);
    }

    protected void connect() throws IOException {
        ClientState cstate = this.getConnection().getClientState();
        this.connect(cstate.getServer(), cstate.getPort());
    }

    protected void connect(String server, int port) throws IOException {
        this.getConnection().connect(server, port);
    }

    protected void updateState(State state) {
        log.debug((Object)("AutoReconnect: Update with state " + state));
        if (state == State.UNCONNECTED) {
            if (this.failedToConnect(null)) {
                this.doConnectionLoop();
            }
        } else if (state == State.REGISTERED) {
            this.attempt = 0;
        }
        log.debug((Object)("AutoReconnect: Returned from " + state));
    }

    protected void doConnectionLoop() {
        this.doConnectionLoop(null, -1);
    }

    protected void doConnectionLoop(String server, int port) {
        boolean keeptrying = true;
        while (keeptrying && this.enabled) {
            Exception error = null;
            try {
                if (server == null) {
                    this.connect();
                } else {
                    this.connect(server, port);
                }
                keeptrying = false;
            }
            catch (Exception e) {
                error = e;
                keeptrying = true;
            }
            if (!keeptrying) continue;
            keeptrying = this.failedToConnect(error);
        }
    }

    protected void finalFailure() {
        log.debug((Object)"AutoReconnect: Final failure.");
        this.attempt = 0;
    }

    protected boolean failedToConnect(Exception error) {
        log.debug((Object)("AutoReconnect: Error connecting: " + error));
        ++this.attempt;
        if (this.attempt >= this.maxAttempts) {
            log.debug((Object)("AutoReconnect: Tried " + this.attempt + " times, giving up."));
            this.finalFailure();
            return false;
        }
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException ie) {
            return false;
        }
        return true;
    }

    protected void updateCommand(InCommand command) {
        if (this.disableOnQuit && command instanceof QuitCommand && ((QuitCommand)command).isOurQuit(this.getConnection().getClientState())) {
            log.debug((Object)"AutoReconnect: Disabling due to receiving own QUIT.");
            this.disable();
        }
    }

    public String toString() {
        return "AutoReconnect [" + this.attempt + "]";
    }
}

