/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import javax.sip.address.Hop;

public final class HopImpl
implements Hop {
    protected String host;
    protected int port;
    protected String transport;
    protected boolean defaultRoute;
    protected boolean uriRoute;

    public String toString() {
        return this.host + ":" + this.port + "/" + this.transport;
    }

    public HopImpl(String string, int n, String string2) {
        this.host = string;
        if (this.host.indexOf(":") >= 0 && this.host.indexOf("[") < 0) {
            this.host = "[" + this.host + "]";
        }
        this.port = n;
        this.transport = string2;
    }

    HopImpl(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null arg!");
        }
        int n = string.indexOf(93);
        int n2 = string.indexOf(58, n);
        int n3 = string.indexOf(47, n2);
        if (n2 > 0) {
            String string2;
            this.host = string.substring(0, n2);
            if (n3 > 0) {
                string2 = string.substring(n2 + 1, n3);
                this.transport = string.substring(n3 + 1);
            } else {
                string2 = string.substring(n2 + 1);
                this.transport = "UDP";
            }
            try {
                this.port = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Bad port spec");
            }
        } else if (n3 > 0) {
            this.host = string.substring(0, n3);
            this.transport = string.substring(n3 + 1);
            this.port = this.transport.equalsIgnoreCase("TLS") ? 5061 : 5060;
        } else {
            this.host = string;
            this.transport = "UDP";
            this.port = 5060;
        }
        if (this.host == null || this.host.length() == 0) {
            throw new IllegalArgumentException("no host!");
        }
        this.host = this.host.trim();
        this.transport = this.transport.trim();
        if (n > 0 && this.host.charAt(0) != '[') {
            throw new IllegalArgumentException("Bad IPv6 reference spec");
        }
        if (this.transport.compareToIgnoreCase("UDP") != 0 && this.transport.compareToIgnoreCase("TLS") != 0 && this.transport.compareToIgnoreCase("TCP") != 0) {
            System.out.println("Bad transport string " + this.transport);
            throw new IllegalArgumentException(string);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    public boolean isURIRoute() {
        return this.uriRoute;
    }

    public void setURIRouteFlag() {
        this.uriRoute = true;
    }
}

