/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.transaction.impl.TransactionLog;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public final class ReplicateTxOperation
extends Operation {
    private final List<TransactionLog> txLogs = new LinkedList<TransactionLog>();
    private String callerUuid;
    private String txnId;
    private long timeoutMillis;
    private long startTime;

    public ReplicateTxOperation() {
    }

    public ReplicateTxOperation(List<TransactionLog> logs, String callerUuid, String txnId, long timeoutMillis, long startTime) {
        this.txLogs.addAll(logs);
        this.callerUuid = callerUuid;
        this.txnId = txnId;
        this.timeoutMillis = timeoutMillis;
        this.startTime = startTime;
    }

    @Override
    public String getServiceName() {
        return "hz:core:txManagerService";
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        TransactionManagerServiceImpl txManagerService = (TransactionManagerServiceImpl)this.getService();
        txManagerService.prepareTxBackupLog(this.txLogs, this.callerUuid, this.txnId, this.timeoutMillis, this.startTime);
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public ExceptionAction onException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onException(throwable);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.callerUuid);
        out.writeUTF(this.txnId);
        out.writeLong(this.timeoutMillis);
        out.writeLong(this.startTime);
        int len = this.txLogs.size();
        out.writeInt(len);
        if (len > 0) {
            for (TransactionLog txLog : this.txLogs) {
                out.writeObject(txLog);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.callerUuid = in.readUTF();
        this.txnId = in.readUTF();
        this.timeoutMillis = in.readLong();
        this.startTime = in.readLong();
        int len = in.readInt();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                TransactionLog txLog = (TransactionLog)in.readObject();
                this.txLogs.add(txLog);
            }
        }
    }
}

