/*
 * Decompiled with CFR 0.152.
 */
package com.rayo.core.verb;

import com.rayo.core.verb.BaseVerb;
import com.rayo.core.verb.Ssml;
import com.voxeo.moho.media.output.OutputCommand;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.mediagroup.CodecConstants;
import javax.media.mscontrol.mediagroup.FileFormatConstants;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.joda.time.Duration;

public class Output
extends BaseVerb {
    public static final String MISSING_PROMPT = "Nothing to do";
    private OutputCommand.BargeinType bargeinType;
    private Duration startOffset;
    private Boolean startPaused;
    private Duration repeatInterval;
    private Integer repeatTimes;
    private Duration maxTime;
    private String voice;
    private Boolean broadcast;
    @Valid
    @NotNull(message="Nothing to do")
    private Ssml prompt;

    public Ssml getPrompt() {
        return this.prompt;
    }

    public void setPrompt(Ssml prompt) {
        this.prompt = prompt;
    }

    public OutputCommand.BargeinType getBargeinType() {
        return this.bargeinType;
    }

    public void setBargeinType(OutputCommand.BargeinType type) {
        this.bargeinType = type;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String voice) {
        this.voice = voice;
    }

    public Duration getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(Duration offset) {
        this.startOffset = offset;
    }

    public Integer getRepeatTimes() {
        return this.repeatTimes;
    }

    public void setRepeatTimes(Integer repeatTimes) {
        this.repeatTimes = repeatTimes;
    }

    public Boolean isStartPaused() {
        return this.startPaused;
    }

    public void setStartPaused(Boolean startInPauseMode) {
        this.startPaused = startInPauseMode;
    }

    public static Value toFileFormat(String format) {
        format = "FORMAT_" + format;
        if (FileFormatConstants.FORMAT_3G2.toString().equalsIgnoreCase(format)) {
            return FileFormatConstants.FORMAT_3G2;
        }
        if (FileFormatConstants.FORMAT_3GP.toString().equalsIgnoreCase(format)) {
            return FileFormatConstants.FORMAT_3GP;
        }
        if (FileFormatConstants.GSM.toString().equalsIgnoreCase(format)) {
            return FileFormatConstants.GSM;
        }
        if (FileFormatConstants.INFERRED.toString().equalsIgnoreCase(format)) {
            return FileFormatConstants.INFERRED;
        }
        if (FileFormatConstants.RAW.toString().equalsIgnoreCase(format)) {
            return FileFormatConstants.RAW;
        }
        if (FileFormatConstants.WAV.toString().equalsIgnoreCase(format)) {
            return FileFormatConstants.WAV;
        }
        if (format.equalsIgnoreCase("FORMAT_MP3")) {
            return FileFormatConstants.INFERRED;
        }
        return null;
    }

    public static Value toCodecValue(String codec) {
        if (CodecConstants.ADPCM_16K_G726.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.ADPCM_16K_G726;
        }
        if (CodecConstants.ADPCM_32K.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.ADPCM_32K;
        }
        if (CodecConstants.ADPCM_32K_G726.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.ADPCM_32K_G726;
        }
        if (CodecConstants.ADPCM_32K_OKI.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.ADPCM_32K_OKI;
        }
        if (CodecConstants.ALAW_PCM_48K.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.ALAW_PCM_48K;
        }
        if (CodecConstants.ALAW_PCM_64K.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.ALAW_PCM_64K;
        }
        if (CodecConstants.AMR.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.AMR;
        }
        if (CodecConstants.AMR_WB.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.AMR_WB;
        }
        if (CodecConstants.EVRC.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.EVRC;
        }
        if (CodecConstants.G723_1B.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.G723_1B;
        }
        if (CodecConstants.G729_A.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.G729_A;
        }
        if (CodecConstants.GSM.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.GSM;
        }
        if (CodecConstants.H263.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.H263;
        }
        if (CodecConstants.H263_1998.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.H263_1998;
        }
        if (CodecConstants.H264.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.H264;
        }
        if (CodecConstants.INFERRED.toString().equalsIgnoreCase("CODEC_" + codec)) {
            return CodecConstants.INFERRED;
        }
        if (CodecConstants.LINEAR_16BIT_128K.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.LINEAR_16BIT_128K;
        }
        if (CodecConstants.LINEAR_16BIT_256K.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.LINEAR_16BIT_256K;
        }
        if (CodecConstants.LINEAR_8BIT_64K.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.LINEAR_8BIT_64K;
        }
        if (CodecConstants.MP4V_ES.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.MP4V_ES;
        }
        if (CodecConstants.MULAW_PCM_64K.toString().equalsIgnoreCase(codec)) {
            return CodecConstants.MULAW_PCM_64K;
        }
        return null;
    }

    public Duration getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(Duration repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public Duration getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(Duration maxTime) {
        this.maxTime = maxTime;
    }

    public Boolean getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(Boolean broadcast) {
        this.broadcast = broadcast;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("callId", (Object)this.getCallId()).append("verbId", (Object)this.getVerbId()).append("interrupt-on", (Object)this.getBargeinType()).append("start-offset", this.getStartOffset() != null ? Long.valueOf(this.getStartOffset().getMillis()) : null).append("start-paused", (Object)this.isStartPaused()).append("repeatInterval", this.getRepeatInterval() != null ? Long.valueOf(this.getRepeatInterval().getMillis()) : null).append("repeatTimes", (Object)this.getRepeatTimes()).append("maxTime", this.getMaxTime() != null ? Long.valueOf(this.getMaxTime().getMillis()) : null).append("voice", (Object)this.getVoice()).append("prompt", (Object)this.getPrompt()).toString();
    }
}

