/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import com.lti.utils.synchronization.CloseableThread;
import com.lti.utils.synchronization.ProducerConsumerQueue;
import com.lti.utils.synchronization.SynchronizedObjectHolder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.utility.LoggerSingleton;

public class AsyncBufferTransferHandlerNotifier {
    private static final Logger logger = LoggerSingleton.logger;
    private final PushBufferStream stream;
    private final SynchronizedObjectHolder<BufferTransferHandler> transferHandlerHolder = new SynchronizedObjectHolder();
    private NotifyTransferHandlerThread notifyTransferHandlerThread;

    public AsyncBufferTransferHandlerNotifier(PushBufferStream stream) {
        this.stream = stream;
    }

    public void dispose() {
        if (this.notifyTransferHandlerThread != null) {
            this.notifyTransferHandlerThread.close();
            try {
                this.notifyTransferHandlerThread.waitUntilClosed();
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "" + e, e);
            }
            finally {
                this.notifyTransferHandlerThread = null;
            }
        }
    }

    public void disposeAsync() {
        if (this.notifyTransferHandlerThread != null) {
            this.notifyTransferHandlerThread.close();
            this.notifyTransferHandlerThread = null;
        }
    }

    public void notifyTransferHandlerAsync() throws InterruptedException {
        if (this.notifyTransferHandlerThread == null) {
            this.notifyTransferHandlerThread = new NotifyTransferHandlerThread("NotifyTransferHandlerThread for " + this.stream);
            this.notifyTransferHandlerThread.start();
        }
        this.notifyTransferHandlerThread.notifyTransferHandlerAsync();
    }

    public void notifyTransferHandlerSync() {
        BufferTransferHandler handler = this.transferHandlerHolder.getObject();
        if (handler != null) {
            handler.transferData(this.stream);
        }
    }

    public void setTransferHandler(BufferTransferHandler transferHandler) {
        this.transferHandlerHolder.setObject(transferHandler);
    }

    class NotifyTransferHandlerThread
    extends CloseableThread {
        private final ProducerConsumerQueue<Boolean> q;

        public NotifyTransferHandlerThread(String threadName) {
            super(threadName);
            this.q = new ProducerConsumerQueue();
            this.setDaemon(true);
        }

        public void notifyTransferHandlerAsync() throws InterruptedException {
            this.q.put(Boolean.TRUE);
        }

        public void run() {
            try {
                while (!this.isClosing()) {
                    if (this.q.get() == null) {
                        break;
                    }
                    AsyncBufferTransferHandlerNotifier.this.notifyTransferHandlerSync();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.setClosed();
            }
        }
    }
}

