/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.geolocation;

import net.java.sip.communicator.impl.protocol.jabber.extensions.geolocation.GeolocationPacketExtension;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.xmlpull.v1.XmlPullParser;

public class GeolocationPacketExtensionProvider
implements PacketExtensionProvider {
    private static final Logger logger = Logger.getLogger(GeolocationPacketExtensionProvider.class);
    public static final String ELEMENT_NAME = "geoloc";
    public static final String NAMESPACE = "http://jabber.org/protocol/geoloc";

    public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
        GeolocationPacketExtension result = new GeolocationPacketExtension();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Trying to map XML Geolocation Extension");
        }
        boolean done = false;
        while (!done) {
            try {
                int eventType = parser.next();
                if (eventType == 2) {
                    if (parser.getName().equals("alt")) {
                        result.setAlt(Float.parseFloat(parser.nextText()));
                    }
                    if (parser.getName().equals("area")) {
                        result.setArea(parser.nextText());
                    }
                    if (parser.getName().equals("bearing")) {
                        result.setBearing(Float.parseFloat(parser.nextText()));
                    }
                    if (parser.getName().equals("building")) {
                        result.setBuilding(parser.nextText());
                    }
                    if (parser.getName().equals("country")) {
                        result.setCountry(parser.nextText());
                    }
                    if (parser.getName().equals("datum")) {
                        result.setDatum(parser.nextText());
                    }
                    if (parser.getName().equals("description")) {
                        result.setDescription(parser.nextText());
                    }
                    if (parser.getName().equals("error")) {
                        result.setError(Float.parseFloat(parser.nextText()));
                    }
                    if (parser.getName().equals("floor")) {
                        result.setFloor(parser.nextText());
                    }
                    if (parser.getName().equals("lat")) {
                        result.setLat(Float.parseFloat(parser.nextText()));
                    }
                    if (parser.getName().equals("locality")) {
                        result.setLocality(parser.nextText());
                    }
                    if (parser.getName().equals("lon")) {
                        result.setLon(Float.parseFloat(parser.nextText()));
                    }
                    if (parser.getName().equals("postalcode")) {
                        result.setPostalCode(parser.nextText());
                    }
                    if (parser.getName().equals("region")) {
                        result.setRegion(parser.nextText());
                    }
                    if (parser.getName().equals("room")) {
                        result.setRoom(parser.nextText());
                    }
                    if (parser.getName().equals("street")) {
                        result.setStreet(parser.nextText());
                    }
                    if (parser.getName().equals("text")) {
                        result.setText(parser.nextText());
                    }
                    if (!parser.getName().equals("timestamp")) continue;
                    result.setText(parser.nextText());
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals(ELEMENT_NAME)) continue;
                done = true;
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)"Parsing finish");
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }
}

