/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.io.File;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.rewrite.handler.RewriteRegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.ConfigUtils;
import org.jitsi.videobridge.rest.HandlerImpl;
import org.jitsi.videobridge.rest.MuxServerConnector;
import org.jitsi.videobridge.rest.ProxyServletImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class RESTBundleActivator
implements BundleActivator {
    private static final String ENABLE_REST_SHUTDOWN_PNAME = "org.jitsi.videobridge.ENABLE_REST_SHUTDOWN";
    private static final String JETTY_HOST_PNAME = "org.jitsi.videobridge.rest.jetty.host";
    private static final String JETTY_PORT_PNAME = "org.jitsi.videobridge.rest.jetty.port";
    private static final String JETTY_PROXY_SERVLET_HOST_HEADER_PNAME = "org.jitsi.videobridge.rest.jetty.ProxyServlet.hostHeader";
    private static final String JETTY_PROXY_SERVLET_PATH_SPEC_PNAME = "org.jitsi.videobridge.rest.jetty.ProxyServlet.pathSpec";
    private static final String JETTY_PROXY_SERVLET_PROXY_TO_PNAME = "org.jitsi.videobridge.rest.jetty.ProxyServlet.proxyTo";
    private static final String JETTY_RESOURCE_HANDLER_RESOURCE_BASE_PNAME = "org.jitsi.videobridge.rest.jetty.ResourceHandler.resourceBase";
    private static final String JETTY_REWRITE_HANDLER_REGEX_PNAME = "org.jitsi.videobridge.rest.jetty.RewriteHandler.regex";
    private static final String JETTY_REWRITE_HANDLER_REPLACEMENT_PNAME = "org.jitsi.videobridge.rest.jetty.RewriteHandler.replacement";
    private static final String JETTY_SSLCONTEXTFACTORY_KEYSTOREPASSWORD = "org.jitsi.videobridge.rest.jetty.sslContextFactory.keyStorePassword";
    private static final String JETTY_SSLCONTEXTFACTORY_KEYSTOREPATH = "org.jitsi.videobridge.rest.jetty.sslContextFactory.keyStorePath";
    private static final String JETTY_SSLCONTEXTFACTORY_NEEDCLIENTAUTH = "org.jitsi.videobridge.rest.jetty.sslContextFactory.needClientAuth";
    private static final String JETTY_TLS_PORT_PNAME = "org.jitsi.videobridge.rest.jetty.tls.port";
    private static final Logger logger = Logger.getLogger(RESTBundleActivator.class);
    private ConfigurationService cfg;
    private Server server;

    private boolean getCfgBoolean(String property, boolean defaultValue) {
        String s;
        ConfigurationService cfg = this.cfg;
        boolean b = cfg == null ? ((s = System.getProperty(property)) == null || s.length() == 0 ? defaultValue : Boolean.parseBoolean(s)) : cfg.getBoolean(property, defaultValue);
        return b;
    }

    private int getCfgInt(String property, int defaultValue) {
        int i;
        ConfigurationService cfg = this.cfg;
        if (cfg == null) {
            String s = System.getProperty(property);
            if (s == null || s.length() == 0) {
                i = defaultValue;
            } else {
                try {
                    i = Integer.parseInt(s);
                }
                catch (NumberFormatException nfe) {
                    i = defaultValue;
                }
            }
        } else {
            i = cfg.getInt(property, defaultValue);
        }
        return i;
    }

    private String getCfgString(String property, String defaultValue) {
        ConfigurationService cfg = this.cfg;
        String s = cfg == null ? System.getProperty(property, defaultValue) : cfg.getString(property, defaultValue);
        return s;
    }

    private Handler initializeColibriHandler(BundleContext bundleContext, Server server) {
        return new HandlerImpl(bundleContext, this.getCfgBoolean(ENABLE_REST_SHUTDOWN_PNAME, false));
    }

    private Handler initializeHandler(BundleContext bundleContext, Server server) {
        Handler handler = this.initializeHandlerList(bundleContext, server);
        HandlerWrapper rewriteHandler = this.initializeRewriteHandler(bundleContext, server);
        if (rewriteHandler != null) {
            rewriteHandler.setHandler(handler);
            handler = rewriteHandler;
        }
        return handler;
    }

    private Handler initializeHandlerList(BundleContext bundleContext, Server server) {
        int handlerCount;
        Handler servletHandler;
        Handler resourceHandler;
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        Handler colibriHandler = this.initializeColibriHandler(bundleContext, server);
        if (colibriHandler != null) {
            handlers.add(colibriHandler);
        }
        if ((resourceHandler = this.initializeResourceHandler(bundleContext, server)) != null) {
            handlers.add(resourceHandler);
        }
        if ((servletHandler = this.initializeServletHandler(bundleContext, server)) != null) {
            handlers.add(servletHandler);
        }
        if ((handlerCount = handlers.size()) == 1) {
            return (Handler)handlers.get(0);
        }
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(handlers.toArray(new Handler[handlerCount]));
        return handlerList;
    }

    private Handler initializeResourceHandler(BundleContext bundleContext, Server server) {
        ResourceHandler resourceHandler;
        String resourceBase = this.getCfgString(JETTY_RESOURCE_HANDLER_RESOURCE_BASE_PNAME, null);
        if (resourceBase == null || resourceBase.length() == 0) {
            resourceHandler = null;
        } else {
            resourceHandler = new ResourceHandler();
            resourceHandler.setResourceBase(resourceBase);
        }
        return resourceHandler;
    }

    private HandlerWrapper initializeRewriteHandler(BundleContext bundleContext, Server server) {
        String replacement;
        String regex = this.getCfgString(JETTY_REWRITE_HANDLER_REGEX_PNAME, null);
        RewriteHandler handler = null;
        if (regex != null && regex.length() != 0 && (replacement = this.getCfgString(JETTY_REWRITE_HANDLER_REPLACEMENT_PNAME, null)) != null) {
            RewriteRegexRule rule = new RewriteRegexRule();
            rule.setRegex(regex);
            rule.setReplacement(replacement);
            handler = new RewriteHandler();
            handler.addRule((Rule)rule);
        }
        return handler;
    }

    private Handler initializeServletHandler(BundleContext bundleContext, Server server) {
        String proxyTo;
        String pathSpec = this.getCfgString(JETTY_PROXY_SERVLET_PATH_SPEC_PNAME, null);
        ServletContextHandler handler = null;
        if (pathSpec != null && pathSpec.length() != 0 && (proxyTo = this.getCfgString(JETTY_PROXY_SERVLET_PROXY_TO_PNAME, null)) != null && proxyTo.length() != 0) {
            ServletHolder holder = new ServletHolder();
            holder.setHeldClass(ProxyServletImpl.class);
            holder.setInitParameter("maxThreads", Integer.toString(256));
            holder.setInitParameter("prefix", pathSpec);
            holder.setInitParameter("proxyTo", proxyTo);
            String hostHeader = this.getCfgString(JETTY_PROXY_SERVLET_HOST_HEADER_PNAME, null);
            if (hostHeader != null && hostHeader.length() != 0) {
                holder.setInitParameter("hostHeader", hostHeader);
            }
            ServletContextHandler servletContextHandler = new ServletContextHandler();
            servletContextHandler.addServlet(holder, pathSpec);
            servletContextHandler.setContextPath("/");
            handler = servletContextHandler;
        }
        return handler;
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        if (!this.getCfgBoolean("org.jitsi.videobridge.rest", false)) {
            this.cfg = null;
            return;
        }
        try {
            MuxServerConnector connector;
            Server server = new Server();
            HttpConfiguration httpCfg = new HttpConfiguration();
            int tlsPort = this.getCfgInt(JETTY_TLS_PORT_PNAME, 8443);
            httpCfg.setSecurePort(tlsPort);
            httpCfg.setSecureScheme("https");
            String sslContextFactoryKeyStorePath = this.getCfgString(JETTY_SSLCONTEXTFACTORY_KEYSTOREPATH, null);
            if (sslContextFactoryKeyStorePath == null) {
                connector = new MuxServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpCfg)});
                connector.setPort(this.getCfgInt(JETTY_PORT_PNAME, 8080));
            } else {
                File sslContextFactoryKeyStoreFile = ConfigUtils.getAbsoluteFile((String)sslContextFactoryKeyStorePath, (ConfigurationService)this.cfg);
                SslContextFactory sslContextFactory = new SslContextFactory();
                String sslContextFactoryKeyStorePassword = this.getCfgString(JETTY_SSLCONTEXTFACTORY_KEYSTOREPASSWORD, null);
                boolean sslContextFactoryNeedClientAuth = this.getCfgBoolean(JETTY_SSLCONTEXTFACTORY_NEEDCLIENTAUTH, false);
                sslContextFactory.setExcludeCipherSuites(new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"});
                sslContextFactory.setIncludeCipherSuites(new String[]{".*RC4.*"});
                if (sslContextFactoryKeyStorePassword != null) {
                    sslContextFactory.setKeyStorePassword(sslContextFactoryKeyStorePassword);
                }
                sslContextFactory.setKeyStorePath(sslContextFactoryKeyStoreFile.getPath());
                sslContextFactory.setNeedClientAuth(sslContextFactoryNeedClientAuth);
                HttpConfiguration httpsCfg = new HttpConfiguration(httpCfg);
                httpsCfg.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                connector = new MuxServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsCfg)});
                connector.setPort(tlsPort);
            }
            String host = this.getCfgString(JETTY_HOST_PNAME, null);
            if (host != null) {
                connector.setHost(host);
            }
            server.addConnector((Connector)connector);
            Handler handler = this.initializeHandler(bundleContext, server);
            if (handler != null) {
                server.setHandler(handler);
            }
            server.start();
            this.server = server;
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to start the REST API of Jitsi Videobridge.", t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new UndeclaredThrowableException(t);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.server != null) {
            Thread.sleep(1000L);
            this.server.stop();
            this.server = null;
        }
        this.cfg = null;
    }
}

