/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.util.queue;

import net.sf.cindy.util.queue.BlockingQueue;
import net.sf.cindy.util.queue.QueueThread;
import net.sf.cindy.util.queue.QueueThreadPool;

public abstract class DefaultQueueThreadPool
implements QueueThreadPool {
    private QueueThread[] threads = new QueueThread[0];
    private int pos = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadPoolSize(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("thread pool size can't be negative");
        }
        QueueThread[] queueThreadArray = this.threads;
        synchronized (this.threads) {
            int n2 = n - this.threads.length;
            if (n2 == 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            QueueThread[] queueThreadArray2 = new QueueThread[n];
            if (n2 > 0) {
                System.arraycopy(this.threads, 0, queueThreadArray2, 0, this.threads.length);
                for (int i = 0; i < n2; ++i) {
                    QueueThread queueThread;
                    queueThreadArray2[this.threads.length + i] = queueThread = this.newQueueThread();
                    queueThread.start();
                }
                this.threads = queueThreadArray2;
            } else {
                int n3;
                System.arraycopy(this.threads, 0, queueThreadArray2, 0, queueThreadArray2.length);
                n2 = -n2;
                BlockingQueue[] blockingQueueArray = new BlockingQueue[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    QueueThread queueThread = this.threads[this.threads.length - 1 - n3];
                    blockingQueueArray[n3] = queueThread.stopRunImmediately();
                }
                this.threads = queueThreadArray2;
                for (n3 = 0; n3 < blockingQueueArray.length; ++n3) {
                    int n4 = blockingQueueArray[n3].size();
                    for (int i = 0; i < n4; ++i) {
                        this.add(blockingQueueArray[n3].pop());
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getThreadPoolSize() {
        QueueThread[] queueThreadArray = this.threads;
        synchronized (this.threads) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.threads.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueueThread chooseThread() {
        QueueThread[] queueThreadArray = this.threads;
        synchronized (this.threads) {
            if (this.threads.length > 0) {
                this.pos = (this.pos + 1) % this.threads.length;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.threads[this.pos];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public void add(Object object) {
        QueueThread queueThread = this.chooseThread();
        if (queueThread != null) {
            queueThread.add(object);
        } else {
            this.action(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        QueueThread[] queueThreadArray = this.threads;
        synchronized (this.threads) {
            for (int i = 0; i < this.threads.length; ++i) {
                this.threads[i].clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        int n = 0;
        QueueThread[] queueThreadArray = this.threads;
        synchronized (this.threads) {
            for (int i = 0; i < this.threads.length; ++i) {
                n += this.threads[i].size();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    protected QueueThread newQueueThread() {
        return new QueueThread(){

            protected void action(Object object) {
                DefaultQueueThreadPool.this.action(object);
            }
        };
    }

    protected abstract void action(Object var1);
}

