/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.DirInfo;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.snaccmd.icbm.OldIconHashInfo;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.BuddyInfoChangeListener;
import net.kano.joustsim.trust.BuddyCertificateInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuddyInfo {
    public static final String PROP_CERTIFICATE_INFO = "certificateInfo";
    public static final String PROP_ONLINE = "online";
    public static final String PROP_DIRECTORY_INFO = "dirInfo";
    public static final String PROP_ONLINE_SINCE = "onlineSince";
    public static final String PROP_AWAY = "away";
    public static final String PROP_CAPABILITIES = "capabilities";
    public static final String PROP_IDLE_SINCE = "idleSince";
    public static final String PROP_WARNING_LEVEL = "warningLevel";
    public static final String PROP_AWAY_MESSAGE = "awayMessage";
    public static final String PROP_STATUS_MESSAGE = "statusMessage";
    public static final String PROP_USER_PROFILE = "userProfile";
    public static final String PROP_OLD_ICON_INFO = "oldIconInfo";
    public static final String PROP_LAST_AIM_EXPRESSION = "lastAimExpression";
    public static final String PROP_SUPPORTS_TYPING_NOTIFICATIONS = "supportsTypingNotifications";
    public static final String PROP_WANTS_OUR_ICON = "wantsOurIcon";
    public static final String PROP_ICON_HASH = "iconHash";
    public static final String PROP_ICON_DATA = "iconData";
    public static final String PROP_MOBILE = "mobile";
    public static final String PROP_ROBOT = "robot";
    public static final String PROP_AOL_USER = "aolUser";
    public static final String PROP_ITUNES_URL = "itunesUrl";
    private static final String PROP_ON_BUDDY_LIST = "onBuddyList";
    private static final String PROP_LAST_UPDATED = "lastUpdated";
    private final Screenname screenname;
    private BuddyCertificateInfo certificateInfo = null;
    private boolean online = false;
    private boolean onBuddyList = false;
    private Date lastUpdated = null;
    private DirInfo directoryInfo = null;
    private Date onlineSince = null;
    private boolean away = false;
    private List<CapabilityBlock> capabilities = DefensiveTools.emptyList();
    private Date idleSince = null;
    private int warningLevel = -1;
    private String awayMessage = null;
    private String userProfile = null;
    private String statusMessage = null;
    private String itunesUrl = null;
    private ExtraInfoData iconHash = null;
    private ByteBlock iconData = null;
    private boolean mobile = false;
    private boolean robot = false;
    private boolean aolUser = false;
    private OldIconHashInfo oldIconInfo = null;
    private String lastAimExpression = null;
    private boolean supportsTypingNotifications = false;
    private boolean wantsOurIcon = false;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private CopyOnWriteArrayList<BuddyInfoChangeListener> listeners = new CopyOnWriteArrayList();

    public BuddyInfo(Screenname screenname) {
        DefensiveTools.checkNull((Object)screenname, (String)"screenname");
        this.screenname = screenname;
        this.listeners.add((Object)new BuddyInfoChangeListener(){

            public void receivedBuddyStatusUpdate(BuddyInfo info) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (!evt.getPropertyName().equals(BuddyInfo.PROP_LAST_UPDATED)) {
                    BuddyInfo.this.setLastUpdated(new Date());
                }
            }
        });
    }

    public void addPropertyListener(BuddyInfoChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
        this.listeners.add((Object)l);
    }

    public void removePropertyListener(BuddyInfoChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
        this.listeners.remove((Object)l);
    }

    @NotNull
    public Screenname getScreenname() {
        return this.screenname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCertificateInfo(BuddyCertificateInfo certificateInfo) {
        BuddyCertificateInfo old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.certificateInfo;
            this.certificateInfo = certificateInfo;
        }
        this.fireObjectChange(PROP_CERTIFICATE_INFO, old, certificateInfo);
    }

    @Nullable
    public synchronized BuddyCertificateInfo getCertificateInfo() {
        return this.certificateInfo;
    }

    private void clearOnlineInfo() {
        this.onlineSince = null;
        this.idleSince = null;
        this.statusMessage = null;
        this.itunesUrl = null;
        this.awayMessage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOnline(boolean online) {
        boolean old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.online;
            this.online = online;
        }
        this.pcs.firePropertyChange(PROP_ONLINE, old, online);
        if (!online) {
            this.clearOnlineInfo();
        }
    }

    public synchronized boolean isOnline() {
        return this.online;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOnBuddyList(boolean onBuddyList) {
        boolean old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.onBuddyList;
            this.onBuddyList = onBuddyList;
        }
        this.pcs.firePropertyChange(PROP_ON_BUDDY_LIST, old, onBuddyList);
    }

    public synchronized boolean isOnBuddyList() {
        return this.onBuddyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastUpdated(@Nullable Date lastUpdated) {
        Date old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.lastUpdated;
            this.lastUpdated = lastUpdated;
        }
        this.fireObjectChange(PROP_LAST_UPDATED, old, lastUpdated);
    }

    @Nullable
    public synchronized Date getLastUpdated() {
        return this.lastUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDirectoryInfo(DirInfo directoryInfo) {
        DirInfo old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.directoryInfo;
            this.directoryInfo = directoryInfo;
        }
        this.fireObjectChange(PROP_DIRECTORY_INFO, old, directoryInfo);
    }

    @Nullable
    public synchronized DirInfo getDirectoryInfo() {
        return this.directoryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOnlineSince(Date onlineSince) {
        Date old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.onlineSince;
            this.onlineSince = onlineSince;
        }
        this.fireObjectChange(PROP_ONLINE_SINCE, old, onlineSince);
    }

    @Nullable
    public synchronized Date getOnlineSince() {
        return this.onlineSince;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAway(boolean away) {
        boolean old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.away;
            this.away = away;
        }
        this.pcs.firePropertyChange(PROP_AWAY, old, away);
    }

    public synchronized boolean isAway() {
        return this.away;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCapabilities(Collection<CapabilityBlock> capabilities) {
        List<CapabilityBlock> old;
        List cloned = DefensiveTools.getSafeNonnullListCopy(capabilities, (String)PROP_CAPABILITIES);
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.capabilities;
            this.capabilities = cloned;
        }
        this.pcs.firePropertyChange(PROP_CAPABILITIES, old, capabilities);
    }

    @NotNull
    public synchronized List<CapabilityBlock> getCapabilities() {
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIdleSince(Date idleSince) {
        Date old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.idleSince;
            this.idleSince = idleSince;
        }
        this.fireObjectChange(PROP_IDLE_SINCE, old, idleSince);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIconHash(ExtraInfoData iconHash) {
        ExtraInfoData old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.iconHash;
            this.iconHash = iconHash;
        }
        this.fireObjectChange(PROP_ICON_HASH, old, iconHash);
    }

    @Nullable
    public synchronized ExtraInfoData getIconHash() {
        return this.iconHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIconData(ByteBlock iconData) {
        ByteBlock old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.iconData;
            this.iconData = iconData;
        }
        this.fireObjectChange(PROP_ICON_DATA, old, iconData);
    }

    @Nullable
    public synchronized ByteBlock getIconData() {
        return this.iconData;
    }

    public synchronized Date getIdleSince() {
        return this.idleSince;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWarningLevel(int warningLevel) {
        int old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.warningLevel;
            this.warningLevel = warningLevel;
        }
        this.pcs.firePropertyChange(PROP_WARNING_LEVEL, old, warningLevel);
    }

    public synchronized int getWarningLevel() {
        return this.warningLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAwayMessage(String awayMessage) {
        String old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.awayMessage;
            this.awayMessage = awayMessage;
        }
        this.fireObjectChange(PROP_AWAY_MESSAGE, old, awayMessage);
    }

    @Nullable
    public synchronized String getAwayMessage() {
        return this.awayMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatusMessage(String statusMessage) {
        String old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.statusMessage;
            this.statusMessage = statusMessage;
        }
        this.fireObjectChange(PROP_STATUS_MESSAGE, old, statusMessage);
    }

    @Nullable
    public synchronized String getStatusMessage() {
        return this.statusMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setItunesUrl(String itunesUrl) {
        String old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.itunesUrl;
            this.itunesUrl = itunesUrl;
        }
        this.fireObjectChange(PROP_ITUNES_URL, old, itunesUrl);
    }

    @Nullable
    public synchronized String getItunesUrl() {
        return this.itunesUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUserProfile(String userProfile) {
        String old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.userProfile;
            this.userProfile = userProfile;
        }
        this.fireObjectChange(PROP_USER_PROFILE, old, userProfile);
    }

    @Nullable
    public synchronized String getUserProfile() {
        return this.userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOldIconInfo(OldIconHashInfo oldIconInfo) {
        OldIconHashInfo old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.oldIconInfo;
            this.oldIconInfo = oldIconInfo;
        }
        this.fireObjectChange(PROP_OLD_ICON_INFO, old, oldIconInfo);
    }

    @Nullable
    public synchronized OldIconHashInfo getOldIconInfo() {
        return this.oldIconInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastAimExpression(String lastAimExpression) {
        String old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.lastAimExpression;
            this.lastAimExpression = lastAimExpression;
        }
        this.fireObjectChange(PROP_LAST_AIM_EXPRESSION, old, lastAimExpression);
    }

    @Nullable
    public synchronized String getLastAimExpression() {
        return this.lastAimExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSupportsTypingNotifications(boolean supportsTypingNotifications) {
        boolean old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.supportsTypingNotifications;
            this.supportsTypingNotifications = supportsTypingNotifications;
        }
        this.pcs.firePropertyChange(PROP_SUPPORTS_TYPING_NOTIFICATIONS, old, supportsTypingNotifications);
    }

    public synchronized boolean supportsTypingNotifications() {
        return this.supportsTypingNotifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWantsOurIcon(boolean wantsOurIcon) {
        boolean old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.wantsOurIcon;
            this.wantsOurIcon = wantsOurIcon;
        }
        this.pcs.firePropertyChange(PROP_WANTS_OUR_ICON, old, wantsOurIcon);
    }

    public synchronized boolean wantsOurIcon() {
        return this.wantsOurIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMobile(boolean mobile) {
        boolean old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.mobile;
            this.mobile = mobile;
        }
        this.pcs.firePropertyChange(PROP_MOBILE, old, mobile);
    }

    public synchronized boolean isMobile() {
        return this.mobile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRobot(boolean robot) {
        boolean old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.robot;
            this.robot = robot;
        }
        this.pcs.firePropertyChange(PROP_ROBOT, old, robot);
    }

    public synchronized boolean isRobot() {
        return this.robot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAolUser(boolean aolUser) {
        boolean old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            old = this.aolUser;
            this.aolUser = aolUser;
        }
        this.pcs.firePropertyChange(PROP_AOL_USER, old, aolUser);
    }

    public synchronized boolean isAolUser() {
        return this.aolUser;
    }

    void receivedBuddyStatusUpdate() {
        assert (!Thread.holdsLock(this));
        for (BuddyInfoChangeListener listener : this.listeners) {
            listener.receivedBuddyStatusUpdate(this);
        }
    }

    public synchronized boolean isCertificateInfoCurrent() {
        BuddyCertificateInfo certInfo = this.certificateInfo;
        return certInfo == null || certInfo.isUpToDate();
    }

    private void fireObjectChange(String property, Object oldval, Object newval) {
        if (oldval != newval) {
            this.pcs.firePropertyChange(property, oldval, newval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setIconDataIfHashMatches(ExtraInfoData hash, ByteBlock iconData) {
        ByteBlock old;
        BuddyInfo buddyInfo = this;
        synchronized (buddyInfo) {
            ExtraInfoData curHash = this.getIconHash();
            if (!(curHash != null ? curHash.equals((Object)hash) : hash == null)) {
                return false;
            }
            old = this.iconData;
            this.iconData = iconData;
        }
        this.pcs.firePropertyChange(PROP_ICON_DATA, old, iconData);
        return true;
    }
}

