/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.examples.interpreter;

import org.xml.sax.SAXException;
import weblogic.xml.babel.examples.interpreter.BooleanExp;
import weblogic.xml.babel.examples.interpreter.Context;
import weblogic.xml.babel.examples.interpreter.ExpressionFactory;
import weblogicx.xml.stream.StartElementEvent;
import weblogicx.xml.stream.XMLEventStream;

class OrExp
extends BooleanExp {
    private BooleanExp op1;
    private BooleanExp op2;

    public OrExp() {
    }

    public OrExp(BooleanExp booleanExp, BooleanExp booleanExp2) {
        this.op1 = booleanExp;
        this.op2 = booleanExp2;
    }

    public boolean evaluate(Context context) {
        return this.op1.evaluate(context) || this.op2.evaluate(context);
    }

    public BooleanExp copy() {
        return new OrExp(this.op1.copy(), this.op2.copy());
    }

    public BooleanExp replace(String string, BooleanExp booleanExp) {
        return new OrExp(this.op1.replace(string, booleanExp), this.op2.replace(string, booleanExp));
    }

    public void read(XMLEventStream xMLEventStream) throws SAXException {
        xMLEventStream.startElement("operator");
        StartElementEvent startElementEvent = xMLEventStream.getSubStream().startElement();
        this.op1 = ExpressionFactory.createExpression(startElementEvent);
        this.op1.read(xMLEventStream);
        startElementEvent = xMLEventStream.getSubStream().startElement();
        this.op2 = ExpressionFactory.createExpression(startElementEvent);
        this.op2.read(xMLEventStream);
    }

    public String toString() {
        return "OR (" + this.op1 + "," + this.op2 + ")";
    }
}

