/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.hsqldb.persist.LockFile;

final class NIOLockFile
extends LockFile {
    static final long MAX_NFS_LOCK_REGION = 0x40000000L;
    static final long MIN_LOCK_REGION = MAGIC.length + 8;
    private FileChannel fc;
    private FileLock fl;

    NIOLockFile() {
    }

    protected boolean lockImpl() throws Exception {
        if (this.fl != null && this.fl.isValid()) {
            return true;
        }
        this.trace("lockImpl(): fc = raf.getChannel()");
        this.fc = this.raf.getChannel();
        this.trace("lockImpl(): fl = fc.tryLock()");
        this.fl = null;
        try {
            this.fl = this.fc.tryLock(0L, MIN_LOCK_REGION, false);
            this.trace("lockImpl(): fl = " + this.fl);
        }
        catch (Exception exception) {
            this.trace(exception.toString());
        }
        this.trace("lockImpl(): f.deleteOnExit()");
        this.f.deleteOnExit();
        boolean bl = this.fl != null && this.fl.isValid();
        this.trace("lockImpl():isValid(): " + bl);
        return bl;
    }

    protected boolean releaseImpl() throws Exception {
        this.trace("releaseImpl(): fl = " + this.fl);
        if (this.fl != null) {
            this.trace("releaseImpl(): fl.release()");
            this.fl.release();
            this.trace("tryRelease(): fl = " + this.fl);
            this.fl = null;
        }
        this.trace("releaseImpl(): fc = " + this.fc);
        if (this.fc != null) {
            this.trace("releaseImpl(): fc.close()");
            this.fc.close();
            this.fc = null;
        }
        return true;
    }

    public boolean isValid() {
        return super.isValid() && this.fl != null && this.fl.isValid();
    }

    protected String toStringImpl() {
        return "fl =" + this.fl;
    }
}

