/*
 * Decompiled with CFR 0.152.
 */
package org.schwering.irc.lib.ssl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.schwering.irc.lib.ssl.SSLIRCConnection;
import org.schwering.irc.lib.ssl.SSLNotSupportedException;
import org.schwering.irc.lib.ssl.SSLTrustManager;
import org.schwering.irc.lib.ssl.TrustManagerJava14Wrapper;
import org.schwering.irc.lib.ssl.TrustManagerJsseWrapper;

class SSLSocketFactoryFactory {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private SSLSocketFactoryFactory() {
    }

    public static SSLSocketFactory createSSLSocketFactory(SSLTrustManager[] tm) throws SSLException, SSLNotSupportedException {
        boolean sslNotSupported = false;
        Exception exception = null;
        try {
            return SSLSocketFactoryFactory.createJava14SSLSocketFactory(tm);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (Exception exception2) {
            // empty catch block
        }
        try {
            return SSLSocketFactoryFactory.createJsseSSLSocketFactory(tm);
        }
        catch (ClassNotFoundException cnfe) {
            exception = cnfe;
            sslNotSupported = true;
        }
        catch (NoSuchMethodException nsme) {
            exception = nsme;
            sslNotSupported = true;
        }
        catch (InstantiationException ie) {
            exception = ie;
            sslNotSupported = true;
        }
        catch (InvocationTargetException ite) {
            exception = ite;
            sslNotSupported = true;
        }
        catch (IllegalAccessException eae) {
            exception = eae;
            sslNotSupported = true;
        }
        catch (Exception exc) {
            exception = exc;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        pw.close();
        if (sslNotSupported) {
            throw new SSLNotSupportedException("Neither JSSE nor J2SE >= 1.4 installed:\n---\n" + sw.toString() + "---");
        }
        throw new SSLException("Exception while creating the SSLSocketFactory with JSSE:\n---\n" + sw.toString() + "---");
    }

    private static SSLSocketFactory createJava14SSLSocketFactory(SSLTrustManager[] tm) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> stringClass = clazz;
        Class<?> contextClass = Class.forName("javax.net.ssl.SSLContext");
        Class<?> keyManagerClass = Class.forName("javax.net.ssl.KeyManager");
        Class<?> keyManagerArrayClass = Array.newInstance(keyManagerClass, 0).getClass();
        Class<?> trustManagerClass = Class.forName("javax.net.ssl.TrustManager");
        Class<?> trustManagerArrayClass = Array.newInstance(trustManagerClass, 0).getClass();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.security.SecureRandom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> secureRandomClass = clazz2;
        Method getInstanceMethod = contextClass.getMethod("getInstance", stringClass);
        Method initMethod = contextClass.getMethod("init", keyManagerArrayClass, trustManagerArrayClass, secureRandomClass);
        Method getSocketFactoryMethod = contextClass.getMethod("getSocketFactory", null);
        Class.forName("javax.net.ssl.X509TrustManager");
        TrustManagerJava14Wrapper[] tmWrappers = TrustManagerJava14Wrapper.wrap(tm);
        String protocol = SSLIRCConnection.protocol;
        Object context = getInstanceMethod.invoke(null, protocol);
        Object[] objectArray = new Object[3];
        objectArray[1] = tmWrappers;
        initMethod.invoke(context, objectArray);
        Object socketFactory = getSocketFactoryMethod.invoke(context, null);
        return (SSLSocketFactory)socketFactory;
    }

    private static SSLSocketFactory createJsseSSLSocketFactory(SSLTrustManager[] tm) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        Class<?> securityClass = Class.forName("java.security.Security");
        Class<?> providerClass = Class.forName("java.security.Provider");
        Class<?> sslProviderClass = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
        Method addProvider = securityClass.getMethod("addProvider", providerClass);
        Object provider = sslProviderClass.newInstance();
        addProvider.invoke(null, provider);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> stringClass = clazz;
        Class<?> contextClass = Class.forName("com.sun.net.ssl.SSLContext");
        Class<?> keyManagerClass = Class.forName("com.sun.net.ssl.KeyManager");
        Class<?> keyManagerArrayClass = Array.newInstance(keyManagerClass, 0).getClass();
        Class<?> trustManagerClass = Class.forName("com.sun.net.ssl.TrustManager");
        Class<?> trustManagerArrayClass = Array.newInstance(trustManagerClass, 0).getClass();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.security.SecureRandom");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> secureRandomClass = clazz2;
        Method getInstanceMethod = contextClass.getMethod("getInstance", stringClass);
        Method initMethod = contextClass.getMethod("init", keyManagerArrayClass, trustManagerArrayClass, secureRandomClass);
        Method getSocketFactoryMethod = contextClass.getMethod("getSocketFactory", null);
        Class.forName("com.sun.net.ssl.X509TrustManager");
        TrustManagerJsseWrapper[] tmWrappers = TrustManagerJsseWrapper.wrap(tm);
        String protocol = SSLIRCConnection.protocol;
        Object context = getInstanceMethod.invoke(null, protocol);
        Object[] objectArray = new Object[3];
        objectArray[1] = tmWrappers;
        initMethod.invoke(context, objectArray);
        Object socketFactory = getSocketFactoryMethod.invoke(context, null);
        return (SSLSocketFactory)socketFactory;
    }
}

