/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.Expires;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import java.io.IOException;
import java.text.ParseException;
import java.util.EventObject;
import java.util.TimerTask;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.address.Hop;
import javax.sip.header.Header;
import javax.sip.message.Response;

public class SIPServerTransaction
extends SIPTransaction
implements ServerRequestInterface,
ServerTransaction {
    private int rseqNumber;
    private ServerRequestInterface requestOf;
    private SIPDialog dialog;
    private SIPResponse pendingReliableResponse;
    private ProvisionalResponseTask provisionalResponseTask;
    private boolean retransmissionAlertEnabled;
    private RetransmissionAlertTimerTask retransmissionAlertTimerTask;
    protected boolean isAckSeen;
    private SIPClientTransaction pendingSubscribeTransaction;
    private SIPServerTransaction inviteTransaction;

    private void sendResponse(SIPResponse sIPResponse) throws IOException {
        if (this.isReliable()) {
            this.getMessageChannel().sendMessage(sIPResponse);
        } else {
            Via via = sIPResponse.getTopmostVia();
            String string = via.getTransport();
            if (string == null) {
                throw new IOException("missing transport!");
            }
            int n = via.getRPort();
            if (n == -1) {
                n = via.getPort();
            }
            if (n == -1) {
                n = string.equalsIgnoreCase("TLS") ? 5061 : 5060;
            }
            String string2 = null;
            if (via.getMAddr() != null) {
                string2 = via.getMAddr();
            } else {
                string2 = via.getParameter("received");
                if (string2 == null) {
                    string2 = via.getHost();
                }
            }
            Hop hop = this.sipStack.addressResolver.resolveAddress(new HopImpl(string2, n, string));
            MessageChannel messageChannel = this.getSIPStack().createRawMessageChannel(this.getPort(), hop);
            if (messageChannel != null) {
                messageChannel.sendMessage(sIPResponse);
            } else {
                throw new IOException("Could not create a message channel for " + hop);
            }
        }
    }

    protected SIPServerTransaction(SIPTransactionStack sIPTransactionStack, MessageChannel messageChannel) {
        super(sIPTransactionStack, messageChannel);
        if (sIPTransactionStack.maxListenerResponseTime != -1) {
            sIPTransactionStack.timer.schedule((TimerTask)new ListenerExecutionMaxTimer(), sIPTransactionStack.maxListenerResponseTime * 1000);
        }
        this.rseqNumber = (int)(Math.random() * 1000.0);
        if (sIPTransactionStack.isLoggingEnabled()) {
            sIPTransactionStack.logWriter.logDebug("Creating Server Transaction" + this.getBranchId());
            sIPTransactionStack.logWriter.logStackTrace();
        }
    }

    public void setRequestInterface(ServerRequestInterface serverRequestInterface) {
        this.requestOf = serverRequestInterface;
    }

    public MessageChannel getResponseChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage sIPMessage) {
        ViaList viaList;
        boolean bl = false;
        String string = sIPMessage.getCSeq().getMethod();
        if ((string.equals("INVITE") || !this.isTerminated()) && (viaList = sIPMessage.getViaHeaders()) != null) {
            Via via = (Via)viaList.getFirst();
            String string2 = via.getBranch();
            if (string2 != null && !string2.toLowerCase().startsWith("z9hg4bk")) {
                string2 = null;
            }
            if (string2 != null && this.getBranch() != null) {
                bl = string.equals("CANCEL") ? this.getMethod().equals("CANCEL") && this.getBranch().equalsIgnoreCase(string2) && via.getSentBy().equals(((Via)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy()) : this.getBranch().equalsIgnoreCase(string2) && via.getSentBy().equals(((Via)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy());
            } else {
                String string3 = this.fromTag;
                String string4 = sIPMessage.getFrom().getTag();
                boolean bl2 = string3 == null || string4 == null;
                String string5 = this.toTag;
                String string6 = sIPMessage.getTo().getTag();
                boolean bl3 = string5 == null || string6 == null;
                boolean bl4 = sIPMessage instanceof SIPResponse;
                if ((bl4 || this.getOriginalRequest().getRequestURI().equals(((SIPRequest)sIPMessage).getRequestURI())) && (bl2 || string3.equalsIgnoreCase(string4)) && (bl3 || string5.equalsIgnoreCase(string6)) && this.getOriginalRequest().getCallId().getCallId().equalsIgnoreCase(sIPMessage.getCallId().getCallId()) && this.getOriginalRequest().getCSeq().getSeqNumber() == sIPMessage.getCSeq().getSeqNumber() && (!sIPMessage.getCSeq().getMethod().equals("CANCEL") || this.getOriginalRequest().getMethod().equals(sIPMessage.getCSeq().getMethod())) && via.equals(this.getOriginalRequest().getViaHeaders().getFirst())) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    protected void map() {
        if (this.getRealState() == null || this.getRealState() == TransactionState.TRYING) {
            if (this.isInviteTransaction() && !this.isMapped && this.sipStack.timer != null) {
                this.isMapped = true;
                this.sipStack.timer.schedule((TimerTask)new SendTrying(), 200L);
            } else {
                this.isMapped = true;
            }
        }
        this.sipStack.removePendingTransaction(this);
    }

    public boolean isTransactionMapped() {
        return this.isMapped;
    }

    public void processRequest(SIPRequest sIPRequest, MessageChannel messageChannel) {
        block35: {
            boolean bl = false;
            if (this.sipStack.logWriter.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("processRequest: " + sIPRequest.getFirstLine());
                this.sipStack.logWriter.logDebug("tx state = " + this.getRealState());
            }
            try {
                if (this.getRealState() == null) {
                    this.setOriginalRequest(sIPRequest);
                    this.setState(TransactionState.TRYING);
                    bl = true;
                    this.setPassToListener();
                    if (this.isInviteTransaction() && this.isMapped) {
                        this.sendMessage(sIPRequest.createResponse(100, "Trying"));
                    }
                } else {
                    if (this.isInviteTransaction() && TransactionState.COMPLETED == this.getRealState() && sIPRequest.getMethod().equals("ACK")) {
                        this.setState(TransactionState.CONFIRMED);
                        this.disableRetransmissionTimer();
                        if (!this.isReliable()) {
                            this.enableTimeoutTimer(10);
                        } else {
                            this.setState(TransactionState.TERMINATED);
                        }
                        if (this.sipStack.isNon2XXAckPassedToListener()) {
                            this.requestOf.processRequest(sIPRequest, this);
                        } else {
                            if (this.sipStack.logWriter.isLoggingEnabled()) {
                                this.sipStack.logWriter.logDebug("ACK received for server Tx " + this.getTransactionId() + " not delivering to application!");
                            }
                            this.semaphore.release();
                        }
                        return;
                    }
                    if (sIPRequest.getMethod().equals(this.getOriginalRequest().getMethod())) {
                        if (TransactionState.PROCEEDING == this.getRealState() || TransactionState.COMPLETED == this.getRealState()) {
                            this.semaphore.release();
                            if (this.lastResponse != null) {
                                super.sendMessage(this.lastResponse);
                            }
                        } else if (sIPRequest.getMethod().equals("ACK")) {
                            if (this.requestOf != null) {
                                this.requestOf.processRequest(sIPRequest, this);
                            } else {
                                this.semaphore.release();
                            }
                        }
                        this.sipStack.logWriter.logDebug("completed processing retransmitted request : " + sIPRequest.getFirstLine() + this + " txState = " + this.getState() + " lastResponse = " + this.getLastResponse());
                        return;
                    }
                }
                if (TransactionState.COMPLETED != this.getRealState() && TransactionState.TERMINATED != this.getRealState() && this.requestOf != null) {
                    if (this.getOriginalRequest().getMethod().equals(sIPRequest.getMethod())) {
                        if (bl) {
                            this.requestOf.processRequest(sIPRequest, this);
                        } else {
                            this.semaphore.release();
                        }
                    } else if (this.requestOf != null) {
                        this.requestOf.processRequest(sIPRequest, this);
                    } else {
                        this.semaphore.release();
                    }
                    break block35;
                }
                if (this.getSIPStack().isDialogCreated(this.getOriginalRequest().getMethod()) && this.getRealState() == TransactionState.TERMINATED && sIPRequest.getMethod().equals("ACK") && this.requestOf != null) {
                    SIPDialog sIPDialog = this.dialog;
                    if (sIPDialog == null || !sIPDialog.ackProcessed) {
                        if (sIPDialog != null) {
                            sIPDialog.ackReceived(sIPRequest);
                            sIPDialog.ackProcessed = true;
                        }
                        this.requestOf.processRequest(sIPRequest, this);
                    } else {
                        this.semaphore.release();
                    }
                } else if (sIPRequest.getMethod().equals("CANCEL")) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.logWriter.logDebug("Too late to cancel Transaction");
                    }
                    this.semaphore.release();
                    try {
                        this.sendMessage(sIPRequest.createResponse(200));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.sipStack.logWriter.logDebug("Dropping request " + this.getRealState());
            }
            catch (IOException iOException) {
                this.semaphore.release();
                this.raiseIOExceptionEvent();
            }
        }
    }

    public void sendMessage(SIPMessage sIPMessage) throws IOException {
        SIPResponse sIPResponse = (SIPResponse)sIPMessage;
        int n = sIPResponse.getStatusCode();
        try {
            if (this.getOriginalRequest().getTopmostVia().getBranch() != null) {
                sIPResponse.getTopmostVia().setBranch(this.getBranch());
            } else {
                sIPResponse.getTopmostVia().removeParameter("branch");
            }
            if (!this.getOriginalRequest().getTopmostVia().hasPort()) {
                sIPResponse.getTopmostVia().removePort();
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        if (!sIPResponse.getCSeq().getMethod().equals(this.getOriginalRequest().getMethod())) {
            this.sendResponse(sIPResponse);
            return;
        }
        if (this.getRealState() == TransactionState.TRYING) {
            if (n / 100 == 1) {
                this.setState(TransactionState.PROCEEDING);
            } else if (200 <= n && n <= 699) {
                if (!this.isInviteTransaction()) {
                    if (!this.isReliable()) {
                        this.setState(TransactionState.COMPLETED);
                        this.enableTimeoutTimer(64);
                    } else {
                        this.setState(TransactionState.TERMINATED);
                    }
                } else if (n / 100 == 2) {
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                    this.collectionTime = 64;
                    this.setState(TransactionState.TERMINATED);
                    if (this.dialog != null) {
                        this.dialog.setRetransmissionTicks();
                    }
                } else {
                    this.setState(TransactionState.COMPLETED);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.enableTimeoutTimer(64);
                }
            }
        } else if (this.getRealState() == TransactionState.PROCEEDING) {
            if (this.isInviteTransaction()) {
                if (n / 100 == 2) {
                    this.disableRetransmissionTimer();
                    this.disableTimeoutTimer();
                    this.collectionTime = 64;
                    this.setState(TransactionState.TERMINATED);
                    if (this.dialog != null) {
                        this.dialog.setRetransmissionTicks();
                    }
                } else if (300 <= n && n <= 699) {
                    this.setState(TransactionState.COMPLETED);
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    this.enableTimeoutTimer(64);
                }
            } else if (200 <= n && n <= 699) {
                this.setState(TransactionState.COMPLETED);
                if (!this.isReliable()) {
                    this.disableRetransmissionTimer();
                    this.enableTimeoutTimer(64);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.COMPLETED == this.getRealState()) {
            return;
        }
        try {
            if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("sendMessage : tx = " + this + " getState = " + this.getState());
            }
            this.lastResponse = sIPResponse;
            this.sendResponse(sIPResponse);
        }
        catch (IOException iOException) {
            this.setState(TransactionState.TERMINATED);
            this.collectionTime = 0;
            throw iOException;
        }
    }

    public String getViaHost() {
        return this.getMessageChannel().getViaHost();
    }

    public int getViaPort() {
        return this.getMessageChannel().getViaPort();
    }

    protected void fireRetransmissionTimer() {
        try {
            if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("fireRetransmissionTimer() -- ");
            }
            if (this.isInviteTransaction() && this.lastResponse != null) {
                if (!this.retransmissionAlertEnabled) {
                    if (this.lastResponse.getStatusCode() / 100 > 2) {
                        super.sendMessage(this.lastResponse);
                    }
                } else {
                    SipProviderImpl sipProviderImpl = this.getSipProvider();
                    TimeoutEvent timeoutEvent = new TimeoutEvent((Object)sipProviderImpl, (ServerTransaction)this, Timeout.RETRANSMIT);
                    sipProviderImpl.handleEvent((EventObject)timeoutEvent, this);
                }
            }
        }
        catch (IOException iOException) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logException(iOException);
            }
            this.raiseErrorEvent(2);
        }
    }

    private void fireReliableResponseRetransmissionTimer() {
        try {
            super.sendMessage(this.pendingReliableResponse);
        }
        catch (IOException iOException) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logException(iOException);
            }
            this.setState(TransactionState.TERMINATED);
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("SIPServerTransaction.fireTimeoutTimer this = " + this + " current state = " + this.getRealState() + " method = " + this.getOriginalRequest().getMethod());
        }
        SIPDialog sIPDialog = this.dialog;
        if (this.getSIPStack().isDialogCreated(this.getOriginalRequest().getMethod()) && (TransactionState.CALLING == this.getRealState() || TransactionState.TRYING == this.getRealState())) {
            sIPDialog.setState(3);
        } else if (this.getOriginalRequest().getMethod().equals("BYE") && sIPDialog != null && sIPDialog.isTerminatedOnBye()) {
            sIPDialog.setState(3);
        }
        if (TransactionState.COMPLETED == this.getRealState() && this.isInviteTransaction()) {
            this.raiseErrorEvent(1);
            this.setState(TransactionState.TERMINATED);
            this.sipStack.removeTransaction(this);
        } else if (TransactionState.COMPLETED == this.getRealState() && !this.isInviteTransaction()) {
            this.setState(TransactionState.TERMINATED);
            this.sipStack.removeTransaction(this);
        } else if (TransactionState.CONFIRMED == this.getRealState() && this.isInviteTransaction()) {
            this.setState(TransactionState.TERMINATED);
            this.sipStack.removeTransaction(this);
        } else if (!(this.isInviteTransaction() || TransactionState.COMPLETED != this.getRealState() && TransactionState.CONFIRMED != this.getRealState())) {
            this.setState(TransactionState.TERMINATED);
        } else if (this.isInviteTransaction() && TransactionState.TERMINATED == this.getRealState()) {
            this.raiseErrorEvent(1);
            if (sIPDialog != null) {
                sIPDialog.setState(3);
            }
        }
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    public void setOriginalRequest(SIPRequest sIPRequest) {
        super.setOriginalRequest(sIPRequest);
    }

    public void sendResponse(Response response) throws SipException {
        Object object;
        Object object2;
        SIPResponse sIPResponse = (SIPResponse)response;
        SIPDialog sIPDialog = this.dialog;
        if (response == null) {
            throw new NullPointerException("null response");
        }
        try {
            sIPResponse.checkHeaders();
        }
        catch (ParseException parseException) {
            throw new SipException(parseException.getMessage());
        }
        if (!sIPResponse.getCSeq().getMethod().equals(this.getMethod())) {
            throw new SipException("CSeq method does not match Request method of request that created the tx.");
        }
        if (this.getMethod().equals("SUBSCRIBE") && response.getStatusCode() / 100 == 2) {
            if (response.getHeader("Expires") == null) {
                throw new SipException("Expires header is mandatory in 2xx response of SUBSCRIBE");
            }
            object2 = (Expires)this.getOriginalRequest().getExpires();
            object = (Expires)response.getExpires();
            if (object2 != null && ((Expires)object).getExpires() > ((Expires)object2).getExpires()) {
                throw new SipException("Response Expires time exceeds request Expires time : See RFC 3265 3.1.1");
            }
        }
        if (sIPResponse.getStatusCode() == 200 && sIPResponse.getCSeq().getMethod().equals("INVITE") && sIPResponse.getHeader("Contact") == null) {
            throw new SipException("Contact Header is mandatory for the OK to the INVITE");
        }
        if (!this.isMessagePartOfTransaction((SIPMessage)response)) {
            throw new SipException("Response does not belong to this transaction.");
        }
        try {
            if (this.pendingReliableResponse != null && response.getStatusCode() / 100 == 2 && this.pendingReliableResponse.getContentTypeHeader().getContentType().equalsIgnoreCase("application") && this.pendingReliableResponse.getContentTypeHeader().getContentSubType().equalsIgnoreCase("sdp")) {
                throw new SipException("cannot send response -- unacked povisional");
            }
            if (this.pendingReliableResponse != null && sIPResponse.isFinalResponse()) {
                this.provisionalResponseTask.cancel();
                this.provisionalResponseTask = null;
            }
            if (sIPDialog != null) {
                if (sIPResponse.getStatusCode() / 100 == 2 && this.sipStack.isDialogCreated(sIPResponse.getCSeq().getMethod())) {
                    if (sIPDialog.getLocalTag() == null && sIPResponse.getTo().getTag() == null) {
                        sIPResponse.getTo().setTag(Utils.generateTag());
                    } else if (sIPDialog.getLocalTag() != null && sIPResponse.getToTag() == null) {
                        sIPResponse.setToTag(sIPDialog.getLocalTag());
                    } else if (sIPDialog.getLocalTag() != null && sIPResponse.getToTag() != null && !sIPDialog.getLocalTag().equals(sIPResponse.getToTag())) {
                        throw new SipException("Tag mismatch dialogTag is " + sIPDialog.getLocalTag() + " responseTag is " + sIPResponse.getToTag());
                    }
                }
                if (!sIPResponse.getCallId().getCallId().equals(sIPDialog.getCallId().getCallId())) {
                    throw new SipException("Dialog mismatch!");
                }
            }
            if (sIPDialog != null && sIPDialog.getLocalTag() != null && sIPResponse.getTo().getTag() == null && sIPResponse.getStatusCode() != 100) {
                sIPResponse.getTo().setTag(sIPDialog.getLocalTag());
            }
            if ((object2 = ((SIPRequest)this.getRequest()).getFrom().getTag()) != null && sIPResponse.getFromTag() != null && !sIPResponse.getFromTag().equals(object2)) {
                throw new SipException("From tag of response does not match sipResponse from tag");
            }
            if (object2 != null) {
                sIPResponse.getFrom().setTag((String)object2);
            } else if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("WARNING -- Null From tag in request!!");
            }
            if (sIPDialog != null && response.getStatusCode() != 100) {
                if (!sIPDialog.checkResponseTags(sIPResponse)) {
                    throw new SipException("Response tags dont match with Dialog tags");
                }
                object = sIPDialog.getState();
                sIPDialog.setLastResponse(this, (SIPResponse)response);
                if (object == null && sIPDialog.getState() == DialogState.TERMINATED) {
                    DialogTerminatedEvent dialogTerminatedEvent = new DialogTerminatedEvent((Object)sIPDialog.getSipProvider(), (Dialog)sIPDialog);
                    sIPDialog.getSipProvider().handleEvent((EventObject)dialogTerminatedEvent, this);
                }
            } else if (sIPDialog == null && this.getMethod().equals("INVITE") && this.retransmissionAlertEnabled && this.retransmissionAlertTimerTask == null && response.getStatusCode() / 100 == 2) {
                object = ((SIPResponse)response).getDialogId(true);
                this.retransmissionAlertTimerTask = new RetransmissionAlertTimerTask((String)object);
                this.sipStack.retransmissionAlertTransactions.put(object, (Object)this);
                this.sipStack.timer.schedule((TimerTask)this.retransmissionAlertTimerTask, 0L, 500L);
            }
            this.sendMessage((SIPResponse)response);
        }
        catch (IOException iOException) {
            throw new SipException(iOException.getMessage());
        }
        catch (ParseException parseException) {
            throw new SipException(parseException.getMessage());
        }
    }

    private TransactionState getRealState() {
        return super.getState();
    }

    public TransactionState getState() {
        if (this.isInviteTransaction() && TransactionState.TRYING == super.getState()) {
            return TransactionState.PROCEEDING;
        }
        return super.getState();
    }

    public void setState(TransactionState transactionState) {
        if (transactionState == TransactionState.TERMINATED && this.isReliable() && !this.getSIPStack().cacheServerConnections) {
            this.collectionTime = 64;
        }
        super.setState(transactionState);
    }

    protected void startTransactionTimer() {
        if (this.sipStack.timer != null) {
            TransactionTimer transactionTimer = new TransactionTimer();
            this.sipStack.timer.schedule((TimerTask)transactionTimer, 0L, 500L);
        }
    }

    public boolean equals(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)object;
        return this.getBranch().equalsIgnoreCase(sIPServerTransaction.getBranch());
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(SIPDialog sIPDialog, String string) {
        if (this.sipStack.logWriter.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("setDialog " + this + " dialog = " + sIPDialog);
        }
        this.dialog = sIPDialog;
        if (string != null) {
            this.dialog.setAssigned();
        }
        if (this.retransmissionAlertEnabled && this.retransmissionAlertTimerTask != null) {
            this.retransmissionAlertTimerTask.cancel();
            this.retransmissionAlertTimerTask = null;
            this.sipStack.retransmissionAlertTransactions.remove((Object)this.retransmissionAlertTimerTask.dialogId);
        }
        this.retransmissionAlertEnabled = false;
    }

    public void terminate() throws ObjectInUseException {
        this.setState(TransactionState.TERMINATED);
        if (this.retransmissionAlertTimerTask != null) {
            this.retransmissionAlertTimerTask.cancel();
            this.retransmissionAlertTimerTask = null;
            this.sipStack.retransmissionAlertTransactions.remove((Object)this.retransmissionAlertTimerTask.dialogId);
        }
    }

    protected void sendReliableProvisionalResponse(Response response) throws SipException {
        if (this.pendingReliableResponse != null) {
            throw new SipException("Unacknowledged response");
        }
        this.pendingReliableResponse = (SIPResponse)response;
        RSeq rSeq = (RSeq)response.getHeader("RSeq");
        if (response.getHeader("RSeq") == null) {
            rSeq = new RSeq();
            response.setHeader((Header)rSeq);
        }
        try {
            ++this.rseqNumber;
            rSeq.setSeqNumber(this.rseqNumber);
            this.lastResponse = (SIPResponse)response;
            this.sendMessage((SIPMessage)response);
            this.provisionalResponseTask = new ProvisionalResponseTask();
            this.sipStack.timer.schedule((TimerTask)this.provisionalResponseTask, 0L, 500L);
        }
        catch (Exception exception) {
            InternalErrorHandler.handleException(exception);
        }
    }

    public SIPResponse getReliableProvisionalResponse() {
        return this.pendingReliableResponse;
    }

    public boolean prackRecieved() {
        if (this.pendingReliableResponse == null) {
            return false;
        }
        this.provisionalResponseTask.cancel();
        this.pendingReliableResponse = null;
        return true;
    }

    public void enableRetransmissionAlerts() throws SipException {
        if (this.getDialog() != null) {
            throw new SipException("Dialog associated with tx");
        }
        if (!this.getMethod().equals("INVITE")) {
            throw new SipException("Request Method must be INVITE");
        }
        this.retransmissionAlertEnabled = true;
    }

    public boolean isRetransmissionAlertEnabled() {
        return this.retransmissionAlertEnabled;
    }

    public void disableRetransmissionAlerts() {
        if (this.retransmissionAlertTimerTask != null && this.retransmissionAlertEnabled) {
            this.retransmissionAlertTimerTask.cancel();
            this.retransmissionAlertEnabled = false;
            this.retransmissionAlertTimerTask = null;
            String string = this.retransmissionAlertTimerTask.dialogId;
            this.sipStack.retransmissionAlertTransactions.remove((Object)string);
        }
    }

    public void setAckSeen() {
        this.isAckSeen = true;
    }

    public boolean ackSeen() {
        return this.isAckSeen;
    }

    public void setMapped(boolean bl) {
        this.isMapped = true;
    }

    public void setPendingSubscribe(SIPClientTransaction sIPClientTransaction) {
        this.pendingSubscribeTransaction = sIPClientTransaction;
    }

    public void releaseSem() {
        if (this.pendingSubscribeTransaction != null) {
            this.pendingSubscribeTransaction.releaseSem();
        } else if (this.inviteTransaction != null && this.getMethod().equals("CANCEL")) {
            this.inviteTransaction.releaseSem();
        }
        super.releaseSem();
    }

    public void setInviteTransaction(SIPServerTransaction sIPServerTransaction) {
        this.inviteTransaction = sIPServerTransaction;
    }

    class TransactionTimer
    extends SIPStackTimerTask {
        public TransactionTimer() {
            if (SIPServerTransaction.this.sipStack.logWriter.isLoggingEnabled()) {
                SIPServerTransaction.this.sipStack.logWriter.logDebug("TransactionTimer() : " + SIPServerTransaction.this.getTransactionId());
            }
        }

        protected void runTask() {
            if (SIPServerTransaction.this.isTerminated()) {
                block4: {
                    try {
                        this.cancel();
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (SIPServerTransaction.this.sipStack.isAlive()) break block4;
                        return;
                    }
                }
                SIPTransaction.LingerTimer lingerTimer = new SIPTransaction.LingerTimer(SIPServerTransaction.this);
                SIPServerTransaction.this.sipStack.timer.schedule((TimerTask)lingerTimer, 8000L);
            } else {
                SIPServerTransaction.this.fireTimer();
            }
        }
    }

    class SendTrying
    extends SIPStackTimerTask {
        protected SendTrying() {
            if (SIPServerTransaction.this.sipStack.isLoggingEnabled()) {
                SIPServerTransaction.this.sipStack.logWriter.logDebug("scheduled timer for " + SIPServerTransaction.this);
            }
        }

        protected void runTask() {
            block5: {
                SIPServerTransaction sIPServerTransaction = SIPServerTransaction.this;
                if (sIPServerTransaction.getRealState() == null || TransactionState.TRYING == sIPServerTransaction.getRealState()) {
                    if (SIPServerTransaction.this.sipStack.isLoggingEnabled()) {
                        SIPServerTransaction.this.sipStack.logWriter.logDebug(" sending Trying current state = " + sIPServerTransaction.getRealState());
                    }
                    try {
                        sIPServerTransaction.sendMessage(sIPServerTransaction.getOriginalRequest().createResponse(100, "Trying"));
                        if (sIPServerTransaction.sipStack.isLoggingEnabled()) {
                            SIPServerTransaction.this.sipStack.logWriter.logDebug(" trying sent " + sIPServerTransaction.getRealState());
                        }
                    }
                    catch (IOException iOException) {
                        if (!sIPServerTransaction.sipStack.isLoggingEnabled()) break block5;
                        SIPServerTransaction.this.sipStack.logWriter.logError("IO error sending  TRYING");
                    }
                }
            }
        }
    }

    class ListenerExecutionMaxTimer
    extends SIPStackTimerTask {
        SIPServerTransaction serverTransaction;

        ListenerExecutionMaxTimer() {
            this.serverTransaction = SIPServerTransaction.this;
        }

        protected void runTask() {
            try {
                if (this.serverTransaction.getState() == null) {
                    this.serverTransaction.terminate();
                    SIPTransactionStack sIPTransactionStack = this.serverTransaction.getSIPStack();
                    sIPTransactionStack.removePendingTransaction(this.serverTransaction);
                    sIPTransactionStack.removeTransaction(this.serverTransaction);
                }
            }
            catch (Exception exception) {
                SIPServerTransaction.this.sipStack.getLogWriter().logError("unexpected exception", exception);
            }
        }
    }

    class ProvisionalResponseTask
    extends SIPStackTimerTask {
        int ticks;
        int ticksLeft;

        public ProvisionalResponseTask() {
            this.ticksLeft = this.ticks = 1;
        }

        protected void runTask() {
            SIPServerTransaction sIPServerTransaction = SIPServerTransaction.this;
            if (sIPServerTransaction.isTerminated()) {
                this.cancel();
            } else {
                --this.ticksLeft;
                if (this.ticksLeft == -1) {
                    sIPServerTransaction.fireReliableResponseRetransmissionTimer();
                    this.ticksLeft = 2 * this.ticks;
                }
            }
        }
    }

    class RetransmissionAlertTimerTask
    extends SIPStackTimerTask {
        String dialogId;
        int ticks;
        int ticksLeft;

        public RetransmissionAlertTimerTask(String string) {
            this.ticksLeft = this.ticks = 1;
        }

        protected void runTask() {
            SIPServerTransaction sIPServerTransaction = SIPServerTransaction.this;
            --this.ticksLeft;
            if (this.ticksLeft == -1) {
                sIPServerTransaction.fireRetransmissionTimer();
                this.ticksLeft = 2 * this.ticks;
            }
        }
    }
}

