/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.filters.BaseFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.types.Substitution;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.LineTokenizer;
import org.apache.tools.ant.util.Tokenizer;
import org.apache.tools.ant.util.regexp.Regexp;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TokenFilter
extends BaseFilterReader
implements ChainableReader {
    private Vector filters;
    private Tokenizer tokenizer;
    private String delimOutput;
    private String line;
    private int linePos;

    public int read() throws IOException {
        if (this.tokenizer == null) {
            this.tokenizer = new LineTokenizer();
        }
        while (this.line == null || this.line.length() == 0) {
            this.line = this.tokenizer.getToken(this.in);
            if (this.line == null) {
                return -1;
            }
            Enumeration enumeration = this.filters.elements();
            while (enumeration.hasMoreElements()) {
                Filter filter = (Filter)enumeration.nextElement();
                this.line = filter.filter(this.line);
                if (this.line == null) break;
            }
            this.linePos = 0;
            if (this.line == null || this.tokenizer.getPostToken().length() == 0) continue;
            this.line = this.delimOutput != null ? this.line + this.delimOutput : this.line + this.tokenizer.getPostToken();
        }
        char c = this.line.charAt(this.linePos);
        ++this.linePos;
        if (this.linePos == this.line.length()) {
            this.line = null;
        }
        return c;
    }

    public final Reader chain(Reader reader) {
        TokenFilter tokenFilter = new TokenFilter(reader);
        tokenFilter.filters = this.filters;
        tokenFilter.tokenizer = this.tokenizer;
        tokenFilter.delimOutput = this.delimOutput;
        tokenFilter.setProject(this.getProject());
        return tokenFilter;
    }

    public void setDelimOutput(String string) {
        this.delimOutput = TokenFilter.resolveBackSlash(string);
    }

    public void addLineTokenizer(LineTokenizer lineTokenizer) {
        this.add(lineTokenizer);
    }

    public void addStringTokenizer(StringTokenizer stringTokenizer) {
        this.add(stringTokenizer);
    }

    public void addFileTokenizer(FileTokenizer fileTokenizer) {
        this.add(fileTokenizer);
    }

    public void add(Tokenizer tokenizer) {
        if (this.tokenizer != null) {
            throw new BuildException("Only one tokenizer allowed");
        }
        this.tokenizer = tokenizer;
    }

    public void addReplaceString(ReplaceString replaceString) {
        this.filters.addElement(replaceString);
    }

    public void addContainsString(ContainsString containsString) {
        this.filters.addElement(containsString);
    }

    public void addReplaceRegex(ReplaceRegex replaceRegex) {
        this.filters.addElement(replaceRegex);
    }

    public void addContainsRegex(ContainsRegex containsRegex) {
        this.filters.addElement(containsRegex);
    }

    public void addTrim(Trim trim) {
        this.filters.addElement(trim);
    }

    public void addIgnoreBlank(IgnoreBlank ignoreBlank) {
        this.filters.addElement(ignoreBlank);
    }

    public void addDeleteCharacters(DeleteCharacters deleteCharacters) {
        this.filters.addElement(deleteCharacters);
    }

    public void add(Filter filter) {
        this.filters.addElement(filter);
    }

    public static String resolveBackSlash(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!bl) {
                if (c == '\\') {
                    bl = true;
                } else {
                    stringBuffer.append(c);
                }
            } else {
                switch (c) {
                    case '\\': {
                        stringBuffer.append('\\');
                        break;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        break;
                    }
                    case 'f': {
                        stringBuffer.append('\f');
                        break;
                    }
                    case 's': {
                        stringBuffer.append(" \t\n\r\f");
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                bl = false;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static int convertRegexOptions(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        if (string.indexOf(103) != -1) {
            n |= 0x10;
        }
        if (string.indexOf(105) != -1) {
            n |= 0x100;
        }
        if (string.indexOf(109) != -1) {
            n |= 0x1000;
        }
        if (string.indexOf(115) != -1) {
            n |= 0x10000;
        }
        return n;
    }

    private final /* synthetic */ void this() {
        this.filters = new Vector();
        this.tokenizer = null;
        this.delimOutput = null;
        this.line = null;
        this.linePos = 0;
    }

    public TokenFilter() {
        this.this();
    }

    public TokenFilter(Reader reader) {
        super(reader);
        this.this();
    }

    public static interface Filter {
        public String filter(String var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class DeleteCharacters
    extends ProjectComponent
    implements Filter,
    ChainableReader {
        private String deleteChars;

        public void setChars(String string) {
            this.deleteChars = TokenFilter.resolveBackSlash(string);
        }

        public String filter(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!this.isDeleteCharacter(c)) {
                    stringBuffer.append(c);
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        public Reader chain(Reader reader) {
            return new BaseFilterReader(reader){

                public final int read() throws IOException {
                    int n;
                    do {
                        if ((n = this.in.read()) != -1) continue;
                        return n;
                    } while (DeleteCharacters.this.isDeleteCharacter((char)n));
                    return n;
                }
            };
        }

        private final boolean isDeleteCharacter(char c) {
            int n = 0;
            while (n < this.deleteChars.length()) {
                if (this.deleteChars.charAt(n) == c) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private final /* synthetic */ void this() {
            this.deleteChars = "";
        }

        public DeleteCharacters() {
            this.this();
        }
    }

    public static class IgnoreBlank
    extends ChainableReaderFilter {
        public String filter(String string) {
            if (string.trim().length() == 0) {
                return null;
            }
            return string;
        }
    }

    public static class Trim
    extends ChainableReaderFilter {
        public String filter(String string) {
            return string.trim();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ContainsRegex
    extends ChainableReaderFilter {
        private String from;
        private String to;
        private Project project;
        private RegularExpression regularExpression;
        private Substitution substitution;
        private boolean initialized;
        private String flags;
        private int options;
        private Regexp regexp;

        public void setPattern(String string) {
            this.from = string;
        }

        public void setReplace(String string) {
            this.to = string;
        }

        public void setFlags(String string) {
            this.flags = string;
        }

        private final void initialize() {
            if (this.initialized) {
                return;
            }
            this.options = TokenFilter.convertRegexOptions(this.flags);
            if (this.from == null) {
                throw new BuildException("Missing from in containsregex");
            }
            this.regularExpression = new RegularExpression();
            this.regularExpression.setPattern(this.from);
            this.regexp = this.regularExpression.getRegexp(this.project);
            if (this.to == null) {
                return;
            }
            this.substitution = new Substitution();
            this.substitution.setExpression(this.to);
        }

        public String filter(String string) {
            this.initialize();
            if (!this.regexp.matches(string, this.options)) {
                return null;
            }
            if (this.substitution == null) {
                return string;
            }
            return this.regexp.substitute(string, this.substitution.getExpression(this.getProject()), this.options);
        }

        private final /* synthetic */ void this() {
            this.initialized = false;
            this.flags = "";
        }

        public ContainsRegex() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ReplaceRegex
    extends ChainableReaderFilter {
        private String from;
        private String to;
        private RegularExpression regularExpression;
        private Substitution substitution;
        private boolean initialized;
        private String flags;
        private int options;
        private Regexp regexp;

        public void setPattern(String string) {
            this.from = string;
        }

        public void setReplace(String string) {
            this.to = string;
        }

        public void setFlags(String string) {
            this.flags = string;
        }

        private final void initialize() {
            if (this.initialized) {
                return;
            }
            this.options = TokenFilter.convertRegexOptions(this.flags);
            if (this.from == null) {
                throw new BuildException("Missing pattern in replaceregex");
            }
            this.regularExpression = new RegularExpression();
            this.regularExpression.setPattern(this.from);
            this.regexp = this.regularExpression.getRegexp(this.getProject());
            if (this.to == null) {
                this.to = "";
            }
            this.substitution = new Substitution();
            this.substitution.setExpression(this.to);
        }

        public String filter(String string) {
            this.initialize();
            if (!this.regexp.matches(string, this.options)) {
                return string;
            }
            return this.regexp.substitute(string, this.substitution.getExpression(this.getProject()), this.options);
        }

        private final /* synthetic */ void this() {
            this.initialized = false;
            this.flags = "";
        }

        public ReplaceRegex() {
            this.this();
        }
    }

    public static class ContainsString
    extends ProjectComponent
    implements Filter {
        private String contains;

        public void setContains(String string) {
            this.contains = string;
        }

        public String filter(String string) {
            if (this.contains == null) {
                throw new BuildException("Missing contains in containsstring");
            }
            if (string.indexOf(this.contains) > -1) {
                return string;
            }
            return null;
        }
    }

    public static class ReplaceString
    extends ChainableReaderFilter {
        private String from;
        private String to;

        public void setFrom(String string) {
            this.from = string;
        }

        public void setTo(String string) {
            this.to = string;
        }

        public String filter(String string) {
            if (this.from == null) {
                throw new BuildException("Missing from in stringreplace");
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = string.indexOf(this.from);
            while (n2 >= 0) {
                if (n2 > n) {
                    stringBuffer.append(string.substring(n, n2));
                }
                if (this.to != null) {
                    stringBuffer.append(this.to);
                }
                n = n2 + this.from.length();
                n2 = string.indexOf(this.from, n);
            }
            if (string.length() > n) {
                stringBuffer.append(string.substring(n, string.length()));
            }
            return stringBuffer.toString();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static abstract class ChainableReaderFilter
    extends ProjectComponent
    implements ChainableReader,
    Filter {
        private boolean byLine;

        public void setByLine(boolean bl) {
            this.byLine = bl;
        }

        public Reader chain(Reader reader) {
            TokenFilter tokenFilter = new TokenFilter(reader);
            if (!this.byLine) {
                tokenFilter.add(new FileTokenizer());
            }
            tokenFilter.add(this);
            return tokenFilter;
        }

        private final /* synthetic */ void this() {
            this.byLine = true;
        }

        public ChainableReaderFilter() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class StringTokenizer
    extends ProjectComponent
    implements Tokenizer {
        private String intraString;
        private int pushed;
        private char[] delims;
        private boolean delimsAreTokens;
        private boolean suppressDelims;
        private boolean includeDelims;

        public void setDelims(String string) {
            this.delims = TokenFilter.resolveBackSlash(string).toCharArray();
        }

        public void setDelimsAreTokens(boolean bl) {
            this.delimsAreTokens = bl;
        }

        public void setSuppressDelims(boolean bl) {
            this.suppressDelims = bl;
        }

        public void setIncludeDelims(boolean bl) {
            this.includeDelims = bl;
        }

        public String getToken(Reader reader) throws IOException {
            int n = -1;
            if (this.pushed != -2) {
                n = this.pushed;
                this.pushed = -2;
            } else {
                n = reader.read();
            }
            if (n == -1) {
                return null;
            }
            boolean bl = true;
            this.intraString = "";
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            while (n != -1) {
                char c = (char)n;
                boolean bl2 = this.isDelim(c);
                if (bl) {
                    if (bl2) {
                        if (this.delimsAreTokens) {
                            if (stringBuffer.length() == 0) {
                                stringBuffer.append(c);
                                break;
                            }
                            this.pushed = n;
                            break;
                        }
                        stringBuffer2.append(c);
                        bl = false;
                    } else {
                        stringBuffer.append(c);
                    }
                } else if (bl2) {
                    stringBuffer2.append(c);
                } else {
                    this.pushed = n;
                    break;
                }
                n = reader.read();
            }
            this.intraString = stringBuffer2.toString();
            if (this.includeDelims) {
                stringBuffer.append(this.intraString);
            }
            return stringBuffer.toString();
        }

        public String getPostToken() {
            if (this.suppressDelims || this.includeDelims) {
                return "";
            }
            return this.intraString;
        }

        private final boolean isDelim(char c) {
            if (this.delims == null) {
                return Character.isWhitespace(c);
            }
            int n = 0;
            while (n < this.delims.length) {
                if (this.delims[n] == c) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private final /* synthetic */ void this() {
            this.intraString = "";
            this.pushed = -2;
            this.delims = null;
            this.delimsAreTokens = false;
            this.suppressDelims = false;
            this.includeDelims = false;
        }

        public StringTokenizer() {
            this.this();
        }
    }

    public static class FileTokenizer
    extends ProjectComponent
    implements Tokenizer {
        public String getToken(Reader reader) throws IOException {
            return FileUtils.readFully(reader);
        }

        public String getPostToken() {
            return "";
        }
    }
}

