/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.sip.Dialog;
import javax.sip.IOExceptionEvent;
import javax.sip.ServerTransaction;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.message.Request;
import javax.sip.message.Response;

public abstract class SIPTransaction
extends MessageChannel
implements Transaction {
    protected boolean toListener;
    protected int BASE_TIMER_INTERVAL = 500;
    protected int T4 = 5000 / this.BASE_TIMER_INTERVAL;
    protected int T2 = 4000 / this.BASE_TIMER_INTERVAL;
    protected int TIMER_I = this.T4;
    protected int TIMER_K = this.T4;
    protected int TIMER_D = 32000 / this.BASE_TIMER_INTERVAL;
    protected static final int T1 = 1;
    protected static final int TIMER_A = 1;
    protected static final int TIMER_B = 64;
    protected static final int TIMER_J = 64;
    protected static final int TIMER_F = 64;
    protected static final int TIMER_H = 64;
    protected Object applicationData;
    protected SIPResponse lastResponse;
    protected boolean isMapped;
    private Semaphore semaphore;
    protected boolean isSemaphoreAquired;
    protected String transactionId;
    public long auditTag = 0L;
    public static final TransactionState INITIAL_STATE = null;
    public static final TransactionState TRYING_STATE = TransactionState.TRYING;
    public static final TransactionState CALLING_STATE = TransactionState.CALLING;
    public static final TransactionState PROCEEDING_STATE = TransactionState.PROCEEDING;
    public static final TransactionState COMPLETED_STATE = TransactionState.COMPLETED;
    public static final TransactionState CONFIRMED_STATE = TransactionState.CONFIRMED;
    public static final TransactionState TERMINATED_STATE = TransactionState.TERMINATED;
    protected static final int MAXIMUM_RETRANSMISSION_TICK_COUNT = 8;
    protected transient SIPTransactionStack sipStack;
    protected SIPRequest originalRequest;
    private transient MessageChannel encapsulatedChannel;
    protected int peerPort;
    protected InetAddress peerInetAddress;
    protected String peerAddress;
    protected String peerProtocol;
    protected int peerPacketSourcePort;
    protected InetAddress peerPacketSourceAddress;
    private String branch;
    private String method;
    private long cSeq;
    private TransactionState currentState;
    private transient int retransmissionTimerLastTickCount;
    private transient int retransmissionTimerTicksLeft;
    protected int timeoutTimerTicksLeft;
    private transient Set eventListeners;
    protected From from;
    protected To to;
    protected Event event;
    protected CallID callId;
    protected int collectionTime;
    protected String toTag;
    protected String fromTag;
    private boolean terminatedEventDelivered;

    public String getBranchId() {
        return this.branch;
    }

    protected SIPTransaction(SIPTransactionStack sIPTransactionStack, MessageChannel messageChannel) {
        this.sipStack = sIPTransactionStack;
        this.semaphore = new Semaphore(1L);
        this.encapsulatedChannel = messageChannel;
        this.peerPort = messageChannel.getPeerPort();
        this.peerAddress = messageChannel.getPeerAddress();
        this.peerInetAddress = messageChannel.getPeerInetAddress();
        this.peerPacketSourcePort = messageChannel.getPeerPacketSourcePort();
        this.peerPacketSourceAddress = messageChannel.getPeerPacketSourceAddress();
        this.peerProtocol = messageChannel.getPeerProtocol();
        if (this.isReliable()) {
            if (this.encapsulatedChannel instanceof TLSMessageChannel) {
                ++((TLSMessageChannel)this.encapsulatedChannel).useCount;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("use count for encapsulated channel" + this + " " + ((TLSMessageChannel)this.encapsulatedChannel).useCount);
                }
            } else {
                ++((TCPMessageChannel)this.encapsulatedChannel).useCount;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("use count for encapsulated channel" + this + " " + ((TCPMessageChannel)this.encapsulatedChannel).useCount);
                }
            }
        }
        this.currentState = null;
        this.disableRetransmissionTimer();
        this.disableTimeoutTimer();
        this.eventListeners = Collections.synchronizedSet(new HashSet());
        this.addEventListener(sIPTransactionStack);
    }

    public void setOriginalRequest(SIPRequest sIPRequest) {
        if (this.originalRequest != null && !this.originalRequest.getTransactionId().equals(sIPRequest.getTransactionId())) {
            this.sipStack.removeTransactionHash(this);
        }
        this.originalRequest = sIPRequest;
        this.method = sIPRequest.getMethod();
        this.from = (From)sIPRequest.getFrom();
        this.to = (To)sIPRequest.getTo();
        this.toTag = this.to.getTag();
        this.fromTag = this.from.getTag();
        this.callId = (CallID)sIPRequest.getCallId();
        this.cSeq = sIPRequest.getCSeq().getSeqNumber();
        this.event = (Event)sIPRequest.getHeader("Event");
        this.transactionId = sIPRequest.getTransactionId();
        this.originalRequest.setTransaction(this);
        String string = ((Via)sIPRequest.getViaHeaders().getFirst()).getBranch();
        if (string != null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Setting Branch id : " + string);
            }
            this.setBranch(string);
        } else {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Branch id is null - compute TID!" + sIPRequest.encode());
            }
            this.setBranch(sIPRequest.getTransactionId());
        }
    }

    public SIPRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public Request getRequest() {
        return this.originalRequest;
    }

    public final boolean isInviteTransaction() {
        return this.getMethod().equals("INVITE");
    }

    public final boolean isCancelTransaction() {
        return this.getMethod().equals("CANCEL");
    }

    public final boolean isByeTransaction() {
        return this.getMethod().equals("BYE");
    }

    public MessageChannel getMessageChannel() {
        return this.encapsulatedChannel;
    }

    public final void setBranch(String string) {
        this.branch = string;
    }

    public final String getBranch() {
        if (this.branch == null) {
            this.branch = this.getOriginalRequest().getTopmostVia().getBranch();
        }
        return this.branch;
    }

    public final String getMethod() {
        return this.method;
    }

    public final long getCSeq() {
        return this.cSeq;
    }

    public void setState(TransactionState transactionState) {
        if (this.currentState == TransactionState.COMPLETED && transactionState != TransactionState.TERMINATED && transactionState != TransactionState.CONFIRMED) {
            transactionState = TransactionState.COMPLETED;
        }
        if (this.currentState == TransactionState.CONFIRMED && transactionState != TransactionState.TERMINATED) {
            transactionState = TransactionState.CONFIRMED;
        }
        if (this.currentState != TransactionState.TERMINATED) {
            this.currentState = transactionState;
        } else {
            transactionState = this.currentState;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Transaction:setState " + transactionState + " " + this + " branchID = " + this.getBranch() + " isClient = " + (this instanceof SIPClientTransaction));
            this.sipStack.logWriter.logStackTrace();
        }
    }

    public TransactionState getState() {
        return this.currentState;
    }

    protected final void enableRetransmissionTimer() {
        this.enableRetransmissionTimer(1);
    }

    protected final void enableRetransmissionTimer(int n) {
        this.retransmissionTimerTicksLeft = this.isInviteTransaction() && this instanceof SIPClientTransaction ? n : Math.min(n, 8);
        this.retransmissionTimerLastTickCount = this.retransmissionTimerTicksLeft;
    }

    protected final void disableRetransmissionTimer() {
        this.retransmissionTimerTicksLeft = -1;
    }

    protected final void enableTimeoutTimer(int n) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("enableTimeoutTimer " + this + " tickCount " + n + " currentTickCount = " + this.timeoutTimerTicksLeft);
        }
        this.timeoutTimerTicksLeft = n;
    }

    protected final void disableTimeoutTimer() {
        this.timeoutTimerTicksLeft = -1;
    }

    final void fireTimer() {
        if (this.timeoutTimerTicksLeft != -1 && --this.timeoutTimerTicksLeft == 0) {
            this.fireTimeoutTimer();
        }
        if (this.retransmissionTimerTicksLeft != -1 && --this.retransmissionTimerTicksLeft == 0) {
            this.enableRetransmissionTimer(this.retransmissionTimerLastTickCount * 2);
            this.fireRetransmissionTimer();
        }
    }

    public final boolean isTerminated() {
        return this.getState() == TERMINATED_STATE;
    }

    public String getHost() {
        return this.encapsulatedChannel.getHost();
    }

    public String getKey() {
        return this.encapsulatedChannel.getKey();
    }

    public int getPort() {
        return this.encapsulatedChannel.getPort();
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getPeerPacketSourcePort() {
        return this.peerPacketSourcePort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerPacketSourceAddress;
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerInetAddress;
    }

    protected String getPeerProtocol() {
        return this.peerProtocol;
    }

    public String getTransport() {
        return this.encapsulatedChannel.getTransport();
    }

    public boolean isReliable() {
        return this.encapsulatedChannel.isReliable();
    }

    public Via getViaHeader() {
        Via via = super.getViaHeader();
        try {
            via.setBranch(this.branch);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return via;
    }

    public void sendMessage(SIPMessage sIPMessage) throws IOException {
        this.encapsulatedChannel.sendMessage(sIPMessage, this.peerInetAddress, this.peerPort);
    }

    protected void sendMessage(byte[] byArray, InetAddress inetAddress, int n, boolean bl) throws IOException {
        throw new IOException("Cannot send unparsed message through Transaction Channel!");
    }

    public void addEventListener(SIPTransactionEventListener sIPTransactionEventListener) {
        this.eventListeners.add(sIPTransactionEventListener);
    }

    public void removeEventListener(SIPTransactionEventListener sIPTransactionEventListener) {
        this.eventListeners.remove(sIPTransactionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseErrorEvent(int n) {
        SIPTransactionErrorEvent sIPTransactionErrorEvent = new SIPTransactionErrorEvent(this, n);
        Set set = this.eventListeners;
        synchronized (set) {
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                SIPTransactionEventListener sIPTransactionEventListener = (SIPTransactionEventListener)iterator.next();
                sIPTransactionEventListener.transactionErrorEvent(sIPTransactionErrorEvent);
            }
        }
        if (n != 3) {
            this.eventListeners.clear();
            this.setState(TransactionState.TERMINATED);
            if (this instanceof SIPServerTransaction && this.isByeTransaction() && this.getDialog() != null) {
                ((SIPDialog)this.getDialog()).setState(3);
            }
        }
    }

    protected boolean IsServerTransaction() {
        return this instanceof SIPServerTransaction;
    }

    public abstract Dialog getDialog();

    public abstract void setDialog(SIPDialog var1, String var2);

    public int getRetransmitTimer() {
        return 500;
    }

    public String getViaHost() {
        return this.getViaHeader().getHost();
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    public Response getResponse() {
        return this.lastResponse;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public int hashCode() {
        if (this.transactionId == null) {
            return -1;
        }
        return this.transactionId.hashCode();
    }

    public int getViaPort() {
        return this.getViaHeader().getPort();
    }

    public boolean doesCancelMatchTransaction(SIPRequest sIPRequest) {
        boolean bl = false;
        if (this.getOriginalRequest() == null || this.getOriginalRequest().getMethod().equals("CANCEL")) {
            return false;
        }
        ViaList viaList = sIPRequest.getViaHeaders();
        if (viaList != null) {
            Via via = (Via)viaList.getFirst();
            String string = via.getBranch();
            if (string != null && !string.startsWith("z9hG4bK")) {
                string = null;
            }
            if (string != null && this.getBranch() != null) {
                if (this.getBranch().equalsIgnoreCase(string) && via.getSentBy().equals(((Via)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy())) {
                    bl = true;
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.logWriter.logDebug("returning  true");
                    }
                }
            } else {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("testing against " + this.getOriginalRequest());
                }
                if (this.getOriginalRequest().getRequestURI().equals(sIPRequest.getRequestURI()) && this.getOriginalRequest().getTo().equals(sIPRequest.getTo()) && this.getOriginalRequest().getFrom().equals(sIPRequest.getFrom()) && this.getOriginalRequest().getCallId().getCallId().equals(sIPRequest.getCallId().getCallId()) && this.getOriginalRequest().getCSeq().getSeqNumber() == sIPRequest.getCSeq().getSeqNumber() && via.equals(this.getOriginalRequest().getViaHeaders().getFirst())) {
                    bl = true;
                }
            }
        }
        if (bl) {
            this.setPassToListener();
        }
        return bl;
    }

    public void setRetransmitTimer(int n) {
        this.BASE_TIMER_INTERVAL = 500;
        this.T4 = 5000 / this.BASE_TIMER_INTERVAL;
        this.T2 = 4000 / this.BASE_TIMER_INTERVAL;
        this.TIMER_I = this.T4;
        this.TIMER_K = this.T4;
        this.TIMER_D = 32000 / this.BASE_TIMER_INTERVAL;
    }

    public void close() {
        this.encapsulatedChannel.close();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Closing " + this.encapsulatedChannel);
        }
    }

    public boolean isSecure() {
        return this.encapsulatedChannel.isSecure();
    }

    public MessageProcessor getMessageProcessor() {
        return this.encapsulatedChannel.getMessageProcessor();
    }

    public void setApplicationData(Object object) {
        this.applicationData = object;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public void setEncapsulatedChannel(MessageChannel messageChannel) {
        this.encapsulatedChannel = messageChannel;
        this.peerInetAddress = messageChannel.getPeerInetAddress();
        this.peerPort = messageChannel.getPeerPort();
    }

    public SipProviderImpl getSipProvider() {
        return this.getMessageProcessor().getListeningPoint().getProvider();
    }

    public void raiseIOExceptionEvent() {
        this.setState(TransactionState.TERMINATED);
        String string = this.getPeerAddress();
        int n = this.getPeerPort();
        String string2 = this.getTransport();
        IOExceptionEvent iOExceptionEvent = new IOExceptionEvent((Object)this, string, n, string2);
        this.getSipProvider().handleEvent((EventObject)iOExceptionEvent, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireSem() {
        boolean bl = false;
        try {
            if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("acquireSem [[[[" + this);
                this.sipStack.getLogWriter().logStackTrace();
            }
            bl = this.semaphore.attempt(10000L);
            this.sipStack.getLogWriter().logDebug("acquireSem() returning : " + bl);
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.sipStack.logWriter.logError("Unexpected exception acquiring sem", exception);
            InternalErrorHandler.handleException(exception);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.isSemaphoreAquired = bl;
        }
    }

    public void releaseSem() {
        try {
            this.toListener = false;
            this.semRelease();
        }
        catch (Exception exception) {
            this.sipStack.logWriter.logError("Unexpected exception releasing sem", exception);
        }
    }

    protected void semRelease() {
        try {
            if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("semRelease ]]]]" + this);
                this.sipStack.getLogWriter().logStackTrace();
            }
            this.isSemaphoreAquired = false;
            this.semaphore.release();
        }
        catch (Exception exception) {
            this.sipStack.logWriter.logError("Unexpected exception releasing sem", exception);
        }
    }

    public boolean passToListener() {
        return this.toListener;
    }

    public void setPassToListener() {
        if (this.sipStack.logWriter.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("setPassToListener()");
        }
        this.toListener = true;
    }

    protected synchronized boolean testAndSetTransactionTerminatedEvent() {
        boolean bl = !this.terminatedEventDelivered;
        this.terminatedEventDelivered = true;
        return bl;
    }

    protected abstract void startTransactionTimer();

    public abstract boolean isMessagePartOfTransaction(SIPMessage var1);

    protected abstract void fireRetransmissionTimer();

    protected abstract void fireTimeoutTimer();

    class LingerTimer
    extends SIPStackTimerTask {
        public LingerTimer() {
            SIPTransaction sIPTransaction2 = SIPTransaction.this;
            if (SIPTransaction.this.sipStack.logWriter.isLoggingEnabled()) {
                SIPTransaction.this.sipStack.logWriter.logDebug("LingerTimer : " + sIPTransaction2.getTransactionId());
            }
        }

        protected void runTask() {
            SIPTransaction sIPTransaction = SIPTransaction.this;
            SIPTransactionStack sIPTransactionStack = sIPTransaction.getSIPStack();
            if (sIPTransactionStack.logWriter.isLoggingEnabled()) {
                sIPTransactionStack.logWriter.logDebug("LingerTimer: run() : " + SIPTransaction.this.getTransactionId());
            }
            if (sIPTransaction instanceof SIPClientTransaction) {
                sIPTransactionStack.removeTransaction(sIPTransaction);
                sIPTransaction.close();
            } else if (sIPTransaction instanceof ServerTransaction) {
                if (sIPTransactionStack.isLoggingEnabled()) {
                    sIPTransactionStack.logWriter.logDebug("removing" + sIPTransaction);
                }
                sIPTransactionStack.removeTransaction(sIPTransaction);
                if (!sIPTransactionStack.cacheServerConnections && sIPTransaction.encapsulatedChannel instanceof TCPMessageChannel && --((TCPMessageChannel)((SIPTransaction)sIPTransaction).encapsulatedChannel).useCount <= 0) {
                    sIPTransaction.close();
                } else if (!sIPTransactionStack.cacheServerConnections && sIPTransaction.encapsulatedChannel instanceof TLSMessageChannel && --((TLSMessageChannel)((SIPTransaction)sIPTransaction).encapsulatedChannel).useCount <= 0) {
                    sIPTransaction.close();
                } else if (sIPTransactionStack.isLoggingEnabled() && !sIPTransactionStack.cacheServerConnections && sIPTransaction.isReliable()) {
                    int n = sIPTransaction.encapsulatedChannel instanceof TCPMessageChannel ? ((TCPMessageChannel)((SIPTransaction)sIPTransaction).encapsulatedChannel).useCount : ((TLSMessageChannel)((SIPTransaction)sIPTransaction).encapsulatedChannel).useCount;
                    sIPTransactionStack.logWriter.logDebug("Use Count = " + n);
                }
            }
        }
    }
}

