/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.SIPHeaderList;
import gov.nist.javax.sip.header.Server;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import java.io.IOException;
import java.util.EventObject;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.header.Header;
import javax.sip.message.Request;
import javax.sip.message.Response;

class DialogFilter
implements ServerRequestInterface,
ServerResponseInterface {
    protected SIPTransaction transactionChannel;
    protected ListeningPointImpl listeningPoint;
    private SipStackImpl sipStack;

    public DialogFilter(SipStackImpl sipStackImpl) {
        this.sipStack = sipStackImpl;
    }

    public void processRequest(SIPRequest sIPRequest, MessageChannel messageChannel) {
        String string;
        int n;
        Object object;
        Object object2;
        Object object3;
        String string2;
        Object object4;
        SIPServerTransaction sIPServerTransaction;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("PROCESSING INCOMING REQUEST " + sIPRequest + " transactionChannel = " + this.transactionChannel + " listening point = " + this.listeningPoint.getIPAddress() + ":" + this.listeningPoint.getPort());
        }
        if (this.listeningPoint == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("Dropping message: No listening point registered!");
            }
            return;
        }
        SipStackImpl sipStackImpl = (SipStackImpl)this.transactionChannel.getSIPStack();
        SipProviderImpl sipProviderImpl = this.listeningPoint.getProvider();
        if (sipProviderImpl == null) {
            if (sipStackImpl.isLoggingEnabled()) {
                sipStackImpl.getLogWriter().logDebug("No provider - dropping !!");
            }
            return;
        }
        if (sipStackImpl == null) {
            InternalErrorHandler.handleException("Egads! no sip stack!");
        }
        if ((sIPServerTransaction = (SIPServerTransaction)this.transactionChannel) != null && sipStackImpl.isLoggingEnabled()) {
            sipStackImpl.getLogWriter().logDebug("transaction state = " + sIPServerTransaction.getState());
        }
        if ((object4 = sipStackImpl.getDialog(string2 = sIPRequest.getDialogId(true))) != null && sipProviderImpl != ((SIPDialog)object4).getSipProvider() && (object3 = ((SIPDialog)object4).getMyContactHeader()) != null) {
            object2 = (SipUri)((Contact)object3).getAddress().getURI();
            object = ((SipUri)object2).getHost();
            n = ((SipUri)object2).getPort();
            string = ((SipUri)object2).getTransportParam();
            if (string == null) {
                string = "udp";
            }
            if (n == -1) {
                n = string.equals("udp") || string.equals("tcp") ? 5060 : 5061;
            }
            if (!(object == null || ((String)object).equals(this.listeningPoint.getIPAddress()) && n == this.listeningPoint.getPort())) {
                if (sipStackImpl.isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logDebug("nulling dialog -- listening point mismatch!  " + n + "  lp port = " + this.listeningPoint.getPort());
                }
                object4 = null;
            }
        }
        if (object4 != null && sIPRequest.getToTag() == null && (object3 = sipStackImpl.findMergedTransaction(sIPRequest)) != null && !((SIPServerTransaction)object3).isMessagePartOfTransaction(sIPRequest)) {
            block142: {
                object2 = sIPRequest.createResponse(482);
                ((SIPMessage)object2).setHeader(sipStackImpl.createServerHeaderForStack());
                if (sipStackImpl.getLogWriter().isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logError("Loop detected while processing request");
                }
                try {
                    sipProviderImpl.sendResponse((Response)object2);
                }
                catch (SipException sipException) {
                    if (!sipStackImpl.getLogWriter().isLoggingEnabled()) break block142;
                    sipStackImpl.getLogWriter().logError("Error sending response");
                }
            }
            return;
        }
        if (sipStackImpl.isLoggingEnabled()) {
            sipStackImpl.getLogWriter().logDebug("dialogId = " + string2);
            sipStackImpl.getLogWriter().logDebug("dialog = " + object4);
        }
        if (sIPRequest.getHeader("Route") != null && sIPServerTransaction.getDialog() != null) {
            object3 = sIPRequest.getRouteHeaders();
            object2 = (Route)((SIPHeaderList)object3).getFirst();
            object = (SipUri)((AddressParametersHeader)object2).getAddress().getURI();
            n = ((SipUri)object).getHostPort().hasPort() ? ((SipUri)object).getHostPort().getPort() : (this.listeningPoint.getTransport().equalsIgnoreCase("TLS") ? 5061 : 5060);
            string = ((SipUri)object).getHost();
            if ((string.equals(this.listeningPoint.getIPAddress()) || string.equalsIgnoreCase(this.listeningPoint.getSentBy())) && n == this.listeningPoint.getPort()) {
                if (((SIPHeaderList)object3).size() == 1) {
                    sIPRequest.removeHeader("Route");
                } else {
                    ((SIPHeaderList)object3).removeFirst();
                }
            }
        }
        if (sIPRequest.getMethod().equals("UPDATE")) {
            if (sipProviderImpl.isAutomaticDialogSupportEnabled() && object4 == null) {
                object3 = sIPRequest.createResponse(481);
                object2 = sipStackImpl.createServerHeaderForStack();
                object3.addHeader((Header)object2);
                try {
                    sipProviderImpl.sendResponse((Response)object3);
                }
                catch (SipException sipException) {
                    sipStackImpl.getLogWriter().logError("error sending response", (Exception)((Object)sipException));
                }
                if (sIPServerTransaction != null) {
                    sipStackImpl.removeTransaction(sIPServerTransaction);
                    sIPServerTransaction.releaseSem();
                }
                return;
            }
        } else if (sIPRequest.getMethod().equals("ACK")) {
            if (sIPServerTransaction != null && sIPServerTransaction.isInviteTransaction()) {
                if (sipStackImpl.isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logDebug("Processing ACK for INVITE Tx ");
                }
            } else {
                if (sipStackImpl.isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logDebug("Processing ACK for dialog " + object4);
                }
                if (object4 == null) {
                    if (sipStackImpl.isLoggingEnabled()) {
                        sipStackImpl.getLogWriter().logDebug("Dialog does not exist " + sIPRequest.getFirstLine() + " isServerTransaction = " + true);
                    }
                    if ((object3 = sipStackImpl.getRetransmissionAlertTransaction(string2)) != null && ((SIPServerTransaction)object3).isRetransmissionAlertEnabled()) {
                        ((SIPServerTransaction)object3).disableRetransmissionAlerts();
                    }
                } else {
                    if (!((SIPDialog)object4).handleAck(sIPServerTransaction)) {
                        return;
                    }
                    sIPServerTransaction.passToListener();
                    ((SIPDialog)object4).addTransaction(sIPServerTransaction);
                    ((SIPDialog)object4).addRoute(sIPRequest);
                    sIPServerTransaction.setDialog((SIPDialog)object4, string2);
                    if (sipStackImpl.isDialogCreated(sIPRequest.getMethod())) {
                        sipStackImpl.putInMergeTable(sIPServerTransaction, sIPRequest);
                    }
                    if (sipStackImpl.deliverTerminatedEventForAck) {
                        try {
                            sipStackImpl.addTransaction(sIPServerTransaction);
                        }
                        catch (IOException iOException) {}
                    } else {
                        sIPServerTransaction.setMapped(true);
                    }
                }
            }
        } else if (sIPRequest.getMethod().equals("PRACK")) {
            if (sipStackImpl.isLoggingEnabled()) {
                sipStackImpl.getLogWriter().logDebug("Processing PRACK for dialog " + object4);
            }
            if (object4 == null && sipProviderImpl.isAutomaticDialogSupportEnabled()) {
                if (sipStackImpl.isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logDebug("Dialog does not exist " + sIPRequest.getFirstLine() + " isServerTransaction = " + true);
                }
                if (sipStackImpl.isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logDebug("Sending 481 for PRACK - automatic dialog support is enabled -- cant find dialog!");
                }
                object3 = sIPRequest.createResponse(481);
                object2 = sipStackImpl.createServerHeaderForStack();
                ((SIPMessage)object3).addHeader((Header)object2);
                try {
                    sipProviderImpl.sendResponse((Response)object3);
                }
                catch (SipException sipException) {
                    sipStackImpl.getLogWriter().logError("error sending response", (Exception)((Object)sipException));
                }
                if (sIPServerTransaction != null) {
                    sipStackImpl.removeTransaction(sIPServerTransaction);
                    sIPServerTransaction.releaseSem();
                }
                return;
            }
            if (object4 != null) {
                if (!((SIPDialog)object4).handlePrack(sIPRequest)) {
                    sipStackImpl.getLogWriter().logDebug("Dropping out of sequence PRACK ");
                    if (sIPServerTransaction != null) {
                        sipStackImpl.removeTransaction(sIPServerTransaction);
                        sIPServerTransaction.releaseSem();
                    }
                    return;
                }
                try {
                    sipStackImpl.addTransaction(sIPServerTransaction);
                    ((SIPDialog)object4).addTransaction(sIPServerTransaction);
                    ((SIPDialog)object4).addRoute(sIPRequest);
                }
                catch (Exception exception) {
                    InternalErrorHandler.handleException(exception);
                }
            } else {
                sipStackImpl.getLogWriter().logDebug("Processing PRACK without a DIALOG -- this must be a proxy element");
            }
        } else if (sIPRequest.getMethod().equals("BYE")) {
            if (object4 != null && !((SIPDialog)object4).isRequestConsumable(sIPRequest)) {
                if (sipStackImpl.isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logDebug("Dropping out of sequence BYE");
                }
                if (sIPServerTransaction != null) {
                    sipStackImpl.removeTransaction(sIPServerTransaction);
                }
                return;
            }
            if (object4 == null && sipProviderImpl.isAutomaticDialogSupportEnabled()) {
                object3 = sIPRequest.createResponse(481);
                object2 = sipStackImpl.createServerHeaderForStack();
                ((SIPMessage)object3).addHeader((Header)object2);
                sipStackImpl.getLogWriter().logDebug("dropping request -- automatic dialog support enabled and dialog does not exist!");
                try {
                    sIPServerTransaction.sendResponse((Response)object3);
                }
                catch (SipException sipException) {
                    sipStackImpl.getLogWriter().logError("Error in sending response", (Exception)((Object)sipException));
                }
                if (sIPServerTransaction != null) {
                    sipStackImpl.removeTransaction(sIPServerTransaction);
                    sIPServerTransaction.releaseSem();
                    sIPServerTransaction = null;
                }
                return;
            }
            if (sIPServerTransaction != null && object4 != null) {
                try {
                    if (sipProviderImpl == ((SIPDialog)object4).getSipProvider()) {
                        sipStackImpl.addTransaction(sIPServerTransaction);
                        ((SIPDialog)object4).addTransaction(sIPServerTransaction);
                        sIPServerTransaction.setDialog((SIPDialog)object4, string2);
                    }
                }
                catch (IOException iOException) {
                    InternalErrorHandler.handleException(iOException);
                }
            }
            if (sipStackImpl.getLogWriter().isLoggingEnabled()) {
                sipStackImpl.getLogWriter().logDebug("BYE Tx = " + sIPServerTransaction + " isMapped =" + sIPServerTransaction.isTransactionMapped());
            }
        } else if (sIPRequest.getMethod().equals("CANCEL")) {
            object3 = (SIPServerTransaction)sipStackImpl.findCancelTransaction(sIPRequest, true);
            if (sipStackImpl.getLogWriter().isLoggingEnabled()) {
                sipStackImpl.getLogWriter().logDebug("Got a CANCEL, InviteServerTx = " + object3 + " cancel Server Tx ID = " + sIPServerTransaction + " isMapped = " + sIPServerTransaction.isTransactionMapped());
            }
            if (sIPRequest.getMethod().equals("CANCEL")) {
                if (object3 != null && ((SIPServerTransaction)object3).getState() == SIPTransaction.TERMINATED_STATE) {
                    block143: {
                        if (sipStackImpl.isLoggingEnabled()) {
                            sipStackImpl.getLogWriter().logDebug("Too late to cancel Transaction");
                        }
                        try {
                            sIPServerTransaction.sendResponse((Response)sIPRequest.createResponse(200));
                        }
                        catch (Exception exception) {
                            if (exception.getCause() == null || !(exception.getCause() instanceof IOException)) break block143;
                            ((SIPTransaction)object3).raiseIOExceptionEvent();
                        }
                    }
                    return;
                }
                if (sipStackImpl.isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logDebug("Cancel transaction = " + object3);
                }
            }
            if (sIPServerTransaction != null && object3 != null && ((SIPServerTransaction)object3).getDialog() != null) {
                sIPServerTransaction.setDialog((SIPDialog)((SIPServerTransaction)object3).getDialog(), string2);
                object4 = (SIPDialog)((SIPServerTransaction)object3).getDialog();
            } else if (object3 == null && sipProviderImpl.isAutomaticDialogSupportEnabled() && sIPServerTransaction != null) {
                object2 = sIPRequest.createResponse(481);
                object = sipStackImpl.createServerHeaderForStack();
                ((SIPMessage)object2).addHeader((Header)object);
                if (sipStackImpl.isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logDebug("dropping request -- automatic dialog support enabled and INVITE ST does not exist!");
                }
                try {
                    sipProviderImpl.sendResponse((Response)object2);
                }
                catch (SipException sipException) {
                    InternalErrorHandler.handleException((Exception)((Object)sipException));
                }
                if (sIPServerTransaction != null) {
                    sipStackImpl.removeTransaction(sIPServerTransaction);
                    sIPServerTransaction.releaseSem();
                }
                return;
            }
            if (object3 != null) {
                try {
                    if (sIPServerTransaction != null) {
                        sipStackImpl.addTransaction(sIPServerTransaction);
                        sIPServerTransaction.setPassToListener();
                        sIPServerTransaction.setInviteTransaction((SIPServerTransaction)object3);
                        ((SIPTransaction)object3).acquireSem();
                    }
                }
                catch (Exception exception) {
                    InternalErrorHandler.handleException(exception);
                }
            }
        } else if (sIPRequest.getMethod().equals("INVITE")) {
            Object object5 = object3 = object4 == null ? null : ((SIPDialog)object4).getInviteTransaction();
            if (object4 != null && sIPServerTransaction != null && object3 != null && sIPRequest.getCSeq().getSeqNumber() > ((SIPDialog)object4).getRemoteSeqNumber() && object3 instanceof SIPServerTransaction && ((SIPTransaction)object3).isInviteTransaction() && ((SIPTransaction)object3).getState() != TransactionState.COMPLETED && ((SIPTransaction)object3).getState() != TransactionState.TERMINATED && ((SIPTransaction)object3).getState() != TransactionState.CONFIRMED) {
                if (sipStackImpl.isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logDebug("Sending 500 response for out of sequence message");
                }
                object2 = sIPRequest.createResponse(500);
                object = sipStackImpl.createServerHeaderForStack();
                ((SIPMessage)object2).addHeader((Header)object);
                RetryAfter retryAfter = new RetryAfter();
                try {
                    retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    invalidArgumentException.printStackTrace();
                }
                ((SIPMessage)object2).addHeader(retryAfter);
                try {
                    sIPServerTransaction.sendMessage((SIPMessage)object2);
                }
                catch (IOException iOException) {
                    sIPServerTransaction.raiseIOExceptionEvent();
                }
                return;
            }
            Object object6 = object3 = object4 == null ? null : ((SIPDialog)object4).getLastTransaction();
            if (object4 != null && object3 != null && ((SIPTransaction)object3).isInviteTransaction() && object3 instanceof SIPClientTransaction && ((SIPTransaction)object3).getState() != TransactionState.COMPLETED && ((SIPTransaction)object3).getState() != TransactionState.TERMINATED) {
                if (((SIPDialog)object4).getRemoteSeqNumber() + 1L == sIPRequest.getCSeq().getSeqNumber()) {
                    ((SIPDialog)object4).setRemoteSequenceNumber(sIPRequest.getCSeq().getSeqNumber());
                    if (sipStackImpl.isLoggingEnabled()) {
                        sipStackImpl.getLogWriter().logDebug("Sending 491 response for out of sequence message");
                    }
                    object2 = sIPRequest.createResponse(491);
                    object = sipStackImpl.createServerHeaderForStack();
                    ((SIPMessage)object2).addHeader((Header)object);
                    try {
                        sIPServerTransaction.sendMessage((SIPMessage)object2);
                    }
                    catch (IOException iOException) {
                        sIPServerTransaction.raiseIOExceptionEvent();
                    }
                    ((SIPDialog)object4).requestConsumed();
                } else if (sipStackImpl.isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logDebug("Dropping message -- sequence number is too high!");
                }
                return;
            }
        }
        if (!(object4 == null || sIPServerTransaction == null || sIPRequest.getMethod().equals("BYE") || sIPRequest.getMethod().equals("CANCEL") || sIPRequest.getMethod().equals("ACK") || sIPRequest.getMethod().equals("PRACK"))) {
            if (!((SIPDialog)object4).isRequestConsumable(sIPRequest)) {
                if (sipStackImpl.isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logDebug("Dropping out of sequence message " + ((SIPDialog)object4).getRemoteSeqNumber() + " " + sIPRequest.getCSeq());
                }
                if (((SIPDialog)object4).getRemoteSeqNumber() > sIPRequest.getCSeq().getSeqNumber()) {
                    if (sipStackImpl.isLoggingEnabled()) {
                        sipStackImpl.getLogWriter().logDebug("Sending 500 response for out of sequence message");
                    }
                    object3 = sIPRequest.createResponse(500);
                    ((SIPResponse)object3).setReasonPhrase("Request out of order");
                    object2 = sipStackImpl.createServerHeaderForStack();
                    ((SIPMessage)object3).addHeader((Header)object2);
                    try {
                        sIPServerTransaction.sendMessage((SIPMessage)object3);
                        sipStackImpl.removeTransaction(sIPServerTransaction);
                        sIPServerTransaction.releaseSem();
                    }
                    catch (IOException iOException) {
                        sIPServerTransaction.raiseIOExceptionEvent();
                        sipStackImpl.removeTransaction(sIPServerTransaction);
                    }
                }
                return;
            }
            try {
                if (sipProviderImpl == ((SIPDialog)object4).getSipProvider()) {
                    sipStackImpl.addTransaction(sIPServerTransaction);
                    ((SIPDialog)object4).addTransaction(sIPServerTransaction);
                    ((SIPDialog)object4).addRoute(sIPRequest);
                    sIPServerTransaction.setDialog((SIPDialog)object4, string2);
                }
            }
            catch (IOException iOException) {
                sIPServerTransaction.raiseIOExceptionEvent();
                sipStackImpl.removeTransaction(sIPServerTransaction);
                return;
            }
        }
        if (sipStackImpl.getLogWriter().isLoggingEnabled()) {
            sipStackImpl.getLogWriter().logDebug(sIPRequest.getMethod() + " transaction.isMapped = " + sIPServerTransaction.isTransactionMapped());
        }
        if (object4 == null && sIPRequest.getMethod().equals("NOTIFY")) {
            object2 = sipStackImpl.findSubscribeTransaction(sIPRequest, this.listeningPoint);
            if (sipStackImpl.getLogWriter().isLoggingEnabled()) {
                sipStackImpl.getLogWriter().logDebug("PROCESSING NOTIFY  DIALOG == null " + object2);
            }
            if (sipProviderImpl.isAutomaticDialogSupportEnabled() && object2 == null && !sipStackImpl.deliverUnsolicitedNotify) {
                try {
                    if (sipStackImpl.isLoggingEnabled()) {
                        sipStackImpl.getLogWriter().logDebug("Could not find Subscription for Notify Tx.");
                    }
                    object = sIPRequest.createResponse(481);
                    object.setReasonPhrase("Subscription does not exist");
                    Server server = sipStackImpl.createServerHeaderForStack();
                    object.addHeader((Header)server);
                    sipProviderImpl.sendResponse((Response)object);
                    return;
                }
                catch (Exception exception) {
                    if (exception.getCause() != null && exception.getCause() instanceof IOException) {
                        sipStackImpl.getLogWriter().logDebug("Exception while sending error response statelessly");
                    }
                    InternalErrorHandler.handleException(exception);
                }
            }
            if (object2 != null) {
                sIPServerTransaction.setPendingSubscribe((SIPClientTransaction)object2);
                object = ((SIPClientTransaction)object2).getDefaultDialog();
                if (object == null || ((SIPDialog)object).getDialogId() == null || !((SIPDialog)object).getDialogId().equals(string2)) {
                    Event event;
                    if (object != null && ((SIPDialog)object).getDialogId() == null) {
                        ((SIPDialog)object).setDialogId(string2);
                    } else {
                        object = ((SIPClientTransaction)object2).getDialog(string2);
                    }
                    if (sipStackImpl.getLogWriter().isLoggingEnabled()) {
                        sipStackImpl.getLogWriter().logDebug("PROCESSING NOTIFY Subscribe DIALOG " + object);
                    }
                    if (object == null && (sipProviderImpl.isAutomaticDialogSupportEnabled() || ((SIPClientTransaction)object2).getDefaultDialog() != null) && sipStackImpl.isEventForked((event = (Event)sIPRequest.getHeader("Event")).getEventType())) {
                        object = SIPDialog.createFromNOTIFY((SIPClientTransaction)object2, sIPServerTransaction);
                    }
                    if (object != null) {
                        sIPServerTransaction.setDialog((SIPDialog)object, string2);
                        ((SIPDialog)object).setState(DialogState.CONFIRMED.getValue());
                        sipStackImpl.putDialog((SIPDialog)object);
                        ((SIPClientTransaction)object2).setDialog((SIPDialog)object, string2);
                        if (!sIPServerTransaction.isTransactionMapped()) {
                            this.sipStack.mapTransaction(sIPServerTransaction);
                            sIPServerTransaction.setPassToListener();
                            try {
                                this.sipStack.addTransaction(sIPServerTransaction);
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    sIPServerTransaction.setDialog((SIPDialog)object, string2);
                    object4 = object;
                    if (!sIPServerTransaction.isTransactionMapped()) {
                        this.sipStack.mapTransaction(sIPServerTransaction);
                        sIPServerTransaction.setPassToListener();
                        try {
                            this.sipStack.addTransaction(sIPServerTransaction);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    sipStackImpl.putDialog((SIPDialog)object);
                    if (object2 != null) {
                        ((SIPDialog)object).addTransaction((SIPTransaction)object2);
                        ((SIPClientTransaction)object2).setDialog((SIPDialog)object, string2);
                    }
                }
                object3 = sIPServerTransaction != null && sIPServerTransaction.isTransactionMapped() ? new RequestEvent((Object)sipProviderImpl, (ServerTransaction)sIPServerTransaction, (Dialog)object, (Request)sIPRequest) : new RequestEvent((Object)sipProviderImpl, null, (Dialog)object, (Request)sIPRequest);
            } else {
                if (sipStackImpl.getLogWriter().isLoggingEnabled()) {
                    sipStackImpl.getLogWriter().logDebug("could not find subscribe tx");
                }
                object3 = new RequestEvent((Object)sipProviderImpl, null, null, (Request)sIPRequest);
            }
        } else {
            object3 = sIPServerTransaction != null && sIPServerTransaction.isTransactionMapped() ? new RequestEvent((Object)sipProviderImpl, (ServerTransaction)sIPServerTransaction, (Dialog)object4, (Request)sIPRequest) : new RequestEvent((Object)sipProviderImpl, null, (Dialog)object4, (Request)sIPRequest);
        }
        sipProviderImpl.handleEvent((EventObject)object3, sIPServerTransaction);
    }

    public void processResponse(SIPResponse sIPResponse, MessageChannel messageChannel, SIPDialog sIPDialog) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("PROCESSING INCOMING RESPONSE" + sIPResponse.encodeMessage());
        }
        if (this.listeningPoint == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logError("Dropping message: No listening point registered!");
            }
            return;
        }
        SipProviderImpl sipProviderImpl = this.listeningPoint.getProvider();
        if (sipProviderImpl == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logError("Dropping message:  no provider");
            }
            return;
        }
        if (sipProviderImpl.sipListener == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logError("No listener -- dropping response!");
            }
            return;
        }
        SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)this.transactionChannel;
        SipStackImpl sipStackImpl = sipProviderImpl.sipStack;
        if (this.sipStack.isLoggingEnabled()) {
            sipStackImpl.getLogWriter().logDebug("Transaction = " + sIPClientTransaction);
        }
        if (sIPClientTransaction == null) {
            if (sIPDialog != null) {
                if (sIPResponse.getStatusCode() / 100 != 2) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getLogWriter().logDebug("Response is not a final response and dialog is found for response -- dropping response!");
                    }
                    return;
                }
                if (sIPDialog.getState() == DialogState.TERMINATED) {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getLogWriter().logDebug("Dialog is terminated -- dropping response!");
                    }
                    return;
                }
                if (sIPResponse.getCSeq().getSeqNumber() == sIPDialog.getOriginalLocalSequenceNumber() && sIPResponse.getCSeq().getMethod().equals(sIPDialog.getMethod())) {
                    try {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getLogWriter().logDebug("Retransmission of OK detected: Resending last ACK");
                        }
                        sIPDialog.resendAck();
                        return;
                    }
                    catch (SipException sipException) {
                        this.sipStack.getLogWriter().logError("could not resend ack", (Exception)((Object)sipException));
                    }
                }
            }
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("could not find tx, handling statelessly Dialog = \t" + sIPDialog);
            }
            ResponseEvent responseEvent = new ResponseEvent((Object)sipProviderImpl, (ClientTransaction)sIPClientTransaction, (Dialog)sIPDialog, (Response)sIPResponse);
            sipProviderImpl.handleEvent((EventObject)responseEvent, sIPClientTransaction);
            return;
        }
        ResponseEvent responseEvent = null;
        responseEvent = new ResponseEvent((Object)sipProviderImpl, (ClientTransaction)sIPClientTransaction, (Dialog)sIPDialog, (Response)sIPResponse);
        if (sIPResponse.getToTag() != null && sIPDialog != null && sIPResponse.getStatusCode() != 100) {
            sIPDialog.setLastResponse(sIPClientTransaction, sIPResponse);
            sIPClientTransaction.setDialog(sIPDialog, sIPDialog.getDialogId());
        }
        sipProviderImpl.handleEvent((EventObject)responseEvent, sIPClientTransaction);
    }

    public String getProcessingInfo() {
        return null;
    }

    public void processResponse(SIPResponse sIPResponse, MessageChannel messageChannel) {
        String string;
        String string2 = sIPResponse.getDialogId(false);
        SIPDialog sIPDialog = this.sipStack.getDialog(string2);
        String string3 = sIPResponse.getCSeq().getMethod();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("PROCESSING INCOMING RESPONSE: " + sIPResponse.encodeMessage());
        }
        if (this.listeningPoint == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("Dropping message: No listening point registered!");
            }
            return;
        }
        SipProviderImpl sipProviderImpl = this.listeningPoint.getProvider();
        if (sipProviderImpl == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("Dropping message:  no provider");
            }
            return;
        }
        if (sipProviderImpl.sipListener == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("Dropping message:  no sipListener registered!");
            }
            return;
        }
        SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)this.transactionChannel;
        if (sIPDialog == null && sIPClientTransaction != null && (sIPDialog = sIPClientTransaction.getDialog(string2)) != null && sIPDialog.getState() == DialogState.TERMINATED) {
            sIPDialog = null;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("Transaction = " + sIPClientTransaction + " sipDialog = " + sIPDialog);
        }
        if (this.transactionChannel != null) {
            string = ((SIPRequest)this.transactionChannel.getRequest()).getFromTag();
            if (string == null ^ sIPResponse.getFrom().getTag() == null) {
                this.sipStack.getLogWriter().logDebug("From tag mismatch -- dropping response");
                return;
            }
            if (string != null && !string.equalsIgnoreCase(sIPResponse.getFrom().getTag())) {
                this.sipStack.getLogWriter().logDebug("From tag mismatch -- dropping response");
                return;
            }
        }
        if (this.sipStack.isDialogCreated(string3) && sIPResponse.getStatusCode() != 100 && sIPResponse.getFrom().getTag() != null && sIPResponse.getTo().getTag() != null && sIPDialog == null) {
            if (sipProviderImpl.isAutomaticDialogSupportEnabled()) {
                if (this.transactionChannel != null) {
                    if (sIPDialog == null) {
                        sIPDialog = new SIPDialog(this.transactionChannel, sIPResponse);
                        this.transactionChannel.setDialog(sIPDialog, sIPResponse.getDialogId(false));
                    }
                } else {
                    sIPDialog = new SIPDialog(sipProviderImpl, sIPResponse);
                }
            }
        } else if (sIPDialog != null && sIPClientTransaction == null) {
            if (sIPResponse.getStatusCode() / 100 != 2) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getLogWriter().logDebug("staus code != 200 ; statusCode = " + sIPResponse.getStatusCode());
                }
                return;
            }
            if (sIPDialog.getState() == DialogState.TERMINATED) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getLogWriter().logDebug("Dialog is terminated -- dropping response!");
                }
                return;
            }
            if (sIPResponse.getCSeq().getSeqNumber() == sIPDialog.getOriginalLocalSequenceNumber() && sIPResponse.getCSeq().getMethod().equals(sIPDialog.getMethod()) && sIPDialog.isAckSeen()) {
                try {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getLogWriter().logDebug("resending ACK");
                    }
                    sIPDialog.resendAck();
                    return;
                }
                catch (SipException sipException) {
                    // empty catch block
                }
            }
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("sending response to TU for processing ");
        }
        if (sIPDialog != null && sIPResponse.getStatusCode() != 100 && sIPResponse.getTo().getTag() != null) {
            sIPDialog.setLastResponse(sIPClientTransaction, sIPResponse);
        }
        string = new ResponseEvent((Object)sipProviderImpl, (ClientTransaction)sIPClientTransaction, (Dialog)sIPDialog, (Response)sIPResponse);
        sipProviderImpl.handleEvent((EventObject)((Object)string), sIPClientTransaction);
    }
}

