/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.RAck;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.Require;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.address.Address;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.Header;
import javax.sip.header.OptionTag;
import javax.sip.header.RequireHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class SIPDialog
implements Dialog {
    private static final long serialVersionUID = -1429794423085204069L;
    private boolean dialogTerminatedEventDelivered;
    private String method;
    private boolean isAssigned;
    private boolean reInviteFlag;
    private Object applicationData;
    private SIPRequest originalRequest;
    private SIPResponse lastResponse;
    private SIPTransaction firstTransaction;
    private SIPTransaction lastTransaction;
    private String dialogId;
    private long localSequenceNumber;
    private long remoteSequenceNumber;
    private String myTag;
    private String hisTag;
    private RouteList routeList;
    private SIPTransactionStack sipStack;
    private int dialogState;
    private boolean ackSeen;
    protected SIPRequest lastAck;
    protected boolean ackProcessed;
    protected DialogTimerTask timerTask;
    protected Long nextSeqno;
    private int retransmissionTicksLeft;
    private int prevRetransmissionTicks;
    private long originalLocalSequenceNumber;
    private int ackLine;
    public long auditTag = 0L;
    private Address localParty;
    private Address remoteParty;
    protected CallIdHeader callIdHeader;
    public static final int EARLY_STATE = 0;
    public static final int CONFIRMED_STATE = 1;
    public static final int TERMINATED_STATE = 3;
    private static final int DIALOG_LINGER_TIME = 8;
    private boolean serverTransactionFlag;
    private SipProviderImpl sipProvider;
    private boolean terminateOnBye;
    private boolean byeSent;
    private Address remoteTarget;
    private EventHeader eventHeader;

    private SIPDialog() {
        this.terminateOnBye = true;
        this.routeList = new RouteList();
        this.dialogState = -1;
        this.localSequenceNumber = 0L;
        this.remoteSequenceNumber = -1L;
    }

    public SIPDialog(SIPTransaction sIPTransaction) {
        this();
        if (sIPTransaction == null) {
            throw new NullPointerException("Null tx");
        }
        this.sipStack = sIPTransaction.sipStack;
        this.sipProvider = sIPTransaction.getSipProvider();
        if (this.sipProvider == null) {
            throw new NullPointerException("Null Provider!");
        }
        this.addTransaction(sIPTransaction);
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Creating a dialog : " + this);
            this.sipStack.logWriter.logDebug("provider port = " + this.sipProvider.getListeningPoint().getPort());
            this.sipStack.logWriter.logStackTrace();
        }
    }

    public SIPDialog(SIPTransaction sIPTransaction, SIPResponse sIPResponse) {
        this(sIPTransaction);
        if (sIPResponse == null) {
            throw new NullPointerException("Null SipResponse");
        }
        this.setLastResponse(sIPTransaction, sIPResponse);
    }

    public SIPDialog(SipProviderImpl sipProviderImpl, SIPResponse sIPResponse) {
        this.sipProvider = sipProviderImpl;
        this.sipStack = (SIPTransactionStack)sipProviderImpl.getSipStack();
        this.setLastResponse(null, sIPResponse);
        this.originalLocalSequenceNumber = this.localSequenceNumber = sIPResponse.getCSeq().getSeqNumber();
        this.myTag = sIPResponse.getFrom().getTag();
        this.hisTag = sIPResponse.getTo().getTag();
        this.localParty = sIPResponse.getFrom().getAddress();
        this.remoteParty = sIPResponse.getTo().getAddress();
        this.method = sIPResponse.getCSeq().getMethod();
        this.callIdHeader = sIPResponse.getCallId();
        this.serverTransactionFlag = false;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Creating a dialog : " + this);
            this.sipStack.logWriter.logStackTrace();
        }
    }

    private void printRouteList() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("this : " + this);
            this.sipStack.logWriter.logDebug("printRouteList : " + this.routeList.encode());
        }
    }

    private boolean isClientDialog() {
        SIPTransaction sIPTransaction = (SIPTransaction)this.getFirstTransaction();
        return sIPTransaction instanceof SIPClientTransaction;
    }

    private void raiseIOException(String string, int n, String string2) {
        IOExceptionEvent iOExceptionEvent = new IOExceptionEvent((Object)this, string, n, string2);
        this.sipProvider.handleEvent((EventObject)iOExceptionEvent, null);
        this.setState(3);
    }

    private void setRemoteParty(SIPMessage sIPMessage) {
        this.remoteParty = !this.isServer() ? sIPMessage.getTo().getAddress() : sIPMessage.getFrom().getAddress();
        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("settingRemoteParty " + this.remoteParty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRoute(RecordRouteList recordRouteList) {
        Iterator iterator;
        try {
            AddressImpl addressImpl;
            Route route;
            RecordRoute recordRoute;
            boolean bl;
            if (this.isClientDialog()) {
                this.routeList = new RouteList();
                iterator = recordRouteList.listIterator(recordRouteList.size());
                bl = true;
                while (iterator.hasPrevious()) {
                    recordRoute = (RecordRoute)iterator.previous();
                    if (!bl) continue;
                    route = new Route();
                    addressImpl = (AddressImpl)((AddressImpl)recordRoute.getAddress()).clone();
                    route.setAddress(addressImpl);
                    route.setParameters((NameValueList)recordRoute.getParameters().clone());
                    this.routeList.add(route);
                }
            } else {
                this.routeList = new RouteList();
                iterator = recordRouteList.listIterator();
                bl = true;
                while (iterator.hasNext()) {
                    recordRoute = (RecordRoute)iterator.next();
                    if (!bl) continue;
                    route = new Route();
                    addressImpl = (AddressImpl)((AddressImpl)recordRoute.getAddress()).clone();
                    route.setAddress(addressImpl);
                    route.setParameters((NameValueList)recordRoute.getParameters().clone());
                    this.routeList.add(route);
                }
            }
        }
        finally {
            if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                iterator = this.routeList.iterator();
                while (iterator.hasNext()) {
                    SipURI sipURI = (SipURI)((Route)iterator.next()).getAddress().getURI();
                    if (sipURI.hasLrParam()) continue;
                    this.sipStack.getLogWriter().logWarning("NON LR route in Route set detected for dialog : " + this);
                    this.sipStack.getLogWriter().logStackTrace();
                }
            }
        }
    }

    private void setRemoteTarget(ContactHeader contactHeader) {
        this.remoteTarget = contactHeader.getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addRoute(SIPResponse sIPResponse) {
        try {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("setContact: dialogState: " + this + "state = " + this.getState());
            }
            if (sIPResponse.getStatusCode() == 100) {
                return;
            }
            if (this.dialogState == 3) {
                return;
            }
            if (this.dialogState == 1) {
                ContactList contactList;
                if (sIPResponse.getStatusCode() / 100 == 2 && !this.isServer() && (contactList = sIPResponse.getContactHeaders()) != null && SIPRequest.isTargetRefresh(sIPResponse.getCSeq().getMethod())) {
                    this.setRemoteTarget((ContactHeader)contactList.getFirst());
                }
                return;
            }
            if (!this.isServer()) {
                RecordRouteList recordRouteList = sIPResponse.getRecordRouteHeaders();
                if (recordRouteList != null) {
                    this.addRoute(recordRouteList);
                } else {
                    this.routeList = new RouteList();
                }
                ContactList contactList = sIPResponse.getContactHeaders();
                if (contactList != null) {
                    this.setRemoteTarget((ContactHeader)contactList.getFirst());
                }
            }
        }
        finally {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logStackTrace();
            }
        }
    }

    private synchronized RouteList getRouteList() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("getRouteList " + this);
        }
        RouteList routeList = new RouteList();
        routeList = new RouteList();
        if (this.routeList != null) {
            ListIterator listIterator = this.routeList.listIterator();
            while (listIterator.hasNext()) {
                Route route = (Route)listIterator.next();
                routeList.add((Route)route.clone());
            }
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("----- ");
            this.sipStack.logWriter.logDebug("getRouteList for " + this);
            if (routeList != null) {
                this.sipStack.logWriter.logDebug("RouteList = " + routeList.encode());
            }
            if (this.routeList != null) {
                this.sipStack.logWriter.logDebug("myRouteList = " + this.routeList.encode());
            }
            this.sipStack.logWriter.logDebug("----- ");
        }
        return routeList;
    }

    private void sendAck(Request request, boolean bl) throws SipException {
        SIPRequest sIPRequest = (SIPRequest)request;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("sendAck" + this);
        }
        if (!sIPRequest.getMethod().equals("ACK")) {
            throw new SipException("Bad request method -- should be ACK");
        }
        if (this.getState() == null || this.getState().getValue() == 0) {
            if (this.sipStack.logWriter.isLoggingEnabled()) {
                this.sipStack.logWriter.logError("Bad Dialog State for " + this + " dialogID = " + this.getDialogId());
            }
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (!this.getCallId().getCallId().equals(((SIPRequest)request).getCallId().getCallId())) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logError("CallID " + this.getCallId());
                this.sipStack.logWriter.logError("RequestCallID = " + sIPRequest.getCallId().getCallId());
                this.sipStack.logWriter.logError("dialog =  " + this);
            }
            throw new SipException("Bad call ID in request");
        }
        try {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("setting from tag For outgoing ACK= " + this.getLocalTag());
                this.sipStack.logWriter.logDebug("setting To tag for outgoing ACK = " + this.getRemoteTag());
                this.sipStack.logWriter.logDebug("ack = " + sIPRequest);
            }
            if (this.getLocalTag() != null) {
                sIPRequest.getFrom().setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                sIPRequest.getTo().setTag(this.getRemoteTag());
            }
        }
        catch (ParseException parseException) {
            throw new SipException(parseException.getMessage());
        }
        Hop hop = this.sipStack.getNextHop(sIPRequest);
        if (hop == null) {
            throw new SipException("No route!");
        }
        try {
            ListeningPointImpl listeningPointImpl;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("hop = " + hop);
            }
            if ((listeningPointImpl = (ListeningPointImpl)this.sipProvider.getListeningPoint(hop.getTransport())) == null) {
                throw new SipException("No listening point for this provider registered at " + hop);
            }
            InetAddress inetAddress = InetAddress.getByName(hop.getHost());
            MessageChannel messageChannel = listeningPointImpl.getMessageProcessor().createMessageChannel(inetAddress, hop.getPort());
            this.lastAck = sIPRequest;
            messageChannel.sendMessage(sIPRequest);
        }
        catch (IOException iOException) {
            if (bl) {
                throw new SipException("Could not send ack", (Throwable)iOException);
            }
            this.raiseIOException(hop.getHost(), hop.getPort(), hop.getTransport());
        }
        catch (SipException sipException) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logException(sipException);
            }
            throw sipException;
        }
        catch (Exception exception) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logException(exception);
            }
            throw new SipException("Could not create message channel", (Throwable)exception);
        }
        this.ackSeen = true;
    }

    void setStack(SIPTransactionStack sIPTransactionStack) {
        this.sipStack = sIPTransactionStack;
    }

    boolean isTerminatedOnBye() {
        return this.terminateOnBye;
    }

    void ackReceived(SIPRequest sIPRequest) {
        if (this.ackSeen) {
            return;
        }
        SIPServerTransaction sIPServerTransaction = this.getInviteTransaction();
        if (sIPServerTransaction != null && sIPServerTransaction.getCSeq() == sIPRequest.getCSeq().getSeqNumber()) {
            this.ackSeen = true;
            this.lastAck = sIPRequest;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("ackReceived for " + sIPServerTransaction.getMethod());
                this.ackLine = this.sipStack.logWriter.getLineCount();
                this.printDebugInfo();
            }
            this.setState(1);
        }
    }

    synchronized boolean testAndSetIsDialogTerminatedEventDelivered() {
        boolean bl = this.dialogTerminatedEventDelivered;
        this.dialogTerminatedEventDelivered = true;
        return bl;
    }

    public void setApplicationData(Object object) {
        this.applicationData = object;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public synchronized void requestConsumed() {
        this.nextSeqno = new Long(this.getRemoteSeqNumber() + 1L);
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Request Consumed -- next consumable Request Seqno = " + this.nextSeqno);
        }
    }

    public synchronized boolean isRequestConsumable(SIPRequest sIPRequest) {
        if (sIPRequest.getMethod().equals("ACK")) {
            throw new RuntimeException("Illegal method");
        }
        return this.remoteSequenceNumber < sIPRequest.getCSeq().getSeqNumber();
    }

    public void doDeferredDelete() {
        if (this.sipStack.timer == null) {
            this.setState(3);
        } else {
            this.sipStack.timer.schedule((TimerTask)new DialogDeleteTask(), 32000L);
        }
    }

    public void setState(int n) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Setting dialog state for " + this + "newState = " + n);
            this.sipStack.logWriter.logStackTrace();
            if (n != -1 && n != this.dialogState && this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug(this + "  old dialog state is " + this.getState());
                this.sipStack.logWriter.logDebug(this + "  New dialog state is " + DialogState.getObject((int)n));
            }
        }
        this.dialogState = n;
        if (n == 3) {
            if (this.sipStack.timer != null) {
                this.sipStack.timer.schedule((TimerTask)new LingerTimer(), 8000L);
            }
            this.stopTimer();
        }
    }

    public void printDebugInfo() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("isServer = " + this.isServer());
            this.sipStack.logWriter.logDebug("localTag = " + this.getLocalTag());
            this.sipStack.logWriter.logDebug("remoteTag = " + this.getRemoteTag());
            this.sipStack.logWriter.logDebug("localSequenceNumer = " + this.getLocalSeqNumber());
            this.sipStack.logWriter.logDebug("remoteSequenceNumer = " + this.getRemoteSeqNumber());
            this.sipStack.logWriter.logDebug("ackLine:" + this.getRemoteTag() + " " + this.ackLine);
        }
    }

    public boolean isAckSeen() {
        return this.ackSeen;
    }

    public SIPRequest getLastAck() {
        return this.lastAck;
    }

    public Transaction getFirstTransaction() {
        return this.firstTransaction;
    }

    public Iterator getRouteSet() {
        if (this.routeList == null) {
            return new LinkedList().listIterator();
        }
        return this.getRouteList().listIterator();
    }

    public synchronized void addRoute(SIPRequest sIPRequest) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("setContact: dialogState: " + this + "state = " + this.getState());
        }
        if (this.dialogState == 1 || this.dialogState == 3) {
            return;
        }
        RecordRouteList recordRouteList = sIPRequest.getRecordRouteHeaders();
        if (recordRouteList != null) {
            this.addRoute(recordRouteList);
        } else {
            this.routeList = new RouteList();
        }
        ContactList contactList = sIPRequest.getContactHeaders();
        if (contactList != null) {
            this.setRemoteTarget((ContactHeader)contactList.getFirst());
        }
    }

    public void setDialogId(String string) {
        this.dialogId = string;
    }

    public static SIPDialog createFromNOTIFY(SIPClientTransaction sIPClientTransaction, SIPTransaction sIPTransaction) {
        SIPDialog sIPDialog = new SIPDialog(sIPTransaction);
        sIPDialog.serverTransactionFlag = false;
        sIPDialog.firstTransaction = sIPDialog.lastTransaction = sIPClientTransaction;
        sIPDialog.terminateOnBye = false;
        sIPDialog.localSequenceNumber = sIPDialog.firstTransaction.getCSeq();
        SIPRequest sIPRequest = (SIPRequest)sIPTransaction.getRequest();
        sIPDialog.remoteSequenceNumber = sIPRequest.getCSeq().getSeqNumber();
        sIPDialog.setDialogId(sIPRequest.getDialogId(true));
        sIPDialog.setLocalTag(sIPRequest.getToTag());
        sIPDialog.setRemoteTag(sIPRequest.getFromTag());
        sIPDialog.localParty = sIPRequest.getTo().getAddress();
        sIPDialog.remoteParty = sIPRequest.getFrom().getAddress();
        sIPDialog.addRoute(sIPRequest);
        sIPDialog.setState(1);
        return sIPDialog;
    }

    public boolean isServer() {
        if (this.firstTransaction == null) {
            return this.serverTransactionFlag;
        }
        return this.firstTransaction instanceof SIPServerTransaction;
    }

    protected boolean isReInvite() {
        return this.reInviteFlag;
    }

    public String getDialogId() {
        if (this.dialogId == null && this.lastResponse != null) {
            this.dialogId = this.lastResponse.getDialogId(this.isServer());
        }
        return this.dialogId;
    }

    public void addTransaction(SIPTransaction sIPTransaction) {
        SIPRequest sIPRequest = sIPTransaction.getOriginalRequest();
        if (this.firstTransaction != null && this.firstTransaction != sIPTransaction && sIPTransaction.getMethod().equals(this.firstTransaction.getMethod())) {
            this.reInviteFlag = true;
        }
        if (this.firstTransaction == null) {
            this.firstTransaction = sIPTransaction;
            if (sIPRequest.getMethod().equals("SUBSCRIBE")) {
                this.eventHeader = (EventHeader)sIPRequest.getHeader("Event");
            }
            this.setLocalParty(sIPRequest);
            this.setRemoteParty(sIPRequest);
            this.setCallId(sIPRequest);
            this.originalRequest = sIPRequest;
            this.method = sIPRequest.getMethod();
            if (sIPTransaction instanceof SIPServerTransaction) {
                this.hisTag = sIPRequest.getFrom().getTag();
            } else {
                this.setLocalSequenceNumber(sIPRequest.getCSeq().getSeqNumber());
                this.originalLocalSequenceNumber = this.localSequenceNumber;
                this.myTag = sIPRequest.getFrom().getTag();
                if (this.myTag == null) {
                    this.sipStack.getLogWriter().logError("The request's From header is missing the required Tag parameter.");
                }
            }
        } else if (sIPTransaction.getMethod().equals(this.firstTransaction.getMethod()) && !this.firstTransaction.getClass().equals(sIPTransaction.getClass())) {
            this.firstTransaction = sIPTransaction;
            this.setLocalParty(sIPRequest);
            this.setRemoteParty(sIPRequest);
            this.setCallId(sIPRequest);
            this.originalRequest = sIPRequest;
            this.method = sIPRequest.getMethod();
        }
        if (sIPTransaction instanceof SIPServerTransaction) {
            this.setRemoteSequenceNumber(sIPRequest.getCSeq().getSeqNumber());
        }
        this.lastTransaction = sIPTransaction;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Transaction Added " + this + this.myTag + "/" + this.hisTag);
            this.sipStack.logWriter.logDebug("TID = " + sIPTransaction.getTransactionId() + "/" + sIPTransaction.IsServerTransaction());
            this.sipStack.logWriter.logStackTrace();
        }
    }

    private void setRemoteTag(String string) {
        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("setRemoteTag(): " + this + " remoteTag = " + this.hisTag + " new tag = " + string);
        }
        if (this.hisTag != null && !string.equals(this.hisTag)) {
            InternalErrorHandler.handleException("Unexpected tag " + this.hisTag + " trying to set to " + string, this.sipStack.getLogWriter());
        }
        this.hisTag = string;
    }

    public SIPTransaction getLastTransaction() {
        return this.lastTransaction;
    }

    public SIPServerTransaction getInviteTransaction() {
        DialogTimerTask dialogTimerTask = this.timerTask;
        if (dialogTimerTask != null) {
            return dialogTimerTask.transaction;
        }
        return null;
    }

    private void setLocalSequenceNumber(long l) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("setLocalSequenceNumber: original \t" + this.localSequenceNumber + " new  = " + l);
        }
        if (l <= this.localSequenceNumber) {
            throw new RuntimeException("Sequence number should not decrease !");
        }
        this.localSequenceNumber = l;
    }

    public void setRemoteSequenceNumber(long l) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("setRemoteSeqno " + this + "/" + l);
        }
        this.remoteSequenceNumber = l;
    }

    public void incrementLocalSequenceNumber() {
        ++this.localSequenceNumber;
    }

    public int getRemoteSequenceNumber() {
        return (int)this.remoteSequenceNumber;
    }

    public int getLocalSequenceNumber() {
        return (int)this.localSequenceNumber;
    }

    public long getOriginalLocalSequenceNumber() {
        return this.originalLocalSequenceNumber;
    }

    public long getLocalSeqNumber() {
        return this.localSequenceNumber;
    }

    public long getRemoteSeqNumber() {
        return this.remoteSequenceNumber;
    }

    public String getLocalTag() {
        return this.myTag;
    }

    public String getRemoteTag() {
        return this.hisTag;
    }

    private void setLocalTag(String string) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("set Local tag " + string + " " + this.dialogId);
            this.sipStack.logWriter.logStackTrace();
        }
        this.myTag = string;
    }

    public void delete() {
        this.setState(3);
    }

    public CallIdHeader getCallId() {
        return this.callIdHeader;
    }

    private void setCallId(SIPRequest sIPRequest) {
        this.callIdHeader = sIPRequest.getCallId();
    }

    public Address getLocalParty() {
        return this.localParty;
    }

    private void setLocalParty(SIPMessage sIPMessage) {
        this.localParty = !this.isServer() ? sIPMessage.getFrom().getAddress() : sIPMessage.getTo().getAddress();
    }

    public Address getRemoteParty() {
        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("gettingRemoteParty " + this.remoteParty);
        }
        return this.remoteParty;
    }

    public Address getRemoteTarget() {
        return this.remoteTarget;
    }

    public DialogState getState() {
        if (this.dialogState == -1) {
            return null;
        }
        return DialogState.getObject((int)this.dialogState);
    }

    public boolean isSecure() {
        return this.getFirstTransaction().getRequest().getRequestURI().getScheme().equalsIgnoreCase("sips");
    }

    public void sendAck(Request request) throws SipException {
        this.sendAck(request, true);
    }

    public Request createRequest(String string) throws SipException {
        if (this.lastResponse != null) {
            return this.createRequest(string, this.lastResponse);
        }
        throw new SipException("Dialog not yet established -- no response!");
    }

    private Request createRequest(String string, SIPResponse sIPResponse) throws SipException {
        if (string == null || sIPResponse == null) {
            throw new NullPointerException("null argument");
        }
        if (string.equals("CANCEL")) {
            throw new SipException("Dialog.createRequest(): Invalid request");
        }
        if (string == null) {
            throw new NullPointerException("null method");
        }
        if (this.getState() == null || this.getState().getValue() == 3 && !string.equalsIgnoreCase("BYE") || this.isServer() && this.getState().getValue() == 0 && string.equalsIgnoreCase("BYE")) {
            throw new SipException("Dialog  " + this.getDialogId() + " not yet established or terminated " + this.getState());
        }
        SipUri sipUri = null;
        if (this.getRemoteTarget() != null) {
            sipUri = (SipUri)this.getRemoteTarget().getURI().clone();
        } else {
            sipUri = (SipUri)this.getRemoteParty().getURI().clone();
            sipUri.clearUriParms();
        }
        CSeq cSeq = new CSeq();
        try {
            cSeq.setMethod(string);
            cSeq.setSeqNumber(this.getLocalSeqNumber());
        }
        catch (Exception exception) {
            this.sipStack.getLogWriter().logError("Unexpected error");
            InternalErrorHandler.handleException(exception);
        }
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)this.sipProvider.getListeningPoint(sIPResponse.getTopmostVia().getTransport());
        if (listeningPointImpl == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logError("Cannot find listening point for transport " + sIPResponse.getTopmostVia().getTransport());
            }
            throw new SipException("Cannot find listening point for transport " + sIPResponse.getTopmostVia().getTransport());
        }
        Via via = listeningPointImpl.getViaHeader();
        From from = (From)this.lastResponse.getFrom().clone();
        from.setAddress(this.localParty);
        To to = (To)this.lastResponse.getTo().clone();
        to.setAddress(this.remoteParty);
        SIPRequest sIPRequest = sIPResponse.createRequest(sipUri, via, cSeq, from, to);
        if (SIPRequest.isTargetRefresh(string)) {
            ContactHeader contactHeader = this.sipProvider.createContactForProvider(listeningPointImpl.getTransport());
            ((SipURI)contactHeader.getAddress().getURI()).setSecure(this.isSecure());
            sIPRequest.setHeader((Header)contactHeader);
        }
        try {
            if (!string.equals("ACK")) {
                cSeq = (CSeq)sIPRequest.getCSeq();
                cSeq.setSeqNumber(this.localSequenceNumber + 1L);
            } else {
                long l = this.lastResponse.getCSeq().getSeqNumber();
                cSeq.setSeqNumber(l);
            }
        }
        catch (InvalidArgumentException invalidArgumentException) {
            InternalErrorHandler.handleException((Exception)((Object)invalidArgumentException));
        }
        if (string.equals("SUBSCRIBE") && this.eventHeader != null) {
            sIPRequest.addHeader((Header)this.eventHeader);
        }
        try {
            if (this.getLocalTag() != null) {
                from.setTag(this.getLocalTag());
            } else {
                from.removeTag();
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            } else {
                to.removeTag();
            }
        }
        catch (ParseException parseException) {
            InternalErrorHandler.handleException(parseException);
        }
        this.updateRequest(sIPRequest);
        return sIPRequest;
    }

    public void sendRequest(ClientTransaction clientTransaction) throws TransactionDoesNotExistException, SipException {
        ParametersHeader parametersHeader;
        SIPRequest sIPRequest = ((SIPClientTransaction)clientTransaction).getOriginalRequest();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("dialog.sendRequest  dialog = " + this + "\ndialogRequest = \n" + sIPRequest);
        }
        if (clientTransaction == null) {
            throw new NullPointerException("null parameter");
        }
        if (sIPRequest.getMethod().equals("ACK") || sIPRequest.getMethod().equals("CANCEL")) {
            throw new SipException("Bad Request Method. " + sIPRequest.getMethod());
        }
        if (!(this.getState() != null || this.getMethod().equals("SUBSCRIBE") && sIPRequest.getMethod().equals("NOTIFY"))) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logError("null dialog state for " + this);
            }
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (this.byeSent && this.isTerminatedOnBye() && !sIPRequest.getMethod().equals("BYE")) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logError("BYE already sent for " + this);
            }
            throw new SipException("Cannot send request; BYE already sent");
        }
        if (sIPRequest.getTopmostVia() == null) {
            parametersHeader = ((SIPClientTransaction)clientTransaction).getOutgoingViaHeader();
            sIPRequest.addHeader(parametersHeader);
        }
        if (!this.getCallId().getCallId().equalsIgnoreCase(sIPRequest.getCallId().getCallId())) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logError("CallID " + this.getCallId());
                this.sipStack.logWriter.logError("RequestCallID = " + sIPRequest.getCallId().getCallId());
                this.sipStack.logWriter.logError("dialog =  " + this);
            }
            throw new SipException("Bad call ID in request");
        }
        ((SIPClientTransaction)clientTransaction).setDialog(this, this.dialogId);
        this.addTransaction((SIPTransaction)clientTransaction);
        ((SIPClientTransaction)clientTransaction).isMapped = true;
        parametersHeader = (From)sIPRequest.getFrom();
        To to = (To)sIPRequest.getTo();
        if (this.getLocalTag() != null && ((From)parametersHeader).getTag() != null && !((From)parametersHeader).getTag().equals(this.getLocalTag())) {
            throw new SipException("From tag mismatch expecting\t " + this.getLocalTag());
        }
        if (this.getRemoteTag() != null && to.getTag() != null && !to.getTag().equals(this.getRemoteTag())) {
            throw new SipException("To header tag mismatch expecting " + this.getRemoteTag());
        }
        if (this.getLocalTag() == null && sIPRequest.getMethod().equals("NOTIFY")) {
            if (!this.getMethod().equals("SUBSCRIBE")) {
                throw new SipException("Trying to send NOTIFY without SUBSCRIBE Dialog!");
            }
            this.setLocalTag(((From)parametersHeader).getTag());
        }
        try {
            if (this.getLocalTag() != null) {
                ((From)parametersHeader).setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            }
        }
        catch (ParseException parseException) {
            InternalErrorHandler.handleException(parseException);
        }
        Hop hop = ((SIPClientTransaction)clientTransaction).getNextHop();
        try {
            TCPMessageChannel tCPMessageChannel = null;
            TLSMessageChannel tLSMessageChannel = null;
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress(), this.firstTransaction.getPort(), hop);
            if (((SIPClientTransaction)clientTransaction).getMessageChannel() instanceof TCPMessageChannel) {
                tCPMessageChannel = (TCPMessageChannel)((SIPClientTransaction)clientTransaction).getMessageChannel();
                if (tCPMessageChannel.isCached && !tCPMessageChannel.isRunning) {
                    tCPMessageChannel.uncache();
                }
                if (!this.sipStack.cacheClientConnections) {
                    --tCPMessageChannel.useCount;
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.logWriter.logDebug("oldChannel: useCount " + tCPMessageChannel.useCount);
                    }
                }
            } else if (((SIPClientTransaction)clientTransaction).getMessageChannel() instanceof TLSMessageChannel) {
                tLSMessageChannel = (TLSMessageChannel)((SIPClientTransaction)clientTransaction).getMessageChannel();
                if (tLSMessageChannel.isCached && !tLSMessageChannel.isRunning) {
                    tLSMessageChannel.uncache();
                }
                if (!this.sipStack.cacheClientConnections) {
                    --tLSMessageChannel.useCount;
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.logWriter.logDebug("oldChannel: useCount " + tLSMessageChannel.useCount);
                    }
                }
            }
            if (messageChannel == null) {
                Hop hop2;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("Null message channel using outbound proxy !");
                }
                if ((hop2 = this.sipStack.getRouter(sIPRequest).getOutboundProxy()) == null) {
                    throw new SipException("No route found! hop=" + hop);
                }
                messageChannel = this.sipStack.createRawMessageChannel(this.getSipProvider().getListeningPoint(hop2.getTransport()).getIPAddress(), this.firstTransaction.getPort(), hop2);
                if (messageChannel != null) {
                    ((SIPClientTransaction)clientTransaction).setEncapsulatedChannel(messageChannel);
                }
            } else {
                ((SIPClientTransaction)clientTransaction).setEncapsulatedChannel(messageChannel);
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("using message channel " + messageChannel);
                }
            }
            if (messageChannel != null && messageChannel instanceof TCPMessageChannel) {
                ++((TCPMessageChannel)messageChannel).useCount;
            }
            if (messageChannel != null && messageChannel instanceof TLSMessageChannel) {
                ++((TLSMessageChannel)messageChannel).useCount;
            }
            if (!this.sipStack.cacheClientConnections && tCPMessageChannel != null && tCPMessageChannel.useCount <= 0) {
                tCPMessageChannel.close();
            }
            if (!this.sipStack.cacheClientConnections && tLSMessageChannel != null && tLSMessageChannel.useCount == 0) {
                tLSMessageChannel.close();
            }
        }
        catch (Exception exception) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logException(exception);
            }
            throw new SipException("Could not create message channel", (Throwable)exception);
        }
        try {
            ++this.localSequenceNumber;
            sIPRequest.getCSeq().setSeqNumber(this.getLocalSeqNumber());
        }
        catch (InvalidArgumentException invalidArgumentException) {
            invalidArgumentException.printStackTrace();
        }
        try {
            ((SIPClientTransaction)clientTransaction).sendMessage(sIPRequest);
            if (sIPRequest.getMethod().equals("BYE")) {
                this.byeSent = true;
            }
        }
        catch (IOException iOException) {
            throw new SipException("error sending message", (Throwable)iOException);
        }
    }

    private boolean toRetransmitFinalResponse(int n) {
        if (--this.retransmissionTicksLeft == 0) {
            this.retransmissionTicksLeft = 2 * this.prevRetransmissionTicks <= n ? 2 * this.prevRetransmissionTicks : this.prevRetransmissionTicks;
            this.prevRetransmissionTicks = this.retransmissionTicksLeft;
            return true;
        }
        return false;
    }

    protected void setRetransmissionTicks() {
        this.retransmissionTicksLeft = 1;
        this.prevRetransmissionTicks = 1;
    }

    public void resendAck() throws SipException {
        if (this.lastAck != null) {
            if (this.lastAck.getHeader("Timestamp") != null && this.sipStack.generateTimeStampHeader) {
                TimeStamp timeStamp = new TimeStamp();
                try {
                    timeStamp.setTimeStamp(System.currentTimeMillis());
                    this.lastAck.setHeader(timeStamp);
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    // empty catch block
                }
            }
            this.sendAck(this.lastAck, false);
        }
    }

    public String getMethod() {
        return this.method;
    }

    protected void startTimer(SIPServerTransaction sIPServerTransaction) {
        if (this.timerTask != null && this.timerTask.transaction == sIPServerTransaction) {
            this.sipStack.getLogWriter().logDebug("Timer already running for " + this.getDialogId());
            return;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("Starting dialog timer for " + this.getDialogId());
        }
        this.ackSeen = false;
        if (this.timerTask != null) {
            this.timerTask.transaction = sIPServerTransaction;
        } else {
            this.timerTask = new DialogTimerTask(sIPServerTransaction);
            this.sipStack.timer.schedule((TimerTask)this.timerTask, 500L, 500L);
        }
        this.setRetransmissionTicks();
    }

    protected void stopTimer() {
        try {
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
            this.timerTask = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Request createPrack(Response response) throws DialogDoesNotExistException, SipException {
        if (this.getState() == null || this.getState().equals((Object)DialogState.TERMINATED)) {
            throw new DialogDoesNotExistException("Dialog not initialized or terminated");
        }
        try {
            SIPResponse sIPResponse = (SIPResponse)response;
            SIPRequest sIPRequest = (SIPRequest)this.createRequest("PRACK", (SIPResponse)response);
            String string = sIPResponse.getTo().getTag();
            sIPRequest.setToTag(string);
            RAck rAck = new RAck();
            RSeq rSeq = (RSeq)response.getHeader("RSeq");
            rAck.setMethod(sIPResponse.getCSeq().getMethod());
            rAck.setCSequenceNumber((int)sIPResponse.getCSeq().getSeqNumber());
            rAck.setRSequenceNumber(rSeq.getSeqNumber());
            sIPRequest.setHeader(rAck);
            return sIPRequest;
        }
        catch (Exception exception) {
            InternalErrorHandler.handleException(exception);
            return null;
        }
    }

    private void updateRequest(SIPRequest sIPRequest) {
        RouteList routeList = this.getRouteList();
        if (routeList.size() > 0) {
            sIPRequest.setHeader(routeList);
        } else {
            sIPRequest.removeHeader("Route");
        }
    }

    public Request createAck(long l) throws InvalidArgumentException, SipException {
        if (!this.method.equals("INVITE")) {
            throw new SipException("Dialog was not created with an INVITE");
        }
        if (l <= 0L) {
            throw new InvalidArgumentException("bad cseq <= 0 ");
        }
        if (l > 0x80000000L) {
            throw new InvalidArgumentException("bad cseq > 2147483648");
        }
        if (this.lastResponse == null) {
            throw new SipException("Dialog not yet established -- no response!");
        }
        try {
            String string = this.lastResponse.getTopmostVia().getTransport();
            ListeningPointImpl listeningPointImpl = (ListeningPointImpl)this.sipProvider.getListeningPoint(string);
            Via via = listeningPointImpl.getViaHeader();
            SipUri sipUri = null;
            if (this.getRemoteTarget() == null) {
                sipUri = (SipUri)this.getRemoteParty().getURI().clone();
                sipUri.clearUriParms();
            } else {
                sipUri = (SipUri)this.getRemoteTarget().getURI().clone();
            }
            if (!string.equalsIgnoreCase("udp")) {
                sipUri.setTransportParam(string);
            }
            CSeq cSeq = new CSeq(l, "ACK");
            SIPRequest sIPRequest = this.lastResponse.createRequest(sipUri, via, cSeq);
            From from = (From)sIPRequest.getFrom();
            from.setAddress(this.localParty);
            To to = (To)sIPRequest.getTo();
            to.setAddress(this.remoteParty);
            try {
                if (this.getLocalTag() != null) {
                    from.setTag(this.getLocalTag());
                }
                if (this.getRemoteTag() != null) {
                    to.setTag(this.getRemoteTag());
                }
            }
            catch (ParseException parseException) {
                InternalErrorHandler.handleException(parseException);
            }
            this.updateRequest(sIPRequest);
            return sIPRequest;
        }
        catch (Exception exception) {
            InternalErrorHandler.handleException(exception);
            throw new SipException("unexpected exception ", (Throwable)exception);
        }
    }

    public SipProviderImpl getSipProvider() {
        return this.sipProvider;
    }

    public boolean checkResponseTags(SIPResponse sIPResponse) {
        if (this.isServer()) {
            if (sIPResponse.getToTag() != null && this.getLocalTag() != null && !this.getLocalTag().equals(sIPResponse.getToTag()) || sIPResponse.getFromTag() != null && this.getRemoteTag() != null && !this.getRemoteTag().equals(sIPResponse.getFromTag())) {
                if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                    this.sipStack.getLogWriter().logError("sipResponse.getToTag() = " + sIPResponse.getToTag());
                    this.sipStack.getLogWriter().logError("this.localTag()  = " + this.getLocalTag());
                    this.sipStack.getLogWriter().logError("sipResponse.getFromTag() = " + sIPResponse.getFromTag());
                    this.sipStack.getLogWriter().logError("this.remoteTag = " + this.getRemoteTag());
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public void setLastResponse(SIPTransaction sIPTransaction, SIPResponse sIPResponse) {
        int n = sIPResponse.getStatusCode();
        if (n == 100) {
            this.sipStack.getLogWriter().logWarning("Invalid status code - 100 in setLastResponse - ignoring");
            return;
        }
        this.lastResponse = sIPResponse;
        this.setAssigned();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("sipDialog: setLastResponse:" + this + " lastResponse = " + this.lastResponse.getFirstLine());
        }
        if (this.getState() == DialogState.TERMINATED) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("sipDialog: setLastResponse -- dialog is terminated - ignoring ");
            }
            return;
        }
        String string = sIPResponse.getCSeq().getMethod();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logStackTrace();
            this.sipStack.getLogWriter().logDebug("cseqMethod = " + string);
            this.sipStack.getLogWriter().logDebug("dialogState = " + this.getState());
            this.sipStack.getLogWriter().logDebug("method = " + this.getMethod());
            this.sipStack.getLogWriter().logDebug("statusCode = " + n);
            this.sipStack.getLogWriter().logDebug("transaction = " + sIPTransaction);
        }
        if (sIPTransaction == null || sIPTransaction instanceof ClientTransaction) {
            if (this.sipStack.isDialogCreated(string)) {
                RecordRouteList recordRouteList;
                if (this.getState() == null && n / 100 == 1 && this.getState() != DialogState.CONFIRMED) {
                    this.setState(0);
                    if ((sIPResponse.getToTag() != null || this.sipStack.rfc2543Supported) && this.getRemoteTag() == null) {
                        this.setRemoteTag(sIPResponse.getToTag());
                        this.setDialogId(sIPResponse.getDialogId(false));
                        this.sipStack.putDialog(this);
                        this.addRoute(sIPResponse);
                    }
                } else if (n / 100 == 2) {
                    if (string.equals(this.getMethod()) && (sIPResponse.getToTag() != null || this.sipStack.rfc2543Supported) && this.getState() != DialogState.CONFIRMED) {
                        this.setRemoteTag(sIPResponse.getToTag());
                        this.setDialogId(sIPResponse.getDialogId(false));
                        this.sipStack.putDialog(this);
                        this.addRoute(sIPResponse);
                        this.setState(1);
                    } else if (SIPRequest.isTargetRefresh(string)) {
                        this.doTargetRefresh(sIPResponse);
                    }
                } else if (n >= 300 && n <= 699 && (this.getState() == null || string.equals(this.getMethod()) && this.getState().getValue() == 0)) {
                    this.setState(3);
                }
                if (this.originalRequest != null && (recordRouteList = this.originalRequest.getRecordRouteHeaders()) != null) {
                    ListIterator listIterator = recordRouteList.listIterator(recordRouteList.size());
                    while (listIterator.hasPrevious()) {
                        RecordRoute recordRoute = (RecordRoute)listIterator.previous();
                        Route route = (Route)this.routeList.getFirst();
                        if (route != null && recordRoute.getAddress().equals(route.getAddress())) {
                            this.routeList.removeFirst();
                            continue;
                        }
                        break;
                    }
                }
            } else if (string.equals("NOTIFY") && (this.getMethod().equals("SUBSCRIBE") || this.getMethod().equals("REFER")) && sIPResponse.getStatusCode() / 100 == 2 && this.getState() == null) {
                this.setDialogId(sIPResponse.getDialogId(true));
                this.sipStack.putDialog(this);
                this.setState(1);
            } else if (string.equals("BYE") && n / 100 == 2 && this.isTerminatedOnBye()) {
                this.setState(3);
            }
        } else {
            if (string.equals("CANCEL") && n / 100 == 2 && !this.isReInvite() && (this.getState() == null || this.getState().getValue() == 0)) {
                this.setState(3);
            } else if (string.equals("BYE") && n / 100 == 2 && this.isTerminatedOnBye()) {
                this.setState(3);
            } else if (this.getLocalTag() == null && sIPResponse.getTo().getTag() != null && this.sipStack.isDialogCreated(string) && string.equals(this.getMethod())) {
                this.setLocalTag(sIPResponse.getTo().getTag());
                if (n / 100 != 2) {
                    if (n / 100 == 1) {
                        this.setState(0);
                        this.setDialogId(sIPResponse.getDialogId(true));
                        this.sipStack.putDialog(this);
                    } else {
                        this.setState(3);
                    }
                } else {
                    this.setState(1);
                    this.setDialogId(sIPResponse.getDialogId(true));
                    this.sipStack.putDialog(this);
                }
            }
            if (n / 100 == 2 && string.equals("INVITE")) {
                SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)sIPTransaction;
                this.startTimer(sIPServerTransaction);
            }
        }
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    private void doTargetRefresh(SIPMessage sIPMessage) {
        ContactList contactList = sIPMessage.getContactHeaders();
        if (contactList != null) {
            Contact contact = (Contact)contactList.getFirst();
            this.remoteTarget = contact.getAddress();
        }
    }

    private static final boolean optionPresent(ListIterator listIterator, String string) {
        while (listIterator.hasNext()) {
            OptionTag optionTag = (OptionTag)listIterator.next();
            if (optionTag == null || !string.equalsIgnoreCase(optionTag.getOptionTag())) continue;
            return true;
        }
        return false;
    }

    public Response createReliableProvisionalResponse(int n) throws InvalidArgumentException, SipException {
        SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)this.getFirstTransaction();
        if (!(sIPServerTransaction instanceof SIPServerTransaction)) {
            throw new SipException("Not a Server Dialog!");
        }
        if (n <= 100 || n > 199) {
            throw new InvalidArgumentException("Bad status code ");
        }
        SIPRequest sIPRequest = this.originalRequest;
        if (!sIPRequest.getMethod().equals("INVITE")) {
            throw new SipException("Bad method");
        }
        ListIterator listIterator = sIPRequest.getHeaders("Supported");
        if (!(listIterator != null && SIPDialog.optionPresent(listIterator, "100rel") || (listIterator = sIPRequest.getHeaders("Require")) != null && SIPDialog.optionPresent(listIterator, "100rel"))) {
            throw new SipException("No Supported/Require 100rel header in the request");
        }
        SIPResponse sIPResponse = sIPRequest.createResponse(n);
        Require require = new Require();
        try {
            require.setOptionTag("100rel");
        }
        catch (Exception exception) {
            InternalErrorHandler.handleException(exception);
        }
        sIPResponse.addHeader(require);
        RSeq rSeq = new RSeq();
        rSeq.setSeqNumber(1L);
        return sIPResponse;
    }

    public boolean handlePrack(SIPRequest sIPRequest) {
        if (!this.isServer()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Dropping Prack -- not a server Dialog");
            }
            return false;
        }
        SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)this.getFirstTransaction();
        SIPResponse sIPResponse = sIPServerTransaction.getReliableProvisionalResponse();
        if (sIPResponse == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Dropping Prack -- ReliableResponse not found");
            }
            return false;
        }
        RAck rAck = (RAck)sIPRequest.getHeader("RAck");
        if (rAck == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Dropping Prack -- rack header not found");
            }
            return false;
        }
        CSeq cSeq = (CSeq)sIPResponse.getCSeq();
        if (!rAck.getMethod().equals(cSeq.getMethod())) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Dropping Prack -- CSeq Header does not match PRACK");
            }
            return false;
        }
        if (rAck.getCSeqNumberLong() != cSeq.getSeqNumber()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Dropping Prack -- CSeq Header does not match PRACK");
            }
            return false;
        }
        RSeq rSeq = (RSeq)sIPResponse.getHeader("RSeq");
        if (rAck.getRSequenceNumber() != rSeq.getSeqNumber()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Dropping Prack -- RSeq Header does not match PRACK");
            }
            return false;
        }
        return sIPServerTransaction.prackRecieved();
    }

    public void sendReliableProvisionalResponse(Response response) throws SipException {
        Object object;
        if (!this.isServer()) {
            throw new SipException("Not a Server Dialog");
        }
        SIPResponse sIPResponse = (SIPResponse)response;
        if (response.getStatusCode() == 100) {
            throw new SipException("Cannot send 100 as a reliable provisional response");
        }
        if (response.getStatusCode() / 100 > 2) {
            throw new SipException("Response code is not a 1xx response - should be in the range 101 to 199 ");
        }
        if (sIPResponse.getToTag() == null) {
            throw new SipException("Badly formatted response -- To tag mandatory for Reliable Provisional Response");
        }
        ListIterator listIterator = response.getHeaders("Require");
        boolean bl = false;
        if (listIterator != null) {
            while (listIterator.hasNext() && !bl) {
                object = (RequireHeader)listIterator.next();
                if (!object.getOptionTag().equalsIgnoreCase("100rel")) continue;
                bl = true;
            }
        }
        if (!bl) {
            object = new Require("100rel");
            response.addHeader((Header)object);
            if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("Require header with optionTag 100rel is needed -- adding one");
            }
        }
        object = (SIPServerTransaction)this.getFirstTransaction();
        this.setLastResponse((SIPTransaction)object, sIPResponse);
        this.setDialogId(sIPResponse.getDialogId(true));
        ((SIPServerTransaction)object).sendReliableProvisionalResponse(response);
    }

    public void terminateOnBye(boolean bl) throws SipException {
        this.terminateOnBye = bl;
    }

    public void setAssigned() {
        this.isAssigned = true;
    }

    public boolean isAssigned() {
        return this.isAssigned;
    }

    public Contact getMyContactHeader() {
        if (this.isServer()) {
            SIPServerTransaction sIPServerTransaction = (SIPServerTransaction)this.getFirstTransaction();
            SIPResponse sIPResponse = sIPServerTransaction.getLastResponse();
            return sIPResponse != null ? sIPResponse.getContactHeader() : null;
        }
        SIPClientTransaction sIPClientTransaction = (SIPClientTransaction)this.getFirstTransaction();
        SIPRequest sIPRequest = sIPClientTransaction.getOriginalRequest();
        return sIPRequest.getContactHeader();
    }

    public boolean handleAck(SIPServerTransaction sIPServerTransaction) {
        SIPResponse sIPResponse;
        SIPRequest sIPRequest = sIPServerTransaction.getOriginalRequest();
        if (this.isAckSeen() && this.getRemoteSeqNumber() == sIPRequest.getCSeq().getSeqNumber()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("ACK already seen by dialog -- dropping Ack retransmission");
            }
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
            return false;
        }
        if (this.getState() == DialogState.TERMINATED) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("Dialog is terminated -- dropping ACK");
            }
            return false;
        }
        SIPServerTransaction sIPServerTransaction2 = this.getInviteTransaction();
        SIPResponse sIPResponse2 = sIPResponse = sIPServerTransaction2 != null ? sIPServerTransaction2.getLastResponse() : null;
        if (sIPServerTransaction2 != null && sIPResponse != null && sIPResponse.getStatusCode() / 100 == 2 && sIPResponse.getCSeq().getMethod().equals("INVITE") && sIPResponse.getCSeq().getSeqNumber() == sIPRequest.getCSeq().getSeqNumber()) {
            sIPServerTransaction.setDialog(this, sIPResponse.getDialogId(false));
            this.ackReceived(sIPRequest);
            this.sipStack.getLogWriter().logDebug("ACK for 2XX response --- sending to TU ");
            return true;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug(" INVITE transaction not found  -- Discarding ACK");
        }
        return false;
    }

    class DialogDeleteTask
    extends SIPStackTimerTask {
        DialogDeleteTask() {
        }

        protected void runTask() {
            if (SIPDialog.this.isAckSeen()) {
                this.cancel();
            } else {
                SIPDialog.this.delete();
            }
        }
    }

    class DialogTimerTask
    extends SIPStackTimerTask {
        int nRetransmissions;
        SIPServerTransaction transaction;

        public DialogTimerTask(SIPServerTransaction sIPServerTransaction) {
            this.transaction = sIPServerTransaction;
            this.nRetransmissions = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runTask() {
            SIPDialog sIPDialog;
            block13: {
                SIPResponse sIPResponse;
                SIPServerTransaction sIPServerTransaction;
                block12: {
                    sIPDialog = SIPDialog.this;
                    if (SIPDialog.this.sipStack.isLoggingEnabled()) {
                        SIPDialog.this.sipStack.getLogWriter().logDebug("Running dialog timer");
                    }
                    ++this.nRetransmissions;
                    sIPServerTransaction = this.transaction;
                    if (this.nRetransmissions <= 64) break block12;
                    sIPDialog.setState(3);
                    if (sIPServerTransaction != null) {
                        sIPServerTransaction.raiseErrorEvent(1);
                    }
                    break block13;
                }
                if (!sIPDialog.ackSeen && sIPServerTransaction != null && (sIPResponse = sIPServerTransaction.getLastResponse()).getStatusCode() == 200) {
                    block11: {
                        try {
                            if (!sIPDialog.toRetransmitFinalResponse(sIPServerTransaction.T2)) break block11;
                            sIPServerTransaction.sendMessage(sIPResponse);
                        }
                        catch (IOException iOException) {
                            try {
                                SIPDialog.this.raiseIOException(sIPServerTransaction.getPeerAddress(), sIPServerTransaction.getPeerPort(), sIPServerTransaction.getPeerProtocol());
                            }
                            catch (Throwable throwable) {
                                SIPTransactionStack sIPTransactionStack = sIPDialog.sipStack;
                                if (sIPTransactionStack.logWriter.isLoggingEnabled()) {
                                    sIPTransactionStack.logWriter.logDebug("resend 200 response from " + sIPDialog);
                                }
                                sIPServerTransaction.fireTimer();
                                throw throwable;
                            }
                            SIPTransactionStack sIPTransactionStack = sIPDialog.sipStack;
                            if (sIPTransactionStack.logWriter.isLoggingEnabled()) {
                                sIPTransactionStack.logWriter.logDebug("resend 200 response from " + sIPDialog);
                            }
                            sIPServerTransaction.fireTimer();
                        }
                    }
                    SIPTransactionStack sIPTransactionStack = sIPDialog.sipStack;
                    if (sIPTransactionStack.logWriter.isLoggingEnabled()) {
                        sIPTransactionStack.logWriter.logDebug("resend 200 response from " + sIPDialog);
                    }
                    sIPServerTransaction.fireTimer();
                }
            }
            if (sIPDialog.isAckSeen() || sIPDialog.dialogState == 3) {
                this.transaction = null;
                this.cancel();
            }
        }
    }

    class LingerTimer
    extends SIPStackTimerTask {
        protected void runTask() {
            SIPDialog sIPDialog = SIPDialog.this;
            SIPDialog.this.sipStack.removeDialog(sIPDialog);
        }
    }
}

