/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.Host;
import gov.nist.core.HostNameParser;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.address.TelephoneNumber;
import gov.nist.javax.sip.header.ExtensionHeaderImpl;
import gov.nist.javax.sip.header.NameMap;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.AddressParser;
import gov.nist.javax.sip.parser.HeaderParser;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.ParserFactory;
import gov.nist.javax.sip.parser.RequestLineParser;
import gov.nist.javax.sip.parser.StatusLineParser;
import gov.nist.javax.sip.parser.URLParser;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;

public class StringMsgParser {
    protected boolean readBody = true;
    private ParseExceptionListener parseExceptionListener;
    private String rawStringMessage;

    public StringMsgParser() {
    }

    public StringMsgParser(ParseExceptionListener parseExceptionListener) {
        this();
        this.parseExceptionListener = parseExceptionListener;
    }

    public void setParseExceptionListener(ParseExceptionListener parseExceptionListener) {
        this.parseExceptionListener = parseExceptionListener;
    }

    public SIPMessage parseSIPMessage(byte[] byArray) throws ParseException {
        int n;
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n2 = 0;
        try {
            while (byArray[n2] < 32) {
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        String string = null;
        String string2 = null;
        boolean bl = true;
        SIPMessage sIPMessage = null;
        do {
            n = n2;
            try {
                while (byArray[n2] != 13 && byArray[n2] != 10) {
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
            int n3 = n2 - n;
            try {
                string = new String(byArray, n, n3, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ParseException("Bad message encoding!", 0);
            }
            string = this.trimEndOfLine(string);
            if (string.length() == 0) {
                if (string2 != null && sIPMessage != null) {
                    this.processHeader(string2, sIPMessage);
                }
            } else if (bl) {
                sIPMessage = this.processFirstLine(string);
            } else {
                char c = string.charAt(0);
                if (c == '\t' || c == ' ') {
                    if (string2 == null) {
                        throw new ParseException("Bad header continuation.", 0);
                    }
                    string2 = string2 + string.substring(1);
                } else {
                    if (string2 != null && sIPMessage != null) {
                        this.processHeader(string2, sIPMessage);
                    }
                    string2 = string;
                }
            }
            if (byArray[n2] == 13 && byArray.length > n2 + 1 && byArray[n2 + 1] == 10) {
                ++n2;
            }
            ++n2;
            bl = false;
        } while (string.length() > 0);
        if (sIPMessage == null) {
            throw new ParseException("Bad message", 0);
        }
        sIPMessage.setSize(n2);
        if (this.readBody && sIPMessage.getContentLength() != null && sIPMessage.getContentLength().getContentLength() != 0) {
            n = byArray.length - n2;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, n2, byArray2, 0, n);
            sIPMessage.setMessageContent(byArray2);
        }
        return sIPMessage;
    }

    public SIPMessage parseSIPMessage(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return null;
        }
        this.rawStringMessage = string;
        int n = 0;
        try {
            while (string.charAt(n) < ' ') {
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        SIPMessage sIPMessage = null;
        do {
            char c;
            int n2 = n;
            try {
                c = string.charAt(n);
                while (c != '\r' && c != '\n') {
                    c = string.charAt(++n);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                break;
            }
            string2 = string.substring(n2, n);
            if ((string2 = this.trimEndOfLine(string2)).length() == 0) {
                if (string3 != null) {
                    this.processHeader(string3, sIPMessage);
                }
            } else if (bl) {
                sIPMessage = this.processFirstLine(string2);
            } else {
                c = string2.charAt(0);
                if (c == '\t' || c == ' ') {
                    if (string3 == null) {
                        throw new ParseException("Bad header continuation.", 0);
                    }
                    string3 = string3 + string2.substring(1);
                } else {
                    if (string3 != null) {
                        this.processHeader(string3, sIPMessage);
                    }
                    string3 = string2;
                }
            }
            if (string.charAt(n) == '\r' && string.length() > n + 1 && string.charAt(n + 1) == '\n') {
                ++n;
            }
            ++n;
            bl = false;
        } while (string2.length() > 0);
        sIPMessage.setSize(n);
        if (this.readBody && sIPMessage.getContentLength() != null && sIPMessage.getContentLength().getContentLength() != 0) {
            String string4 = string.substring(n);
            sIPMessage.setMessageContent(string4);
        }
        return sIPMessage;
    }

    private String trimEndOfLine(String string) {
        int n;
        if (string == null) {
            return string;
        }
        for (n = string.length() - 1; n >= 0 && string.charAt(n) <= ' '; --n) {
        }
        if (n == string.length() - 1) {
            return string;
        }
        if (n == -1) {
            return "";
        }
        return string.substring(0, n + 1);
    }

    private SIPMessage processFirstLine(String string) throws ParseException {
        SIPMessage sIPMessage;
        if (!string.startsWith("SIP/2.0")) {
            sIPMessage = new SIPRequest();
            try {
                RequestLine requestLine = new RequestLineParser(string + "\n").parse();
                ((SIPRequest)sIPMessage).setRequestLine(requestLine);
            }
            catch (ParseException parseException) {
                if (this.parseExceptionListener != null) {
                    this.parseExceptionListener.handleException(parseException, sIPMessage, RequestLine.class, string, this.rawStringMessage);
                }
                throw parseException;
            }
        } else {
            sIPMessage = new SIPResponse();
            try {
                StatusLine statusLine = new StatusLineParser(string + "\n").parse();
                ((SIPResponse)sIPMessage).setStatusLine(statusLine);
            }
            catch (ParseException parseException) {
                if (this.parseExceptionListener != null) {
                    this.parseExceptionListener.handleException(parseException, sIPMessage, StatusLine.class, string, this.rawStringMessage);
                }
                throw parseException;
            }
        }
        return sIPMessage;
    }

    private void processHeader(String string, SIPMessage sIPMessage) throws ParseException {
        block6: {
            if (string == null || string.length() == 0) {
                return;
            }
            HeaderParser headerParser = null;
            try {
                headerParser = ParserFactory.createParser(string + "\n");
            }
            catch (ParseException parseException) {
                this.parseExceptionListener.handleException(parseException, sIPMessage, null, string, this.rawStringMessage);
                return;
            }
            try {
                SIPHeader sIPHeader = headerParser.parse();
                sIPMessage.attachHeader(sIPHeader, false);
            }
            catch (ParseException parseException) {
                if (this.parseExceptionListener == null) break block6;
                String string2 = Lexer.getHeaderName(string);
                Class clazz = NameMap.getClassFromName(string2);
                if (clazz == null) {
                    clazz = ExtensionHeaderImpl.class;
                }
                this.parseExceptionListener.handleException(parseException, sIPMessage, clazz, string, this.rawStringMessage);
            }
        }
    }

    public AddressImpl parseAddress(String string) throws ParseException {
        AddressParser addressParser = new AddressParser(string);
        return addressParser.address();
    }

    public Host parseHost(String string) throws ParseException {
        Lexer lexer = new Lexer("charLexer", string);
        return new HostNameParser(lexer).host();
    }

    public TelephoneNumber parseTelephoneNumber(String string) throws ParseException {
        return new URLParser(string).parseTelephoneNumber();
    }

    public SipUri parseSIPUrl(String string) throws ParseException {
        try {
            return new URLParser(string).sipURL();
        }
        catch (ClassCastException classCastException) {
            throw new ParseException(string + " Not a SIP URL ", 0);
        }
    }

    public GenericURI parseUrl(String string) throws ParseException {
        return new URLParser(string).parse();
    }

    public SIPHeader parseSIPHeader(String string) throws ParseException {
        int n;
        int n2 = 0;
        int n3 = string.length() - 1;
        try {
            while (string.charAt(n2) <= ' ') {
                ++n2;
            }
            while (string.charAt(n3) <= ' ') {
                --n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParseException("Empty header.", 0);
        }
        StringBuffer stringBuffer = new StringBuffer(n3 + 1);
        int n4 = n2;
        boolean bl = false;
        for (n = n2; n <= n3; ++n) {
            char c = string.charAt(n);
            if (c == '\r' || c == '\n') {
                if (bl) continue;
                stringBuffer.append(string.substring(n4, n));
                bl = true;
                continue;
            }
            if (!bl) continue;
            bl = false;
            if (c == ' ' || c == '\t') {
                stringBuffer.append(' ');
                n4 = n + 1;
                continue;
            }
            n4 = n;
        }
        stringBuffer.append(string.substring(n4, n));
        stringBuffer.append('\n');
        HeaderParser headerParser = ParserFactory.createParser(stringBuffer.toString());
        if (headerParser == null) {
            throw new ParseException("could not create parser", 0);
        }
        return headerParser.parse();
    }

    public RequestLine parseSIPRequestLine(String string) throws ParseException {
        string = string + "\n";
        return new RequestLineParser(string).parse();
    }

    public StatusLine parseSIPStatusLine(String string) throws ParseException {
        string = string + "\n";
        return new StatusLineParser(string).parse();
    }

    public static void main(String[] stringArray) throws ParseException {
        String[] stringArray2 = new String[]{"SIP/2.0 200 OK\r\nTo: \"The Little Blister\" <sip:LittleGuy@there.com>;tag=469bc066\r\nFrom: \"The Master Blaster\" <sip:BigGuy@here.com>;tag=11\r\nVia: SIP/2.0/UDP 139.10.134.246:5060;branch=z9hG4bK8b0a86f6_1030c7d18e0_17;received=139.10.134.246\r\nCall-ID: 1030c7d18ae_a97b0b_b@8b0a86f6\r\nCSeq: 1 SUBSCRIBE\r\nContact: <sip:172.16.11.162:5070>\r\nContent-Length: 0\r\n\r\n", "SIP/2.0 180 Ringing\r\nVia: SIP/2.0/UDP 172.18.1.29:5060;branch=z9hG4bK43fc10fb4446d55fc5c8f969607991f4\r\nTo: \"0440\" <sip:0440@212.209.220.131>;tag=2600\r\nFrom: \"Andreas\" <sip:andreas@e-horizon.se>;tag=8524\r\nCall-ID: f51a1851c5f570606140f14c8eb64fd3@172.18.1.29\r\nCSeq: 1 INVITE\r\nMax-Forwards: 70\r\nRecord-Route: <sip:212.209.220.131:5060>\r\nContent-Length: 0\r\n\r\n", "REGISTER sip:nist.gov SIP/2.0\r\nVia: SIP/2.0/UDP 129.6.55.182:14826\r\nMax-Forwards: 70\r\nFrom: <sip:mranga@nist.gov>;tag=6fcd5c7ace8b4a45acf0f0cd539b168b;epid=0d4c418ddf\r\nTo: <sip:mranga@nist.gov>\r\nCall-ID: c5679907eb954a8da9f9dceb282d7230@129.6.55.182\r\nCSeq: 1 REGISTER\r\nContact: <sip:129.6.55.182:14826>;methods=\"INVITE, MESSAGE, INFO, SUBSCRIBE, OPTIONS, BYE, CANCEL, NOTIFY, ACK, REFER\"\r\nUser-Agent: RTC/(Microsoft RTC)\r\nEvent:  registration\r\nAllow-Events: presence\r\nContent-Length: 0\r\n\r\nINVITE sip:littleguy@there.com:5060 SIP/2.0\r\nVia: SIP/2.0/UDP 65.243.118.100:5050\r\nFrom: M. Ranganathan  <sip:M.Ranganathan@sipbakeoff.com>;tag=1234\r\nTo: \"littleguy@there.com\" <sip:littleguy@there.com:5060> \r\nCall-ID: Q2AboBsaGn9!?x6@sipbakeoff.com \r\nCSeq: 1 INVITE \r\nContent-Length: 247\r\n\r\nv=0\r\no=4855 13760799956958020 13760799956958020 IN IP4  129.6.55.78\r\ns=mysession session\r\np=+46 8 52018010\r\nc=IN IP4  129.6.55.78\r\nt=0 0\r\nm=audio 6022 RTP/AVP 0 4 18\r\na=rtpmap:0 PCMU/8000\r\na=rtpmap:4 G723/8000\r\na=rtpmap:18 G729A/8000\r\na=ptime:20\r\n"};
        for (int i = 0; i < 20; ++i) {
            class ParserThread
            implements Runnable {
                String[] messages;

                public ParserThread(String[] stringArray) {
                    this.messages = stringArray;
                }

                public void run() {
                    for (int i = 0; i < this.messages.length; ++i) {
                        StringMsgParser stringMsgParser = new StringMsgParser();
                        try {
                            SIPMessage sIPMessage = stringMsgParser.parseSIPMessage(this.messages[i]);
                            System.out.println(" i = " + i + " branchId = " + sIPMessage.getTopmostVia().getBranch());
                            continue;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
            new Thread(new ParserThread(stringArray2)).start();
        }
    }
}

