/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.Host;
import gov.nist.core.HostNameParser;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.address.TelephoneNumber;
import gov.nist.javax.sip.header.NameMap;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.AddressParser;
import gov.nist.javax.sip.parser.HeaderParser;
import gov.nist.javax.sip.parser.Lexer;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.ParserFactory;
import gov.nist.javax.sip.parser.RequestLineParser;
import gov.nist.javax.sip.parser.StatusLineParser;
import gov.nist.javax.sip.parser.URLParser;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringMsgParser {
    protected boolean readBody = true;
    private String rawMessage;
    private String rawMessage1;
    private String currentMessage;
    private ParseExceptionListener parseExceptionListener;
    private Vector messageHeaders = new Vector(10, 10);
    private int bufferPointer = 0;
    private boolean bodyIsString;
    private byte[] currentMessageBytes;
    protected int contentLength;
    private boolean debugFlag;
    private int currentLine = 0;
    private String currentHeader;

    public StringMsgParser() {
    }

    public StringMsgParser(ParseExceptionListener exhandler) {
        this();
        this.parseExceptionListener = exhandler;
    }

    protected String getMessageBody() {
        String body;
        if (this.contentLength == 0) {
            return null;
        }
        int endIndex = this.bufferPointer + this.contentLength;
        if (endIndex > this.currentMessage.length()) {
            endIndex = this.currentMessage.length();
            body = this.currentMessage.substring(this.bufferPointer, endIndex);
            this.bufferPointer = endIndex;
        } else {
            body = this.currentMessage.substring(this.bufferPointer, endIndex);
            this.bufferPointer = endIndex + 1;
        }
        this.contentLength = 0;
        return body;
    }

    protected byte[] getBodyAsBytes() {
        if (this.contentLength == 0) {
            return null;
        }
        int endIndex = this.bufferPointer + this.contentLength;
        if (endIndex > this.currentMessageBytes.length) {
            endIndex = this.currentMessageBytes.length;
        }
        byte[] body = new byte[endIndex - this.bufferPointer];
        System.arraycopy(this.currentMessageBytes, this.bufferPointer, body, 0, body.length);
        this.bufferPointer = endIndex;
        this.contentLength = 0;
        return body;
    }

    protected String readToEnd() {
        String body = this.currentMessage.substring(this.bufferPointer);
        this.bufferPointer += body.length();
        return body;
    }

    protected byte[] readBytesToEnd() {
        byte[] body = new byte[this.currentMessageBytes.length - this.bufferPointer];
        int endIndex = this.currentMessageBytes.length;
        int i = this.bufferPointer;
        int k = 0;
        while (i < endIndex) {
            body[k] = this.currentMessageBytes[i];
            ++i;
            ++k;
        }
        this.bufferPointer = endIndex;
        this.contentLength = 0;
        return body;
    }

    public void setParseExceptionListener(ParseExceptionListener pexhandler) {
        this.parseExceptionListener = pexhandler;
    }

    protected boolean isBodyString() {
        return this.bodyIsString;
    }

    public SIPMessage parseSIPMessage(byte[] msgBuffer) throws ParseException {
        int f;
        int s;
        this.bufferPointer = 0;
        this.bodyIsString = false;
        Vector retval = new Vector();
        this.currentMessageBytes = msgBuffer;
        for (s = this.bufferPointer; s < msgBuffer.length && ((char)msgBuffer[s] == '\r' || (char)msgBuffer[s] == '\n' || (char)msgBuffer[s] == '\u0000'); ++s) {
        }
        if (s == msgBuffer.length) {
            return null;
        }
        for (f = s; f < msgBuffer.length - 4 && ((char)msgBuffer[f] != '\r' || (char)msgBuffer[f + 1] != '\n' || (char)msgBuffer[f + 2] != '\r' || (char)msgBuffer[f + 3] != '\n'); ++f) {
        }
        if (f < msgBuffer.length) {
            f += 4;
        } else {
            for (f = s; f < msgBuffer.length - 2 && ((char)msgBuffer[f] != '\n' || (char)msgBuffer[f + 1] != '\n'); ++f) {
            }
            if (f < msgBuffer.length) {
                f += 2;
            } else {
                throw new ParseException("Message not terminated", 0);
            }
        }
        String messageString = null;
        try {
            messageString = new String(msgBuffer, s, f - s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ParseException("Bad message encoding!", 0);
        }
        this.bufferPointer = f;
        StringBuffer message = new StringBuffer(messageString);
        int length = message.length();
        for (int k = 0; k < length; ++k) {
            if (message.charAt(k) != '\r') continue;
            message.deleteCharAt(k);
            --length;
        }
        StringTokenizer tokenizer = new StringTokenizer(message.toString(), "\n", true);
        StringBuffer cooked_message = new StringBuffer();
        try {
            while (tokenizer.hasMoreElements()) {
                String nexttok = tokenizer.nextToken();
                if (nexttok.trim().equals("")) {
                    cooked_message.append("\n");
                    continue;
                }
                cooked_message.append(nexttok);
            }
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        String message1 = cooked_message.toString();
        length = message1.indexOf("\n\n") + 2;
        int k = 0;
        while (k < length - 1) {
            if (cooked_message.charAt(k) == '\n') {
                if (cooked_message.charAt(k + 1) == '\t' || cooked_message.charAt(k + 1) == ' ') {
                    cooked_message.deleteCharAt(k);
                    cooked_message.deleteCharAt(k);
                    --length;
                    if (k != --length) continue;
                    break;
                }
                if (cooked_message.charAt(k + 1) == '\n') {
                    cooked_message.insert(k, '\n');
                    ++length;
                    ++k;
                }
            }
            ++k;
        }
        cooked_message.append("\n\n");
        this.currentMessage = cooked_message.toString();
        SIPMessage sipmsg = this.parseMessage(this.currentMessage);
        if (this.readBody && sipmsg.getContentLength() != null && sipmsg.getContentLength().getContentLength() != 0) {
            this.contentLength = sipmsg.getContentLength().getContentLength();
            byte[] body = this.getBodyAsBytes();
            sipmsg.setMessageContent(body);
        }
        sipmsg.setSize(this.currentMessage.length());
        return sipmsg;
    }

    public SIPMessage parseSIPMessage(String sipMessages) throws ParseException {
        int k;
        this.rawMessage = sipMessages;
        Vector retval = new Vector();
        String pmessage = sipMessages.trim();
        this.bodyIsString = true;
        this.contentLength = 0;
        if (pmessage.trim().equals("")) {
            return null;
        }
        pmessage = pmessage + "\n\n";
        StringBuffer message = new StringBuffer(pmessage);
        while (message.charAt(0) == '\r' || message.charAt(0) == '\n') {
            ++this.bufferPointer;
            message.deleteCharAt(0);
        }
        String message1 = message.toString();
        int length = message1.indexOf("\r\n\r\n");
        if (length > 0) {
            length += 4;
        }
        if (length == -1) {
            length = message1.indexOf("\n\n");
            if (length == -1) {
                throw new ParseException("no trailing crlf", 0);
            }
        } else {
            length += 2;
        }
        for (k = 0; k < length; ++k) {
            if (message.charAt(k) != '\r') continue;
            message.deleteCharAt(k);
            --length;
        }
        if (this.debugFlag) {
            for (k = 0; k < length; ++k) {
                this.rawMessage1 = this.rawMessage1 + "[" + message.charAt(k) + "]";
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(message.toString(), "\n", true);
        StringBuffer cooked_message = new StringBuffer();
        try {
            while (tokenizer.hasMoreElements()) {
                String nexttok = tokenizer.nextToken();
                if (nexttok.trim().equals("")) {
                    cooked_message.append("\n");
                    continue;
                }
                cooked_message.append(nexttok);
            }
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        message1 = cooked_message.toString();
        length = message1.indexOf("\n\n") + 2;
        int k2 = 0;
        while (k2 < length - 1) {
            if (cooked_message.charAt(k2) == '\n') {
                if (cooked_message.charAt(k2 + 1) == '\t' || cooked_message.charAt(k2 + 1) == ' ') {
                    cooked_message.deleteCharAt(k2);
                    cooked_message.deleteCharAt(k2);
                    --length;
                    if (k2 != --length) continue;
                    break;
                }
                if (cooked_message.charAt(k2 + 1) == '\n') {
                    cooked_message.insert(k2, '\n');
                    ++length;
                    ++k2;
                }
            }
            ++k2;
        }
        cooked_message.append("\n\n");
        this.currentMessage = cooked_message.toString();
        this.bufferPointer = this.currentMessage.indexOf("\n\n") + 3;
        SIPMessage sipmsg = this.parseMessage(this.currentMessage);
        if (this.readBody && sipmsg.getContentLength() != null && sipmsg.getContentLength().getContentLength() != 0) {
            this.contentLength = sipmsg.getContentLength().getContentLength();
            String body = this.getMessageBody();
            sipmsg.setMessageContent(body);
        }
        return sipmsg;
    }

    private SIPMessage parseMessage(String currentMessage) throws ParseException {
        int sip_message_size = 0;
        SIPMessage sipmsg = null;
        StringTokenizer tokenizer = new StringTokenizer(currentMessage, "\n", true);
        this.messageHeaders = new Vector();
        try {
            while (tokenizer.hasMoreElements()) {
                String nexttok = tokenizer.nextToken();
                if (nexttok.equals("\n")) {
                    String nextnexttok = tokenizer.nextToken();
                    if (nextnexttok.equals("\n")) break;
                    this.messageHeaders.add(nextnexttok);
                } else {
                    this.messageHeaders.add(nexttok);
                }
                ++sip_message_size;
            }
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        this.currentLine = 0;
        String firstLine = this.currentHeader = (String)this.messageHeaders.elementAt(this.currentLine);
        if (!firstLine.startsWith("SIP/2.0")) {
            sipmsg = new SIPRequest();
            try {
                RequestLine rl = new RequestLineParser(firstLine + "\n").parse();
                ((SIPRequest)sipmsg).setRequestLine(rl);
            }
            catch (ParseException ex) {
                if (this.parseExceptionListener != null) {
                    this.parseExceptionListener.handleException(ex, sipmsg, RequestLine.class, firstLine, currentMessage);
                }
                throw ex;
            }
        } else {
            sipmsg = new SIPResponse();
            try {
                StatusLine sl = new StatusLineParser(firstLine + "\n").parse();
                ((SIPResponse)sipmsg).setStatusLine(sl);
            }
            catch (ParseException ex) {
                if (this.parseExceptionListener != null) {
                    this.parseExceptionListener.handleException(ex, sipmsg, StatusLine.class, firstLine, currentMessage);
                }
                throw ex;
            }
        }
        for (int i = 1; i < this.messageHeaders.size(); ++i) {
            String hdrstring = (String)this.messageHeaders.elementAt(i);
            if (hdrstring == null || hdrstring.trim().equals("")) continue;
            HeaderParser hdrParser = null;
            try {
                hdrParser = ParserFactory.createParser(hdrstring + "\n");
            }
            catch (ParseException ex) {
                this.parseExceptionListener.handleException(ex, sipmsg, null, hdrstring, this.rawMessage);
                continue;
            }
            try {
                SIPHeader sipHeader = hdrParser.parse();
                sipmsg.attachHeader(sipHeader, false);
                continue;
            }
            catch (ParseException ex) {
                if (this.parseExceptionListener == null) continue;
                String hdrName = Lexer.getHeaderName(hdrstring);
                Class<?> hdrClass = NameMap.getClassFromName(hdrName);
                try {
                    if (hdrClass == null) {
                        hdrClass = Class.forName("gov.nist.javax.sip.header.ExtensionHeaderImpl");
                    }
                    this.parseExceptionListener.handleException(ex, sipmsg, hdrClass, hdrstring, this.rawMessage);
                    continue;
                }
                catch (ClassNotFoundException ex1) {
                    InternalErrorHandler.handleException(ex1);
                }
            }
        }
        return sipmsg;
    }

    public AddressImpl parseAddress(String address) throws ParseException {
        AddressParser addressParser = new AddressParser(address);
        return addressParser.address();
    }

    public HostPort parseHostPort(String hostport) throws ParseException {
        Lexer lexer = new Lexer("charLexer", hostport);
        return new HostNameParser(lexer).hostPort();
    }

    public Host parseHost(String host) throws ParseException {
        Lexer lexer = new Lexer("charLexer", host);
        return new HostNameParser(lexer).host();
    }

    public TelephoneNumber parseTelephoneNumber(String telephone_number) throws ParseException {
        return new URLParser(telephone_number).parseTelephoneNumber();
    }

    public SipUri parseSIPUrl(String url) throws ParseException {
        try {
            return (SipUri)new URLParser(url).parse();
        }
        catch (ClassCastException ex) {
            throw new ParseException(url + " Not a SIP URL ", 0);
        }
    }

    public GenericURI parseUrl(String url) throws ParseException {
        return new URLParser(url).parse();
    }

    public SIPHeader parseSIPHeader(String header) throws ParseException {
        header = header + "\n\n";
        StringBuffer nmessage = new StringBuffer(header.length() + 5);
        boolean counter = false;
        int i = 0;
        while (header.charAt(i) == '\n' || header.charAt(i) == '\t' || header.charAt(i) == ' ') {
            ++i;
        }
        while (i < header.length()) {
            if (i < header.length() - 1 && header.charAt(i) == '\n' && (header.charAt(i + 1) == '\t' || header.charAt(i + 1) == ' ')) {
                nmessage.append(' ');
                ++i;
            } else {
                nmessage.append(header.charAt(i));
            }
            ++i;
        }
        nmessage.append('\n');
        HeaderParser hp = ParserFactory.createParser(nmessage.toString());
        if (hp == null) {
            throw new ParseException("could not create parser", 0);
        }
        return hp.parse();
    }

    public RequestLine parseSIPRequestLine(String requestLine) throws ParseException {
        requestLine = requestLine + "\n";
        return new RequestLineParser(requestLine).parse();
    }

    public StatusLine parseSIPStatusLine(String statusLine) throws ParseException {
        statusLine = statusLine + "\n";
        return new StatusLineParser(statusLine).parse();
    }

    public String getCurrentHeader() {
        return this.currentHeader;
    }

    public int getCurrentLineNumber() {
        return this.currentLine;
    }

    public static void main(String[] args) throws ParseException {
        String[] messages = new String[]{"SIP/2.0 200 OK\r\nTo: \"The Little Blister\" <sip:LittleGuy@there.com>;tag=469bc066\r\nFrom: \"The Master Blaster\" <sip:BigGuy@here.com>;tag=11\r\nVia: SIP/2.0/UDP 139.10.134.246:5060;branch=z9hG4bK8b0a86f6_1030c7d18e0_17;received=139.10.134.246\r\nCall-ID: 1030c7d18ae_a97b0b_b@8b0a86f6\r\nCSeq: 1 SUBSCRIBE\r\nContact: <sip:172.16.11.162:5070>\r\nContent-Length: 0\r\n\r\n", "SIP/2.0 180 Ringing\r\nVia: SIP/2.0/UDP 172.18.1.29:5060;branch=z9hG4bK43fc10fb4446d55fc5c8f969607991f4\r\nTo: \"0440\" <sip:0440@212.209.220.131>;tag=2600\r\nFrom: \"Andreas\" <sip:andreas@e-horizon.se>;tag=8524\r\nCall-ID: f51a1851c5f570606140f14c8eb64fd3@172.18.1.29\r\nCSeq: 1 INVITE\r\nMax-Forwards: 70\r\nRecord-Route: <sip:212.209.220.131:5060>\r\nContent-Length: 0\r\n\r\n", "REGISTER sip:nist.gov SIP/2.0\r\nVia: SIP/2.0/UDP 129.6.55.182:14826\r\nMax-Forwards: 70\r\nFrom: <sip:mranga@nist.gov>;tag=6fcd5c7ace8b4a45acf0f0cd539b168b;epid=0d4c418ddf\r\nTo: <sip:mranga@nist.gov>\r\nCall-ID: c5679907eb954a8da9f9dceb282d7230@129.6.55.182\r\nCSeq: 1 REGISTER\r\nContact: <sip:129.6.55.182:14826>;methods=\"INVITE, MESSAGE, INFO, SUBSCRIBE, OPTIONS, BYE, CANCEL, NOTIFY, ACK, REFER\"\r\nUser-Agent: RTC/(Microsoft RTC)\r\nEvent:  registration\r\nAllow-Events: presence\r\nContent-Length: 0\r\n\r\nINVITE sip:littleguy@there.com:5060 SIP/2.0\r\nVia: SIP/2.0/UDP 65.243.118.100:5050\r\nFrom: M. Ranganathan  <sip:M.Ranganathan@sipbakeoff.com>;tag=1234\r\nTo: \"littleguy@there.com\" <sip:littleguy@there.com:5060> \r\nCall-ID: Q2AboBsaGn9!?x6@sipbakeoff.com \r\nCSeq: 1 INVITE \r\nContent-Length: 247\r\n\r\nv=0\r\no=4855 13760799956958020 13760799956958020 IN IP4  129.6.55.78\r\ns=mysession session\r\np=+46 8 52018010\r\nc=IN IP4  129.6.55.78\r\nt=0 0\r\nm=audio 6022 RTP/AVP 0 4 18\r\na=rtpmap:0 PCMU/8000\r\na=rtpmap:4 G723/8000\r\na=rtpmap:18 G729A/8000\r\na=ptime:20\r\n"};
        for (int i = 0; i < 20; ++i) {
            class ParserThread
            implements Runnable {
                String[] messages;

                public ParserThread(String[] messagesToParse) {
                    this.messages = messagesToParse;
                }

                public void run() {
                    for (int i = 0; i < this.messages.length; ++i) {
                        StringMsgParser smp = new StringMsgParser();
                        try {
                            SIPMessage sipMessage = smp.parseSIPMessage(this.messages[i]);
                            System.out.println(" i = " + i + " branchId = " + sipMessage.getTopmostVia().getBranch());
                            continue;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                }
            }
            new Thread(new ParserThread(messages)).start();
        }
    }
}

