/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.countdownlatch;

import com.hazelcast.concurrent.countdownlatch.CountDownLatchInfo;
import com.hazelcast.concurrent.countdownlatch.CountDownLatchProxy;
import com.hazelcast.concurrent.countdownlatch.CountDownLatchReplicationOperation;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CountDownLatchService
implements ManagedService,
RemoteService,
MigrationAwareService {
    public static final String SERVICE_NAME = "hz:impl:countDownLatchService";
    private final ConcurrentMap<String, CountDownLatchInfo> latches = new ConcurrentHashMap<String, CountDownLatchInfo>();
    private NodeEngine nodeEngine;

    public int getCount(String name) {
        CountDownLatchInfo latch = (CountDownLatchInfo)this.latches.get(name);
        return latch != null ? latch.getCount() : 0;
    }

    public boolean setCount(String name, int count) {
        if (count <= 0) {
            this.latches.remove(name);
            return false;
        }
        CountDownLatchInfo latch = (CountDownLatchInfo)this.latches.get(name);
        if (latch == null) {
            latch = new CountDownLatchInfo(name);
            this.latches.put(name, latch);
        }
        return latch.setCount(count);
    }

    public void setCountDirect(String name, int count) {
        if (count <= 0) {
            this.latches.remove(name);
        } else {
            CountDownLatchInfo latch = (CountDownLatchInfo)this.latches.get(name);
            if (latch == null) {
                latch = new CountDownLatchInfo(name);
                this.latches.put(name, latch);
            }
            latch.setCountDirect(count);
        }
    }

    public void countDown(String name) {
        CountDownLatchInfo latch = (CountDownLatchInfo)this.latches.get(name);
        if (latch != null && latch.countDown() == 0) {
            this.latches.remove(name);
        }
    }

    public boolean shouldWait(String name) {
        CountDownLatchInfo latch = (CountDownLatchInfo)this.latches.get(name);
        return latch != null && latch.getCount() > 0;
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void reset() {
        this.latches.clear();
    }

    @Override
    public void shutdown() {
        this.latches.clear();
    }

    @Override
    public CountDownLatchProxy createDistributedObject(String name) {
        return new CountDownLatchProxy(name, this.nodeEngine);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.latches.remove(name);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        if (event.getReplicaIndex() > 1) {
            return null;
        }
        LinkedList<CountDownLatchInfo> data = new LinkedList<CountDownLatchInfo>();
        for (Map.Entry latchEntry : this.latches.entrySet()) {
            String name = (String)latchEntry.getKey();
            if (this.nodeEngine.getPartitionService().getPartitionId(StringPartitioningStrategy.getPartitionKey(name)) != event.getPartitionId()) continue;
            data.add((CountDownLatchInfo)latchEntry.getValue());
        }
        return data.isEmpty() ? null : new CountDownLatchReplicationOperation(data);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearPartition(event.getPartitionId());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearPartition(event.getPartitionId());
        }
    }

    private void clearPartition(int partitionId) {
        Iterator iter = this.latches.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (this.nodeEngine.getPartitionService().getPartitionId(StringPartitioningStrategy.getPartitionKey(name)) != partitionId) continue;
            iter.remove();
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.clearPartition(partitionId);
    }

    public CountDownLatchInfo getLatch(String name) {
        return (CountDownLatchInfo)this.latches.get(name);
    }

    public boolean containsLatch(String name) {
        return this.latches.containsKey(name);
    }

    public void add(CountDownLatchInfo latch) {
        this.latches.put(latch.getName(), latch);
    }
}

