/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public class KeywordTokenizer
extends Tokenizer {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private boolean done;
    private final char[] buffer;

    public KeywordTokenizer(Reader input) {
        this(input, 256);
    }

    public KeywordTokenizer(Reader input, int bufferSize) {
        super(input);
        this.buffer = new char[bufferSize];
        this.done = false;
    }

    public Token next() throws IOException {
        if (!this.done) {
            int length;
            this.done = true;
            StringBuffer buffer = new StringBuffer();
            while ((length = this.input.read(this.buffer)) != -1) {
                buffer.append(this.buffer, 0, length);
            }
            String text = buffer.toString();
            return new Token(text, 0, text.length());
        }
        return null;
    }
}

