/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.services;

import f00f.net.irc.martyr.IRCConnection;
import f00f.net.irc.martyr.commands.ChannelModeCommand;
import f00f.net.irc.martyr.commands.JoinCommand;
import f00f.net.irc.martyr.commands.PingCommand;
import f00f.net.irc.martyr.commands.PongCommand;
import java.util.Observable;
import java.util.Observer;

public class AutoResponder
implements Observer {
    private IRCConnection connection;
    private boolean enabled = false;

    public AutoResponder(IRCConnection connection) {
        this.connection = connection;
        this.enable();
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.connection.addCommandObserver(this);
        this.enabled = true;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.connection.removeCommandObserver(this);
        this.enabled = false;
    }

    public void update(Observable observer, Object updated) {
        JoinCommand join;
        if (updated instanceof PingCommand) {
            PingCommand ping = (PingCommand)updated;
            String response = ping.getPingSource();
            this.connection.sendCommand(new PongCommand(response));
        } else if (updated instanceof JoinCommand && (join = (JoinCommand)updated).weJoined(this.connection.getClientState())) {
            this.connection.sendCommand(new ChannelModeCommand(join.getChannel()));
        }
    }
}

