/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.PredicateSet;
import org.jaxen.expr.Step;
import org.jaxen.expr.Visitor;
import org.jaxen.expr.iter.IterableAxis;
import org.jaxen.saxpath.Axis;
import org.jaxen.util.IdentityHashMap;

public abstract class DefaultStep
implements Step {
    private IterableAxis axis;
    private PredicateSet predicates;
    private static final Object PRESENT = new Object();

    public DefaultStep(IterableAxis axis, PredicateSet predicates) {
        this.axis = axis;
        this.predicates = predicates;
    }

    public void addPredicate(Predicate predicate) {
        this.predicates.addPredicate(predicate);
    }

    public List getPredicates() {
        return this.predicates.getPredicates();
    }

    public PredicateSet getPredicateSet() {
        return this.predicates;
    }

    public int getAxis() {
        return this.axis.value();
    }

    public IterableAxis getIterableAxis() {
        return this.axis;
    }

    public String getAxisName() {
        return Axis.lookup(this.getAxis());
    }

    public String getText() {
        return this.predicates.getText();
    }

    public String toString() {
        return this.getIterableAxis() + " " + super.toString();
    }

    public void simplify() {
        this.predicates.simplify();
    }

    public Iterator axisIterator(Object contextNode, ContextSupport support) throws UnsupportedAxisException {
        return this.getIterableAxis().iterator(contextNode, support);
    }

    public List evaluate(Context context) throws JaxenException {
        List contextNodeSet = context.getNodeSet();
        IdentityHashMap unique = new IdentityHashMap();
        int contextSize = contextNodeSet.size();
        ArrayList interimSet = new ArrayList();
        ArrayList newNodeSet = new ArrayList();
        Object eachContextNode = null;
        int i = 0;
        while (i < contextSize) {
            eachContextNode = contextNodeSet.get(i);
            Iterator axisNodeIter = this.axisIterator(eachContextNode, context.getContextSupport());
            if (axisNodeIter != null) {
                Object eachAxisNode = null;
                while (axisNodeIter.hasNext()) {
                    eachAxisNode = axisNodeIter.next();
                    if (!this.matches(eachAxisNode, context.getContextSupport()) || unique.containsKey(eachAxisNode)) continue;
                    unique.put(eachAxisNode, PRESENT);
                    interimSet.add(eachAxisNode);
                }
                newNodeSet.addAll(this.getPredicateSet().evaluatePredicates(interimSet, context.getContextSupport()));
                interimSet.clear();
            }
            ++i;
        }
        return newNodeSet;
    }

    public abstract boolean matches(Object var1, ContextSupport var2) throws JaxenException;

    public abstract void accept(Visitor var1);
}

