/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class Os
implements Condition {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String PATH_SEP = System.getProperty("path.separator");
    private String family;
    private String name;
    private String version;
    private String arch;

    public void setFamily(String string) {
        this.family = string.toLowerCase(Locale.US);
    }

    public void setName(String string) {
        this.name = string.toLowerCase(Locale.US);
    }

    public void setArch(String string) {
        this.arch = string.toLowerCase(Locale.US);
    }

    public void setVersion(String string) {
        this.version = string.toLowerCase(Locale.US);
    }

    public boolean eval() throws BuildException {
        return Os.isOs(this.family, this.name, this.arch, this.version);
    }

    public static boolean isFamily(String string) {
        return Os.isOs(string, null, null, null);
    }

    public static boolean isName(String string) {
        return Os.isOs(null, string, null, null);
    }

    public static boolean isArch(String string) {
        return Os.isOs(null, null, string, null);
    }

    public static boolean isVersion(String string) {
        return Os.isOs(null, null, null, string);
    }

    public static boolean isOs(String string, String string2, String string3, String string4) {
        boolean bl = false;
        if (string != null || string2 != null || string3 != null || string4 != null) {
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = true;
            if (string != null) {
                if (string.equals("windows")) {
                    boolean bl6 = false;
                    if (OS_NAME.indexOf("windows") > -1) {
                        bl6 = true;
                    }
                    bl2 = bl6;
                } else if (string.equals("os/2")) {
                    boolean bl7 = false;
                    if (OS_NAME.indexOf("os/2") > -1) {
                        bl7 = true;
                    }
                    bl2 = bl7;
                } else if (string.equals("netware")) {
                    boolean bl8 = false;
                    if (OS_NAME.indexOf("netware") > -1) {
                        bl8 = true;
                    }
                    bl2 = bl8;
                } else if (string.equals("dos")) {
                    boolean bl9 = false;
                    if (PATH_SEP.equals(";") && !Os.isFamily("netware")) {
                        bl9 = true;
                    }
                    bl2 = bl9;
                } else if (string.equals("mac")) {
                    boolean bl10 = false;
                    if (OS_NAME.indexOf("mac") > -1) {
                        bl10 = true;
                    }
                    bl2 = bl10;
                } else if (string.equals("tandem")) {
                    boolean bl11 = false;
                    if (OS_NAME.indexOf("nonstop_kernel") > -1) {
                        bl11 = true;
                    }
                    bl2 = bl11;
                } else if (string.equals("unix")) {
                    boolean bl12 = false;
                    if (PATH_SEP.equals(":") && !Os.isFamily("openvms") && (!Os.isFamily("mac") || OS_NAME.endsWith("x"))) {
                        bl12 = true;
                    }
                    bl2 = bl12;
                } else if (string.equals("win9x")) {
                    boolean bl13 = false;
                    if (Os.isFamily("windows") && (OS_NAME.indexOf("95") >= 0 || OS_NAME.indexOf("98") >= 0 || OS_NAME.indexOf("me") >= 0 || OS_NAME.indexOf("ce") >= 0)) {
                        bl13 = true;
                    }
                    bl2 = bl13;
                } else if (string.equals("z/os")) {
                    boolean bl14 = false;
                    if (OS_NAME.indexOf("z/os") > -1 || OS_NAME.indexOf("os/390") > -1) {
                        bl14 = true;
                    }
                    bl2 = bl14;
                } else if (string.equals("os/400")) {
                    boolean bl15 = false;
                    if (OS_NAME.indexOf("os/400") > -1) {
                        bl15 = true;
                    }
                    bl2 = bl15;
                } else if (string.equals("openvms")) {
                    boolean bl16 = false;
                    if (OS_NAME.indexOf("openvms") > -1) {
                        bl16 = true;
                    }
                    bl2 = bl16;
                } else {
                    throw new BuildException("Don't know how to detect os family \"" + string + '\"');
                }
            }
            if (string2 != null) {
                bl3 = string2.equals(OS_NAME);
            }
            if (string3 != null) {
                bl4 = string3.equals(OS_ARCH);
            }
            if (string4 != null) {
                bl5 = string4.equals(OS_VERSION);
            }
            boolean bl17 = false;
            if (bl2 && bl3 && bl4 && bl5) {
                bl17 = true;
            }
            bl = bl17;
        }
        return bl;
    }

    public Os() {
    }

    public Os(String string) {
        this.setFamily(string);
    }
}

