/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.media.Duration;
import javax.media.Time;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergingPushDataSource
extends PushDataSource {
    protected final List<PushDataSource> sources;

    public MergingPushDataSource(List<PushDataSource> sources) {
        this.sources = sources;
    }

    @Override
    public void connect() throws IOException {
        for (PushDataSource source : this.sources) {
            source.connect();
        }
    }

    @Override
    public void disconnect() {
        for (PushDataSource source : this.sources) {
            source.disconnect();
        }
    }

    @Override
    public String getContentType() {
        for (int i = 0; i < this.sources.size(); ++i) {
            if (this.sources.get(i).getContentType().equals(this.sources.get(0).getContentType())) continue;
            return "application.mixed-data";
        }
        return this.sources.get(0).getContentType();
    }

    @Override
    public Object getControl(String controlType) {
        for (PushDataSource source : this.sources) {
            Object control = source.getControl(controlType);
            if (control == null) continue;
            return control;
        }
        return null;
    }

    @Override
    public Object[] getControls() {
        ArrayList<Object> controls = new ArrayList<Object>();
        for (PushDataSource source : this.sources) {
            for (Object control : source.getControls()) {
                controls.add(control);
            }
        }
        return controls.toArray(new Object[0]);
    }

    @Override
    public Time getDuration() {
        ArrayList<Time> durations = new ArrayList<Time>();
        for (PushDataSource source : this.sources) {
            durations.add(source.getDuration());
        }
        for (Time duration : durations) {
            if (duration.getNanoseconds() != Duration.DURATION_UNKNOWN.getNanoseconds()) continue;
            return Duration.DURATION_UNKNOWN;
        }
        for (Time duration : durations) {
            if (duration.getNanoseconds() != Duration.DURATION_UNBOUNDED.getNanoseconds()) continue;
            return Duration.DURATION_UNBOUNDED;
        }
        long max = -1L;
        for (Time duration : durations) {
            if (duration.getNanoseconds() <= max) continue;
            max = duration.getNanoseconds();
        }
        if (max < 0L) {
            return Duration.DURATION_UNKNOWN;
        }
        return new Time(max);
    }

    @Override
    public PushSourceStream[] getStreams() {
        ArrayList<PushSourceStream> streams = new ArrayList<PushSourceStream>();
        for (PushDataSource source : this.sources) {
            for (PushSourceStream stream : source.getStreams()) {
                streams.add(stream);
            }
        }
        return streams.toArray(new PushSourceStream[0]);
    }

    @Override
    public void start() throws IOException {
        for (PushDataSource source : this.sources) {
            source.start();
        }
    }

    @Override
    public void stop() throws IOException {
        for (PushDataSource source : this.sources) {
            source.stop();
        }
    }
}

