/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.walls;

import java.io.File;
import net.sf.antcontrib.walls.CompileWithWalls;
import net.sf.antcontrib.walls.Package;
import net.sf.antcontrib.walls.Walls;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

class WallsFileHandler
extends HandlerBase {
    private final CompileWithWalls compilewithwalls;
    private File file = null;
    private Walls walls = null;
    private Locator locator = null;

    WallsFileHandler(CompileWithWalls compileWithWalls, File file) {
        this.compilewithwalls = compileWithWalls;
        this.file = file;
    }

    public InputSource resolveEntity(String string, String string2) {
        this.compilewithwalls.log("publicId=" + string + " systemId=" + string2, 3);
        return null;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXParseException {
        if (string.equals("walls")) {
            if (attributeList.getLength() > 0) {
                throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", no attributes allowed for walls element", this.locator);
            }
            this.walls = this.compilewithwalls.createWalls();
        } else if (string.equals("package")) {
            this.handlePackage(attributeList);
        } else {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", Unexpected element \"" + string + "\"", this.locator);
        }
    }

    private void handlePackage(AttributeList attributeList) throws SAXParseException {
        if (this.walls == null) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", package element must be nested in a walls element", this.locator);
        }
        String string = attributeList.getValue("name");
        String string2 = attributeList.getValue("package");
        String string3 = attributeList.getValue("depends");
        if (string == null) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", package element must contain the 'name' attribute", this.locator);
        }
        if (string2 == null) {
            throw new SAXParseException("Error in file=" + this.file.getAbsolutePath() + ", package element must contain the 'package' attribute", this.locator);
        }
        Package package_ = new Package();
        package_.setName(string);
        package_.setPackage(string2);
        if (string3 != null) {
            package_.setDepends(string3);
        }
        this.walls.addConfiguredPackage(package_);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }
}

